/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ApplicationProtocolConfig;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.CipherSuiteFilter;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ClientAuth;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.Java7SslParametersUtils;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.JdkAlpnApplicationProtocolNegotiator;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.JdkDefaultApplicationProtocolNegotiator;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.JdkNpnApplicationProtocolNegotiator;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.SslContext;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.SslUtils;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ReferenceCountUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.EmptyArrays;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSessionContext;

public class JdkSslContext
extends SslContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(JdkSslContext.class);
    private static final String[] DEFAULT_PROTOCOLS;
    private static final List<String> DEFAULT_CIPHERS;
    private static final List<String> DEFAULT_CIPHERS_NON_TLSV13;
    private static final Set<String> SUPPORTED_CIPHERS;
    private static final Set<String> SUPPORTED_CIPHERS_NON_TLSV13;
    private static final Provider DEFAULT_PROVIDER;
    private final String[] protocols;
    private final String[] cipherSuites;
    private final List<String> unmodifiableCipherSuites;
    private final JdkApplicationProtocolNegotiator apn;
    private final ClientAuth clientAuth;
    private final SSLContext sslContext;
    private final boolean isClient;
    private final String endpointIdentificationAlgorithm;

    private static String[] defaultProtocols(SSLContext sSLContext, SSLEngine sSLEngine) {
        String[] stringArray = sSLContext.getDefaultSSLParameters().getProtocols();
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        Collections.addAll(hashSet, stringArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        SslUtils.addIfSupported(hashSet, arrayList, "TLSv1.3", "TLSv1.2", "TLSv1.1", "TLSv1");
        if (!arrayList.isEmpty()) {
            return arrayList.toArray(EmptyArrays.EMPTY_STRINGS);
        }
        return sSLEngine.getEnabledProtocols();
    }

    private static Set<String> supportedCiphers(SSLEngine sSLEngine) {
        String[] stringArray = sSLEngine.getSupportedCipherSuites();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            linkedHashSet.add(string);
            if (!string.startsWith("SSL_")) continue;
            String string2 = "TLS_" + string.substring("SSL_".length());
            try {
                sSLEngine.setEnabledCipherSuites(new String[]{string2});
                linkedHashSet.add(string2);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return linkedHashSet;
    }

    private static List<String> defaultCiphers(SSLEngine sSLEngine, Set<String> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SslUtils.addIfSupported(set, arrayList, SslUtils.DEFAULT_CIPHER_SUITES);
        SslUtils.useFallbackCiphersIfDefaultIsEmpty(arrayList, sSLEngine.getEnabledCipherSuites());
        return arrayList;
    }

    private static boolean isTlsV13Supported(String[] stringArray) {
        for (String string : stringArray) {
            if (!"TLSv1.3".equals(string)) continue;
            return true;
        }
        return false;
    }

    JdkSslContext(SSLContext sSLContext, boolean bl2, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator, ClientAuth clientAuth, String[] stringArray, boolean bl3) {
        this(sSLContext, bl2, iterable, cipherSuiteFilter, jdkApplicationProtocolNegotiator, clientAuth, stringArray, bl3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JdkSslContext(SSLContext sSLContext, boolean bl2, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator, ClientAuth clientAuth, String[] stringArray, boolean bl3, String string) {
        super(bl3);
        List<String> list;
        Set<String> set;
        this.apn = ObjectUtil.checkNotNull(jdkApplicationProtocolNegotiator, "apn");
        this.clientAuth = ObjectUtil.checkNotNull(clientAuth, "clientAuth");
        this.sslContext = ObjectUtil.checkNotNull(sSLContext, "sslContext");
        this.endpointIdentificationAlgorithm = string;
        if (DEFAULT_PROVIDER.equals(sSLContext.getProvider())) {
            String[] stringArray2 = this.protocols = stringArray == null ? DEFAULT_PROTOCOLS : stringArray;
            if (JdkSslContext.isTlsV13Supported(this.protocols)) {
                set = SUPPORTED_CIPHERS;
                list = DEFAULT_CIPHERS;
            } else {
                set = SUPPORTED_CIPHERS_NON_TLSV13;
                list = DEFAULT_CIPHERS_NON_TLSV13;
            }
        } else {
            SSLEngine sSLEngine = sSLContext.createSSLEngine();
            try {
                this.protocols = stringArray == null ? JdkSslContext.defaultProtocols(sSLContext, sSLEngine) : stringArray;
                set = JdkSslContext.supportedCiphers(sSLEngine);
                list = JdkSslContext.defaultCiphers(sSLEngine, set);
                if (!JdkSslContext.isTlsV13Supported(this.protocols)) {
                    for (String string2 : SslUtils.DEFAULT_TLSV13_CIPHER_SUITES) {
                        set.remove(string2);
                        list.remove(string2);
                    }
                }
            }
            finally {
                ReferenceCountUtil.release(sSLEngine);
            }
        }
        this.cipherSuites = ObjectUtil.checkNotNull(cipherSuiteFilter, "cipherFilter").filterCipherSuites(iterable, list, set);
        this.unmodifiableCipherSuites = Collections.unmodifiableList(Arrays.asList(this.cipherSuites));
        this.isClient = bl2;
    }

    public final SSLContext context() {
        return this.sslContext;
    }

    @Override
    public final boolean isClient() {
        return this.isClient;
    }

    @Override
    public final SSLSessionContext sessionContext() {
        if (this.isServer()) {
            return this.context().getServerSessionContext();
        }
        return this.context().getClientSessionContext();
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator, String string, int n2) {
        return this.configureAndWrapEngine(this.context().createSSLEngine(string, n2), byteBufAllocator);
    }

    private SSLEngine configureAndWrapEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator) {
        sSLEngine.setEnabledCipherSuites(this.cipherSuites);
        sSLEngine.setEnabledProtocols(this.protocols);
        sSLEngine.setUseClientMode(this.isClient());
        if (this.isServer()) {
            switch (this.clientAuth) {
                case OPTIONAL: {
                    sSLEngine.setWantClientAuth(true);
                    break;
                }
                case REQUIRE: {
                    sSLEngine.setNeedClientAuth(true);
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new Error("Unknown auth " + (Object)((Object)this.clientAuth));
                }
            }
        }
        this.configureEndpointVerification(sSLEngine);
        JdkApplicationProtocolNegotiator.SslEngineWrapperFactory sslEngineWrapperFactory = this.apn.wrapperFactory();
        if (sslEngineWrapperFactory instanceof JdkApplicationProtocolNegotiator.AllocatorAwareSslEngineWrapperFactory) {
            return ((JdkApplicationProtocolNegotiator.AllocatorAwareSslEngineWrapperFactory)sslEngineWrapperFactory).wrapSslEngine(sSLEngine, byteBufAllocator, this.apn, this.isServer());
        }
        return sslEngineWrapperFactory.wrapSslEngine(sSLEngine, this.apn, this.isServer());
    }

    private void configureEndpointVerification(SSLEngine sSLEngine) {
        int n2 = PlatformDependent.javaVersion();
        if (n2 >= 7) {
            SSLParameters sSLParameters = sSLEngine.getSSLParameters();
            Java7SslParametersUtils.setEndpointIdentificationAlgorithm(sSLParameters, this.endpointIdentificationAlgorithm);
            sSLEngine.setSSLParameters(sSLParameters);
        }
    }

    static JdkApplicationProtocolNegotiator toNegotiator(ApplicationProtocolConfig applicationProtocolConfig, boolean bl2) {
        if (applicationProtocolConfig == null) {
            return JdkDefaultApplicationProtocolNegotiator.INSTANCE;
        }
        switch (applicationProtocolConfig.protocol()) {
            case NONE: {
                return JdkDefaultApplicationProtocolNegotiator.INSTANCE;
            }
            case ALPN: {
                if (bl2) {
                    switch (applicationProtocolConfig.selectorFailureBehavior()) {
                        case FATAL_ALERT: {
                            return new JdkAlpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                        }
                        case NO_ADVERTISE: {
                            return new JdkAlpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                        }
                    }
                    throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectorFailureBehavior()) + " failure behavior");
                }
                switch (applicationProtocolConfig.selectedListenerFailureBehavior()) {
                    case ACCEPT: {
                        return new JdkAlpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                    }
                    case FATAL_ALERT: {
                        return new JdkAlpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                    }
                }
                throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " failure behavior");
            }
            case NPN: {
                if (bl2) {
                    switch (applicationProtocolConfig.selectedListenerFailureBehavior()) {
                        case ACCEPT: {
                            return new JdkNpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                        }
                        case FATAL_ALERT: {
                            return new JdkNpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                        }
                    }
                    throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " failure behavior");
                }
                switch (applicationProtocolConfig.selectorFailureBehavior()) {
                    case FATAL_ALERT: {
                        return new JdkNpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                    }
                    case NO_ADVERTISE: {
                        return new JdkNpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                    }
                }
                throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectorFailureBehavior()) + " failure behavior");
            }
        }
        throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.protocol()) + " protocol");
    }

    static {
        Defaults defaults = new Defaults();
        defaults.init();
        DEFAULT_PROVIDER = defaults.defaultProvider;
        DEFAULT_PROTOCOLS = defaults.defaultProtocols;
        SUPPORTED_CIPHERS = defaults.supportedCiphers;
        DEFAULT_CIPHERS = defaults.defaultCiphers;
        DEFAULT_CIPHERS_NON_TLSV13 = defaults.defaultCiphersNonTLSv13;
        SUPPORTED_CIPHERS_NON_TLSV13 = defaults.supportedCiphersNonTLSv13;
        if (logger.isDebugEnabled()) {
            logger.debug("Default protocols (JDK): {} ", (Object)Arrays.asList(DEFAULT_PROTOCOLS));
            logger.debug("Default cipher suites (JDK): {}", (Object)DEFAULT_CIPHERS);
        }
    }

    private static final class Defaults {
        String[] defaultProtocols;
        List<String> defaultCiphers;
        List<String> defaultCiphersNonTLSv13;
        Set<String> supportedCiphers;
        Set<String> supportedCiphersNonTLSv13;
        Provider defaultProvider;

        private Defaults() {
        }

        void init() {
            SSLContext sSLContext;
            try {
                sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(null, null, null);
            }
            catch (Exception exception) {
                throw new Error("failed to initialize the default SSL context", exception);
            }
            this.defaultProvider = sSLContext.getProvider();
            SSLEngine sSLEngine = sSLContext.createSSLEngine();
            this.defaultProtocols = JdkSslContext.defaultProtocols(sSLContext, sSLEngine);
            this.supportedCiphers = Collections.unmodifiableSet(JdkSslContext.supportedCiphers(sSLEngine));
            this.defaultCiphers = Collections.unmodifiableList(JdkSslContext.defaultCiphers(sSLEngine, this.supportedCiphers));
            ArrayList<String> arrayList = new ArrayList<String>(this.defaultCiphers);
            arrayList.removeAll(Arrays.asList(SslUtils.DEFAULT_TLSV13_CIPHER_SUITES));
            this.defaultCiphersNonTLSv13 = Collections.unmodifiableList(arrayList);
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.supportedCiphers);
            linkedHashSet.removeAll(Arrays.asList(SslUtils.DEFAULT_TLSV13_CIPHER_SUITES));
            this.supportedCiphersNonTLSv13 = Collections.unmodifiableSet(linkedHashSet);
        }
    }
}

