/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.util;

import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.FastThreadLocal;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.FastThreadLocalThread;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectPool;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class Recycler<T> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Recycler.class);
    private static final EnhancedHandle<?> NOOP_HANDLE = new EnhancedHandle<Object>(){

        @Override
        public void recycle(Object object) {
        }

        @Override
        public void unguardedRecycle(Object object) {
        }

        public String toString() {
            return "NOOP_HANDLE";
        }
    };
    private static final int DEFAULT_MAX_CAPACITY_PER_THREAD;
    private static final int RATIO;
    private static final int DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD;
    private static final boolean BLOCKING_POOL;
    private static final boolean BATCH_FAST_TL_ONLY;
    private final int maxCapacityPerThread;
    private final int interval;
    private final int chunkSize;
    private final FastThreadLocal<LocalPool<T>> threadLocal = new FastThreadLocal<LocalPool<T>>(){

        @Override
        protected LocalPool<T> initialValue() {
            return new LocalPool(Recycler.this.maxCapacityPerThread, Recycler.this.interval, Recycler.this.chunkSize);
        }

        @Override
        protected void onRemoval(LocalPool<T> localPool) throws Exception {
            super.onRemoval(localPool);
            MessagePassingQueue messagePassingQueue = localPool.pooledHandles;
            localPool.pooledHandles = null;
            localPool.owner = null;
            messagePassingQueue.clear();
        }
    };

    protected Recycler() {
        this(DEFAULT_MAX_CAPACITY_PER_THREAD);
    }

    protected Recycler(int n2) {
        this(n2, RATIO, DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD);
    }

    protected Recycler(int n2, int n3, int n4) {
        this.interval = Math.max(0, n3);
        if (n2 <= 0) {
            this.maxCapacityPerThread = 0;
            this.chunkSize = 0;
        } else {
            this.maxCapacityPerThread = Math.max(4, n2);
            this.chunkSize = Math.max(2, Math.min(n4, this.maxCapacityPerThread >> 1));
        }
    }

    public final T get() {
        Object object;
        if (this.maxCapacityPerThread == 0) {
            return (T)this.newObject(NOOP_HANDLE);
        }
        LocalPool<T> localPool = this.threadLocal.get();
        DefaultHandle<T> defaultHandle = localPool.claim();
        if (defaultHandle == null) {
            defaultHandle = localPool.newHandle();
            if (defaultHandle != null) {
                object = this.newObject(defaultHandle);
                defaultHandle.set(object);
            } else {
                object = this.newObject(NOOP_HANDLE);
            }
        } else {
            object = defaultHandle.get();
        }
        return object;
    }

    protected abstract T newObject(Handle<T> var1);

    static {
        int n2 = SystemPropertyUtil.getInt("com.gradle.scan.plugin.internal.dep.io.netty.recycler.maxCapacityPerThread", SystemPropertyUtil.getInt("com.gradle.scan.plugin.internal.dep.io.netty.recycler.maxCapacity", 4096));
        if (n2 < 0) {
            n2 = 4096;
        }
        DEFAULT_MAX_CAPACITY_PER_THREAD = n2;
        DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD = SystemPropertyUtil.getInt("com.gradle.scan.plugin.internal.dep.io.netty.recycler.chunkSize", 32);
        RATIO = Math.max(0, SystemPropertyUtil.getInt("com.gradle.scan.plugin.internal.dep.io.netty.recycler.ratio", 8));
        BLOCKING_POOL = SystemPropertyUtil.getBoolean("com.gradle.scan.plugin.internal.dep.io.netty.recycler.blocking", false);
        BATCH_FAST_TL_ONLY = SystemPropertyUtil.getBoolean("com.gradle.scan.plugin.internal.dep.io.netty.recycler.batchFastThreadLocalOnly", true);
        if (logger.isDebugEnabled()) {
            if (DEFAULT_MAX_CAPACITY_PER_THREAD == 0) {
                logger.debug("-Dio.netty.recycler.maxCapacityPerThread: disabled");
                logger.debug("-Dio.netty.recycler.ratio: disabled");
                logger.debug("-Dio.netty.recycler.chunkSize: disabled");
                logger.debug("-Dio.netty.recycler.blocking: disabled");
                logger.debug("-Dio.netty.recycler.batchFastThreadLocalOnly: disabled");
            } else {
                logger.debug("-Dio.netty.recycler.maxCapacityPerThread: {}", (Object)DEFAULT_MAX_CAPACITY_PER_THREAD);
                logger.debug("-Dio.netty.recycler.ratio: {}", (Object)RATIO);
                logger.debug("-Dio.netty.recycler.chunkSize: {}", (Object)DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD);
                logger.debug("-Dio.netty.recycler.blocking: {}", (Object)BLOCKING_POOL);
                logger.debug("-Dio.netty.recycler.batchFastThreadLocalOnly: {}", (Object)BATCH_FAST_TL_ONLY);
            }
        }
    }

    private static final class BlockingMessageQueue<T>
    implements MessagePassingQueue<T> {
        private final Queue<T> deque;
        private final int maxCapacity;

        BlockingMessageQueue(int n2) {
            this.maxCapacity = n2;
            this.deque = new ArrayDeque<T>();
        }

        public synchronized boolean offer(T t2) {
            if (this.deque.size() == this.maxCapacity) {
                return false;
            }
            return this.deque.offer(t2);
        }

        public synchronized T poll() {
            return this.deque.poll();
        }

        @Override
        public synchronized void clear() {
            this.deque.clear();
        }

        @Override
        public boolean relaxedOffer(T t2) {
            return this.offer(t2);
        }

        @Override
        public T relaxedPoll() {
            return this.poll();
        }

        @Override
        public int drain(MessagePassingQueue.Consumer<T> consumer, int n2) {
            T t2;
            int n3;
            for (n3 = 0; n3 < n2 && (t2 = this.poll()) != null; ++n3) {
                consumer.accept(t2);
            }
            return n3;
        }
    }

    private static final class LocalPool<T>
    implements MessagePassingQueue.Consumer<DefaultHandle<T>> {
        private final int ratioInterval;
        private final int chunkSize;
        private final ArrayDeque<DefaultHandle<T>> batch;
        private volatile Thread owner;
        private volatile MessagePassingQueue<DefaultHandle<T>> pooledHandles;
        private int ratioCounter;

        LocalPool(int n2, int n3, int n4) {
            this.ratioInterval = n3;
            this.chunkSize = n4;
            this.batch = new ArrayDeque(n4);
            Thread thread = Thread.currentThread();
            this.owner = !BATCH_FAST_TL_ONLY || thread instanceof FastThreadLocalThread ? thread : null;
            this.pooledHandles = BLOCKING_POOL ? new BlockingMessageQueue<DefaultHandle<T>>(n2) : (MessagePassingQueue)((Object)PlatformDependent.newMpscQueue(n4, n2));
            this.ratioCounter = n3;
        }

        DefaultHandle<T> claim() {
            DefaultHandle<T> defaultHandle;
            MessagePassingQueue<DefaultHandle<T>> messagePassingQueue = this.pooledHandles;
            if (messagePassingQueue == null) {
                return null;
            }
            if (this.batch.isEmpty()) {
                messagePassingQueue.drain(this, this.chunkSize);
            }
            if (null != (defaultHandle = this.batch.pollFirst())) {
                defaultHandle.toClaimed();
            }
            return defaultHandle;
        }

        void release(DefaultHandle<T> defaultHandle, boolean bl2) {
            if (bl2) {
                defaultHandle.toAvailable();
            } else {
                defaultHandle.unguardedToAvailable();
            }
            Thread thread = this.owner;
            if (thread != null && Thread.currentThread() == thread && this.batch.size() < this.chunkSize) {
                this.accept(defaultHandle);
            } else if (thread != null && LocalPool.isTerminated(thread)) {
                this.owner = null;
                this.pooledHandles = null;
            } else {
                MessagePassingQueue<DefaultHandle<DefaultHandle<T>>> messagePassingQueue = this.pooledHandles;
                if (messagePassingQueue != null) {
                    messagePassingQueue.relaxedOffer(defaultHandle);
                }
            }
        }

        private static boolean isTerminated(Thread thread) {
            return PlatformDependent.isJ9Jvm() ? !thread.isAlive() : thread.getState() == Thread.State.TERMINATED;
        }

        DefaultHandle<T> newHandle() {
            if (++this.ratioCounter >= this.ratioInterval) {
                this.ratioCounter = 0;
                return new DefaultHandle(this);
            }
            return null;
        }

        @Override
        public void accept(DefaultHandle<T> defaultHandle) {
            this.batch.addLast(defaultHandle);
        }
    }

    private static final class DefaultHandle<T>
    extends EnhancedHandle<T> {
        private static final AtomicIntegerFieldUpdater<DefaultHandle<?>> STATE_UPDATER;
        private volatile int state;
        private final LocalPool<T> localPool;
        private T value;

        DefaultHandle(LocalPool<T> localPool) {
            this.localPool = localPool;
        }

        @Override
        public void recycle(Object object) {
            if (object != this.value) {
                throw new IllegalArgumentException("object does not belong to handle");
            }
            this.localPool.release(this, true);
        }

        @Override
        public void unguardedRecycle(Object object) {
            if (object != this.value) {
                throw new IllegalArgumentException("object does not belong to handle");
            }
            this.localPool.release(this, false);
        }

        T get() {
            return this.value;
        }

        void set(T t2) {
            this.value = t2;
        }

        void toClaimed() {
            assert (this.state == 1);
            STATE_UPDATER.lazySet(this, 0);
        }

        void toAvailable() {
            int n2 = STATE_UPDATER.getAndSet(this, 1);
            if (n2 == 1) {
                throw new IllegalStateException("Object has been recycled already.");
            }
        }

        void unguardedToAvailable() {
            int n2 = this.state;
            if (n2 == 1) {
                throw new IllegalStateException("Object has been recycled already.");
            }
            STATE_UPDATER.lazySet(this, 1);
        }

        static {
            AtomicIntegerFieldUpdater<DefaultHandle> atomicIntegerFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultHandle.class, "state");
            STATE_UPDATER = atomicIntegerFieldUpdater;
        }
    }

    public static abstract class EnhancedHandle<T>
    implements Handle<T> {
        public abstract void unguardedRecycle(Object var1);

        private EnhancedHandle() {
        }
    }

    public static interface Handle<T>
    extends ObjectPool.Handle<T> {
    }
}

