/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.message;

import com.gradle.scan.plugin.internal.dep.org.apache.http.Header;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpVersion;
import com.gradle.scan.plugin.internal.dep.org.apache.http.ParseException;
import com.gradle.scan.plugin.internal.dep.org.apache.http.ProtocolVersion;
import com.gradle.scan.plugin.internal.dep.org.apache.http.StatusLine;
import com.gradle.scan.plugin.internal.dep.org.apache.http.message.BasicStatusLine;
import com.gradle.scan.plugin.internal.dep.org.apache.http.message.BufferedHeader;
import com.gradle.scan.plugin.internal.dep.org.apache.http.message.LineParser;
import com.gradle.scan.plugin.internal.dep.org.apache.http.message.ParserCursor;
import com.gradle.scan.plugin.internal.dep.org.apache.http.protocol.HTTP;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.Args;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.CharArrayBuffer;

public class BasicLineParser
implements LineParser {
    @Deprecated
    public static final BasicLineParser DEFAULT = new BasicLineParser();
    public static final BasicLineParser INSTANCE = new BasicLineParser();
    protected final ProtocolVersion protocol;

    public BasicLineParser(ProtocolVersion protocolVersion) {
        this.protocol = protocolVersion != null ? protocolVersion : HttpVersion.HTTP_1_1;
    }

    public BasicLineParser() {
        this(null);
    }

    public ProtocolVersion parseProtocolVersion(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) throws ParseException {
        int n2;
        int n3;
        int n4;
        Args.notNull(charArrayBuffer, "Char array buffer");
        Args.notNull(parserCursor, "Parser cursor");
        String string = this.protocol.getProtocol();
        int n5 = string.length();
        int n6 = parserCursor.getPos();
        int n7 = parserCursor.getUpperBound();
        this.skipWhitespace(charArrayBuffer, parserCursor);
        int n8 = parserCursor.getPos();
        if (n8 + n5 + 4 > n7) {
            throw new ParseException("Not a valid protocol version: " + charArrayBuffer.substring(n6, n7));
        }
        boolean bl2 = true;
        for (n4 = 0; bl2 && n4 < n5; ++n4) {
            bl2 = charArrayBuffer.charAt(n8 + n4) == string.charAt(n4);
        }
        if (bl2) {
            boolean bl3 = bl2 = charArrayBuffer.charAt(n8 + n5) == '/';
        }
        if (!bl2) {
            throw new ParseException("Not a valid protocol version: " + charArrayBuffer.substring(n6, n7));
        }
        n4 = charArrayBuffer.indexOf(46, n8 += n5 + 1, n7);
        if (n4 == -1) {
            throw new ParseException("Invalid protocol version number: " + charArrayBuffer.substring(n6, n7));
        }
        try {
            n3 = Integer.parseInt(charArrayBuffer.substringTrimmed(n8, n4));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Invalid protocol major version number: " + charArrayBuffer.substring(n6, n7));
        }
        n8 = n4 + 1;
        int n9 = charArrayBuffer.indexOf(32, n8, n7);
        if (n9 == -1) {
            n9 = n7;
        }
        try {
            n2 = Integer.parseInt(charArrayBuffer.substringTrimmed(n8, n9));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Invalid protocol minor version number: " + charArrayBuffer.substring(n6, n7));
        }
        parserCursor.updatePos(n9);
        return this.createProtocolVersion(n3, n2);
    }

    protected ProtocolVersion createProtocolVersion(int n2, int n3) {
        return this.protocol.forVersion(n2, n3);
    }

    @Override
    public boolean hasProtocolVersion(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        int n2;
        Args.notNull(charArrayBuffer, "Char array buffer");
        Args.notNull(parserCursor, "Parser cursor");
        String string = this.protocol.getProtocol();
        int n3 = string.length();
        if (charArrayBuffer.length() < n3 + 4) {
            return false;
        }
        if (n2 < 0) {
            n2 = charArrayBuffer.length() - 4 - n3;
        } else if (n2 == 0) {
            for (n2 = parserCursor.getPos(); n2 < charArrayBuffer.length() && HTTP.isWhitespace(charArrayBuffer.charAt(n2)); ++n2) {
            }
        }
        if (n2 + n3 + 4 > charArrayBuffer.length()) {
            return false;
        }
        boolean bl2 = true;
        for (int i2 = 0; bl2 && i2 < n3; ++i2) {
            bl2 = charArrayBuffer.charAt(n2 + i2) == string.charAt(i2);
        }
        if (bl2) {
            bl2 = charArrayBuffer.charAt(n2 + n3) == '/';
        }
        return bl2;
    }

    @Override
    public StatusLine parseStatusLine(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) throws ParseException {
        Args.notNull(charArrayBuffer, "Char array buffer");
        Args.notNull(parserCursor, "Parser cursor");
        int n2 = parserCursor.getPos();
        int n3 = parserCursor.getUpperBound();
        try {
            int n4;
            ProtocolVersion protocolVersion = this.parseProtocolVersion(charArrayBuffer, parserCursor);
            this.skipWhitespace(charArrayBuffer, parserCursor);
            int n5 = parserCursor.getPos();
            int n6 = charArrayBuffer.indexOf(32, n5, n3);
            if (n6 < 0) {
                n6 = n3;
            }
            String string = charArrayBuffer.substringTrimmed(n5, n6);
            for (int i2 = 0; i2 < string.length(); ++i2) {
                if (Character.isDigit(string.charAt(i2))) continue;
                throw new ParseException("Status line contains invalid status code: " + charArrayBuffer.substring(n2, n3));
            }
            try {
                n4 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Status line contains invalid status code: " + charArrayBuffer.substring(n2, n3));
            }
            n5 = n6;
            String string2 = n5 < n3 ? charArrayBuffer.substringTrimmed(n5, n3) : "";
            return this.createStatusLine(protocolVersion, n4, string2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ParseException("Invalid status line: " + charArrayBuffer.substring(n2, n3));
        }
    }

    protected StatusLine createStatusLine(ProtocolVersion protocolVersion, int n2, String string) {
        return new BasicStatusLine(protocolVersion, n2, string);
    }

    @Override
    public Header parseHeader(CharArrayBuffer charArrayBuffer) throws ParseException {
        return new BufferedHeader(charArrayBuffer);
    }

    protected void skipWhitespace(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        int n2;
        int n3 = parserCursor.getUpperBound();
        for (n2 = parserCursor.getPos(); n2 < n3 && HTTP.isWhitespace(charArrayBuffer.charAt(n2)); ++n2) {
        }
        parserCursor.updatePos(n2);
    }
}

