/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.filter;

import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.filter.AnnotationInspector;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.filter.GlobPattern;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ClassRetryMatcher {
    private static final List<String> IMPLICIT_INCLUDE_ANNOTATION_CLASSES = Collections.unmodifiableList(Arrays.asList("spock.lang.Stepwise", "com.gradle.enterprise.testing.annotations.ClassRetry", "com.gradle.develocity.testing.annotations.ClassRetry"));
    private final AnnotationInspector annotationInspector;
    private final Set<GlobPattern> includeClasses;
    private final Set<GlobPattern> includeAnnotationClasses;

    public ClassRetryMatcher(AnnotationInspector annotationInspector, Collection<String> collection, Collection<String> collection2) {
        HashSet<String> hashSet = new HashSet<String>(IMPLICIT_INCLUDE_ANNOTATION_CLASSES);
        hashSet.addAll(collection2);
        this.annotationInspector = annotationInspector;
        this.includeClasses = ClassRetryMatcher.toPatterns(collection);
        this.includeAnnotationClasses = ClassRetryMatcher.toPatterns(hashSet);
    }

    public boolean retryWholeClass(String string) {
        if (ClassRetryMatcher.anyMatch(this.includeClasses, string)) {
            return true;
        }
        if (!this.includeAnnotationClasses.isEmpty()) {
            Set<String> set = this.annotationInspector.getClassAnnotations(string);
            return !set.isEmpty() && ClassRetryMatcher.anyMatch(this.includeAnnotationClasses, set);
        }
        return false;
    }

    private static boolean anyMatch(Set<GlobPattern> set, String string) {
        return ClassRetryMatcher.anyMatch(set, Collections.singleton(string));
    }

    private static boolean anyMatch(Set<GlobPattern> set, Set<String> set2) {
        return set.stream().anyMatch(globPattern -> set2.stream().anyMatch(globPattern::matches));
    }

    private static Set<GlobPattern> toPatterns(Collection<String> collection) {
        return collection.stream().map(GlobPattern::from).collect(Collectors.toSet());
    }
}

