/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm;

import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.ByteVector;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.ModuleVisitor;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.SymbolTable;

final class ModuleWriter
extends ModuleVisitor {
    private final SymbolTable symbolTable;
    private final int moduleNameIndex;
    private final int moduleFlags;
    private final int moduleVersionIndex;
    private int requiresCount;
    private final ByteVector requires;
    private int exportsCount;
    private final ByteVector exports;
    private int opensCount;
    private final ByteVector opens;
    private int usesCount;
    private final ByteVector usesIndex;
    private int providesCount;
    private final ByteVector provides;
    private int packageCount;
    private final ByteVector packageIndex;
    private int mainClassIndex;

    ModuleWriter(SymbolTable symbolTable, int n2, int n3, int n4) {
        super(589824);
        this.symbolTable = symbolTable;
        this.moduleNameIndex = n2;
        this.moduleFlags = n3;
        this.moduleVersionIndex = n4;
        this.requires = new ByteVector();
        this.exports = new ByteVector();
        this.opens = new ByteVector();
        this.usesIndex = new ByteVector();
        this.provides = new ByteVector();
        this.packageIndex = new ByteVector();
    }

    public void visitMainClass(String string) {
        this.mainClassIndex = this.symbolTable.addConstantClass((String)string).index;
    }

    public void visitPackage(String string) {
        this.packageIndex.putShort(this.symbolTable.addConstantPackage((String)string).index);
        ++this.packageCount;
    }

    public void visitRequire(String string, int n2, String string2) {
        this.requires.putShort(this.symbolTable.addConstantModule((String)string).index).putShort(n2).putShort(string2 == null ? 0 : this.symbolTable.addConstantUtf8(string2));
        ++this.requiresCount;
    }

    public void visitExport(String string, int n2, String ... stringArray) {
        this.exports.putShort(this.symbolTable.addConstantPackage((String)string).index).putShort(n2);
        if (stringArray == null) {
            this.exports.putShort(0);
        } else {
            this.exports.putShort(stringArray.length);
            for (String string2 : stringArray) {
                this.exports.putShort(this.symbolTable.addConstantModule((String)string2).index);
            }
        }
        ++this.exportsCount;
    }

    public void visitOpen(String string, int n2, String ... stringArray) {
        this.opens.putShort(this.symbolTable.addConstantPackage((String)string).index).putShort(n2);
        if (stringArray == null) {
            this.opens.putShort(0);
        } else {
            this.opens.putShort(stringArray.length);
            for (String string2 : stringArray) {
                this.opens.putShort(this.symbolTable.addConstantModule((String)string2).index);
            }
        }
        ++this.opensCount;
    }

    public void visitUse(String string) {
        this.usesIndex.putShort(this.symbolTable.addConstantClass((String)string).index);
        ++this.usesCount;
    }

    public void visitProvide(String string, String ... stringArray) {
        this.provides.putShort(this.symbolTable.addConstantClass((String)string).index);
        this.provides.putShort(stringArray.length);
        for (String string2 : stringArray) {
            this.provides.putShort(this.symbolTable.addConstantClass((String)string2).index);
        }
        ++this.providesCount;
    }

    public void visitEnd() {
    }
}

