/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.mac;

import com.gradle.scan.plugin.internal.dep.oshi.hardware.CentralProcessor;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.common.AbstractCentralProcessor;
import com.gradle.scan.plugin.internal.dep.oshi.jna.ByRef;
import com.gradle.scan.plugin.internal.dep.oshi.jna.Struct;
import com.gradle.scan.plugin.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.scan.plugin.internal.dep.oshi.util.FormatUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.Memoizer;
import com.gradle.scan.plugin.internal.dep.oshi.util.ParseUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.Util;
import com.gradle.scan.plugin.internal.dep.oshi.util.platform.mac.SysctlUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.tuples.Quartet;
import com.sun.jna.Native;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import com.sun.jna.platform.mac.SystemB;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MacCentralProcessor
extends AbstractCentralProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(MacCentralProcessor.class);
    private static final Set<String> ARM_P_CORES = Stream.of("apple,firestorm arm,v8", "apple,avalanche arm,v8", "apple,everest arm,v8").collect(Collectors.toSet());
    private static final Pattern CPU_N = Pattern.compile("^cpu(\\d+)");
    private final Supplier<String> vendor = Memoizer.memoize(MacCentralProcessor::platformExpert);
    private final boolean isArmCpu = this.isArmCpu();
    private long performanceCoreFrequency = 2400000000L;
    private long efficiencyCoreFrequency = 2400000000L;

    MacCentralProcessor() {
    }

    @Override
    protected CentralProcessor.ProcessorIdentifier queryProcessorId() {
        String string;
        String string2;
        int n2;
        String string3;
        String string4;
        String string5;
        String string6 = SysctlUtil.sysctl("machdep.cpu.brand_string", "");
        if (string6.startsWith("Apple")) {
            int l2;
            string5 = this.vendor.get();
            string4 = "0";
            string3 = "0";
            if (this.isArmCpu) {
                n2 = 0x100000C;
                int bl2 = ParseUtil.getFirstIntValue(string6);
                switch (bl2) {
                    case 2: {
                        l2 = -634136515;
                        break;
                    }
                    case 3: {
                        l2 = -2023363094;
                        break;
                    }
                    default: {
                        l2 = 458787763;
                        break;
                    }
                }
            } else {
                n2 = SysctlUtil.sysctl("hw.cputype", 0);
                l2 = SysctlUtil.sysctl("hw.cpufamily", 0);
            }
            string2 = String.format(Locale.ROOT, "0x%08x", l2);
            string = String.format(Locale.ROOT, "%08x%08x", n2, l2);
        } else {
            string5 = SysctlUtil.sysctl("machdep.cpu.vendor", "");
            n2 = SysctlUtil.sysctl("machdep.cpu.stepping", -1);
            string4 = n2 < 0 ? "" : Integer.toString(n2);
            n2 = SysctlUtil.sysctl("machdep.cpu.model", -1);
            string3 = n2 < 0 ? "" : Integer.toString(n2);
            n2 = SysctlUtil.sysctl("machdep.cpu.family", -1);
            string2 = n2 < 0 ? "" : Integer.toString(n2);
            long l2 = 0L;
            l2 |= (long)SysctlUtil.sysctl("machdep.cpu.signature", 0);
            string = String.format(Locale.ROOT, "%016x", l2 |= (SysctlUtil.sysctl("machdep.cpu.feature_bits", 0L) & 0xFFFFFFFFFFFFFFFFL) << 32);
        }
        if (this.isArmCpu) {
            this.calculateNominalFrequencies();
        }
        long l3 = this.isArmCpu ? this.performanceCoreFrequency : SysctlUtil.sysctl("hw.cpufrequency", 0L);
        boolean bl2 = SysctlUtil.sysctl("hw.cpu64bit_capable", 0) != 0;
        return new CentralProcessor.ProcessorIdentifier(string5, string6, string2, string3, string4, string, bl2, l3);
    }

    @Override
    protected Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>, List<String>> initProcessorCounts() {
        int n3;
        int n4 = SysctlUtil.sysctl("hw.logicalcpu", 1);
        int n5 = SysctlUtil.sysctl("hw.physicalcpu", 1);
        int n6 = SysctlUtil.sysctl("hw.packages", 1);
        ArrayList<CentralProcessor.LogicalProcessor> arrayList = new ArrayList<CentralProcessor.LogicalProcessor>(n4);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i2 = 0; i2 < n4; ++i2) {
            n3 = i2 * n5 / n4;
            int n7 = i2 * n6 / n4;
            arrayList.add(new CentralProcessor.LogicalProcessor(i2, n3, n7));
            hashSet.add((n7 << 16) + n3);
        }
        Map<Integer, String> map = MacCentralProcessor.queryCompatibleStrings();
        n3 = SysctlUtil.sysctl("hw.nperflevels", 1, false);
        List list = hashSet.stream().sorted().map(n2 -> {
            String string = map.getOrDefault(n2, "").toLowerCase(Locale.ROOT);
            int n3 = ARM_P_CORES.contains(string) ? 1 : 0;
            return new CentralProcessor.PhysicalProcessor(n2 >> 16, (int)(n2 & 0xFFFF), n3, string);
        }).collect(Collectors.toList());
        List<CentralProcessor.ProcessorCache> list2 = MacCentralProcessor.orderedProcCaches(this.getCacheValues(n3));
        List<String> list3 = this.getFeatureFlagsFromSysctl();
        return new Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>, List<String>>(arrayList, list, list2, list3);
    }

    private Set<CentralProcessor.ProcessorCache> getCacheValues(int n2) {
        int n3 = (int)SysctlUtil.sysctl("hw.cachelinesize", 0L);
        int n4 = SysctlUtil.sysctl("machdep.cpu.cache.L1_associativity", 0, false);
        int n5 = SysctlUtil.sysctl("machdep.cpu.cache.L2_associativity", 0, false);
        HashSet<CentralProcessor.ProcessorCache> hashSet = new HashSet<CentralProcessor.ProcessorCache>();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n6 = SysctlUtil.sysctl("hw.perflevel" + i2 + ".l1icachesize", 0, false);
            if (n6 > 0) {
                hashSet.add(new CentralProcessor.ProcessorCache(1, n4, n3, (long)n6, CentralProcessor.ProcessorCache.Type.INSTRUCTION));
            }
            if ((n6 = SysctlUtil.sysctl("hw.perflevel" + i2 + ".l1dcachesize", 0, false)) > 0) {
                hashSet.add(new CentralProcessor.ProcessorCache(1, n4, n3, (long)n6, CentralProcessor.ProcessorCache.Type.DATA));
            }
            if ((n6 = SysctlUtil.sysctl("hw.perflevel" + i2 + ".l2cachesize", 0, false)) > 0) {
                hashSet.add(new CentralProcessor.ProcessorCache(2, n5, n3, (long)n6, CentralProcessor.ProcessorCache.Type.UNIFIED));
            }
            if ((n6 = SysctlUtil.sysctl("hw.perflevel" + i2 + ".l3cachesize", 0, false)) <= 0) continue;
            hashSet.add(new CentralProcessor.ProcessorCache(3, 0, n3, (long)n6, CentralProcessor.ProcessorCache.Type.UNIFIED));
        }
        return hashSet;
    }

    private List<String> getFeatureFlagsFromSysctl() {
        List list = Arrays.asList("features", "extfeatures", "leaf7_features").stream().map(string -> {
            String string2 = "machdep.cpu." + string;
            String string3 = SysctlUtil.sysctl(string2, "", false);
            return Util.isBlank(string3) ? null : string2 + ": " + string3;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return list.isEmpty() ? ExecutingCommand.runNative("sysctl -a hw.optional") : list;
    }

    @Override
    public long[] querySystemCpuLoadTicks() {
        long[] lArray = new long[CentralProcessor.TickType.values().length];
        int n2 = SystemB.INSTANCE.mach_host_self();
        try (Struct.CloseableHostCpuLoadInfo closeableHostCpuLoadInfo = new Struct.CloseableHostCpuLoadInfo();
             ByRef.CloseableIntByReference closeableIntByReference = new ByRef.CloseableIntByReference(closeableHostCpuLoadInfo.size());){
            if (0 != SystemB.INSTANCE.host_statistics(n2, 3, closeableHostCpuLoadInfo, closeableIntByReference)) {
                LOG.error("Failed to get System CPU ticks. Error code: {} ", (Object)Native.getLastError());
                long[] lArray2 = lArray;
                return lArray2;
            }
            lArray[CentralProcessor.TickType.USER.getIndex()] = closeableHostCpuLoadInfo.cpu_ticks[0];
            lArray[CentralProcessor.TickType.NICE.getIndex()] = closeableHostCpuLoadInfo.cpu_ticks[3];
            lArray[CentralProcessor.TickType.SYSTEM.getIndex()] = closeableHostCpuLoadInfo.cpu_ticks[1];
            lArray[CentralProcessor.TickType.IDLE.getIndex()] = closeableHostCpuLoadInfo.cpu_ticks[2];
        }
        return lArray;
    }

    @Override
    public long[] queryCurrentFreq() {
        if (this.isArmCpu) {
            HashMap hashMap = new HashMap();
            this.getPhysicalProcessors().stream().forEach(physicalProcessor -> hashMap.put(physicalProcessor.getPhysicalProcessorNumber(), physicalProcessor.getEfficiency() > 0 ? this.performanceCoreFrequency : this.efficiencyCoreFrequency));
            return this.getLogicalProcessors().stream().map(CentralProcessor.LogicalProcessor::getPhysicalProcessorNumber).map(n2 -> hashMap.getOrDefault(n2, this.performanceCoreFrequency)).mapToLong(l2 -> l2).toArray();
        }
        return new long[]{this.getProcessorIdentifier().getVendorFreq()};
    }

    @Override
    public long queryMaxFreq() {
        if (this.isArmCpu) {
            return this.performanceCoreFrequency;
        }
        return SysctlUtil.sysctl("hw.cpufrequency_max", this.getProcessorIdentifier().getVendorFreq());
    }

    @Override
    public long[][] queryProcessorCpuLoadTicks() {
        long[][] lArray = new long[this.getLogicalProcessorCount()][CentralProcessor.TickType.values().length];
        int n2 = SystemB.INSTANCE.mach_host_self();
        try (ByRef.CloseableIntByReference closeableIntByReference = new ByRef.CloseableIntByReference();
             ByRef.CloseablePointerByReference closeablePointerByReference = new ByRef.CloseablePointerByReference();
             ByRef.CloseableIntByReference closeableIntByReference2 = new ByRef.CloseableIntByReference();){
            if (0 != SystemB.INSTANCE.host_processor_info(n2, 2, closeableIntByReference, closeablePointerByReference, closeableIntByReference2)) {
                LOG.error("Failed to update CPU Load. Error code: {}", (Object)Native.getLastError());
                long[][] lArray2 = lArray;
                return lArray2;
            }
            int[] nArray = closeablePointerByReference.getValue().getIntArray(0L, closeableIntByReference2.getValue());
            for (int i2 = 0; i2 < closeableIntByReference.getValue(); ++i2) {
                int n3 = i2 * 4;
                lArray[i2][CentralProcessor.TickType.USER.getIndex()] = FormatUtil.getUnsignedInt(nArray[n3 + 0]);
                lArray[i2][CentralProcessor.TickType.NICE.getIndex()] = FormatUtil.getUnsignedInt(nArray[n3 + 3]);
                lArray[i2][CentralProcessor.TickType.SYSTEM.getIndex()] = FormatUtil.getUnsignedInt(nArray[n3 + 1]);
                lArray[i2][CentralProcessor.TickType.IDLE.getIndex()] = FormatUtil.getUnsignedInt(nArray[n3 + 2]);
            }
        }
        return lArray;
    }

    @Override
    public long queryContextSwitches() {
        return 0L;
    }

    @Override
    public long queryInterrupts() {
        return 0L;
    }

    private static String platformExpert() {
        String string = null;
        IOKit.IOService iOService = IOKitUtil.getMatchingService("IOPlatformExpertDevice");
        if (iOService != null) {
            byte[] byArray = iOService.getByteArrayProperty("manufacturer");
            if (byArray != null) {
                string = Native.toString(byArray, StandardCharsets.UTF_8);
            }
            iOService.release();
        }
        return Util.isBlank(string) ? "Apple Inc." : string;
    }

    private static Map<Integer, String> queryCompatibleStrings() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        IOKit.IOIterator iOIterator = IOKitUtil.getMatchingServices("IOPlatformDevice");
        if (iOIterator != null) {
            IOKit.IORegistryEntry iORegistryEntry = iOIterator.next();
            while (iORegistryEntry != null) {
                Matcher matcher = CPU_N.matcher(iORegistryEntry.getName().toLowerCase(Locale.ROOT));
                if (matcher.matches()) {
                    int n2 = ParseUtil.parseIntOrDefault(matcher.group(1), 0);
                    byte[] byArray = iORegistryEntry.getByteArrayProperty("compatible");
                    if (byArray != null) {
                        hashMap.put(n2, new String(byArray, StandardCharsets.UTF_8).replace('\u0000', ' ').trim());
                    }
                }
                iORegistryEntry.release();
                iORegistryEntry = iOIterator.next();
            }
            iOIterator.release();
        }
        return hashMap;
    }

    private boolean isArmCpu() {
        return this.getPhysicalProcessors().stream().map(CentralProcessor.PhysicalProcessor::getIdString).anyMatch(string -> string.contains("arm"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateNominalFrequencies() {
        IOKit.IOIterator iOIterator = IOKitUtil.getMatchingServices("AppleARMIODevice");
        if (iOIterator != null) {
            try {
                IOKit.IORegistryEntry iORegistryEntry = iOIterator.next();
                try {
                    while (true) {
                        if (iORegistryEntry != null) {
                            if (iORegistryEntry.getName().equalsIgnoreCase("pmgr")) {
                                this.performanceCoreFrequency = this.getMaxFreqFromByteArray(iORegistryEntry.getByteArrayProperty("voltage-states5-sram"));
                                this.efficiencyCoreFrequency = this.getMaxFreqFromByteArray(iORegistryEntry.getByteArrayProperty("voltage-states1-sram"));
                                return;
                            }
                            iORegistryEntry.release();
                            iORegistryEntry = iOIterator.next();
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    if (iORegistryEntry != null) {
                        iORegistryEntry.release();
                    }
                }
            }
            finally {
                iOIterator.release();
            }
        }
    }

    private long getMaxFreqFromByteArray(byte[] byArray) {
        if (byArray != null && byArray.length >= 8) {
            byte[] byArray2 = Arrays.copyOfRange(byArray, byArray.length - 8, byArray.length - 4);
            return ParseUtil.byteArrayToLong(byArray2, 4, false);
        }
        return 2400000000L;
    }
}

