/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl;

import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.JWTDecodeException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl.NullClaim;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Claim;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonProcessingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

class JsonNodeClaim
implements Claim {
    private final ObjectReader objectReader;
    private final JsonNode data;

    private JsonNodeClaim(JsonNode node, ObjectReader objectReader) {
        this.data = node;
        this.objectReader = objectReader;
    }

    @Override
    public Boolean asBoolean() {
        return !this.data.isBoolean() ? null : Boolean.valueOf(this.data.asBoolean());
    }

    @Override
    public Integer asInt() {
        return !this.data.isNumber() ? null : Integer.valueOf(this.data.asInt());
    }

    @Override
    public Long asLong() {
        return !this.data.isNumber() ? null : Long.valueOf(this.data.asLong());
    }

    @Override
    public Double asDouble() {
        return !this.data.isNumber() ? null : Double.valueOf(this.data.asDouble());
    }

    @Override
    public String asString() {
        return !this.data.isTextual() ? null : this.data.asText();
    }

    @Override
    public Date asDate() {
        if (!this.data.canConvertToLong()) {
            return null;
        }
        long seconds = this.data.asLong();
        return new Date(seconds * 1000L);
    }

    @Override
    public <T> List<T> asList(Class<T> tClazz) throws JWTDecodeException {
        if (!this.data.isArray()) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            try {
                list.add(this.objectReader.treeToValue(this.data.get(i2), tClazz));
                continue;
            }
            catch (JsonProcessingException e2) {
                throw new JWTDecodeException("Couldn't map the Claim's array contents to " + tClazz.getSimpleName(), e2);
            }
        }
        return list;
    }

    @Override
    public <T> T as(Class<T> tClazz) throws JWTDecodeException {
        try {
            return this.objectReader.treeAsTokens(this.data).readValueAs(tClazz);
        }
        catch (IOException e2) {
            throw new JWTDecodeException("Couldn't map the Claim value to " + tClazz.getSimpleName(), e2);
        }
    }

    @Override
    public boolean isNull() {
        return false;
    }

    static Claim extractClaim(String claimName, Map<String, JsonNode> tree, ObjectReader objectReader) {
        JsonNode node = tree.get(claimName);
        return JsonNodeClaim.claimFromNode(node, objectReader);
    }

    static Claim claimFromNode(JsonNode node, ObjectReader objectReader) {
        if (node == null || node.isNull() || node.isMissingNode()) {
            return new NullClaim();
        }
        return new JsonNodeClaim(node, objectReader);
    }
}

