/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.std;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanDescription;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.EnumValues;
import java.io.IOException;

@JacksonStdImpl
public class EnumSerializer
extends StdScalarSerializer<Enum<?>>
implements ContextualSerializer {
    protected final EnumValues _values;
    protected final Boolean _serializeAsIndex;

    public EnumSerializer(EnumValues v2, Boolean serializeAsIndex) {
        super(v2.getEnumClass(), false);
        this._values = v2;
        this._serializeAsIndex = serializeAsIndex;
    }

    public static EnumSerializer construct(Class<?> enumClass, SerializationConfig config, BeanDescription beanDesc, JsonFormat.Value format) {
        EnumValues v2 = EnumValues.constructFromName(config, enumClass);
        Boolean serializeAsIndex = EnumSerializer._isShapeWrittenUsingIndex(enumClass, format, true, null);
        return new EnumSerializer(v2, serializeAsIndex);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        Class type;
        Boolean serializeAsIndex;
        JsonFormat.Value format = this.findFormatOverrides(serializers, property, this.handledType());
        if (format != null && (serializeAsIndex = EnumSerializer._isShapeWrittenUsingIndex(type = this.handledType(), format, false, this._serializeAsIndex)) != this._serializeAsIndex) {
            return new EnumSerializer(this._values, serializeAsIndex);
        }
        return this;
    }

    @Override
    public final void serialize(Enum<?> en, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (this._serializeAsIndex(serializers)) {
            gen.writeNumber(en.ordinal());
            return;
        }
        if (serializers.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
            gen.writeString(en.toString());
            return;
        }
        gen.writeString(this._values.serializedValueFor(en));
    }

    protected final boolean _serializeAsIndex(SerializerProvider serializers) {
        if (this._serializeAsIndex != null) {
            return this._serializeAsIndex;
        }
        return serializers.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
    }

    protected static Boolean _isShapeWrittenUsingIndex(Class<?> enumClass, JsonFormat.Value format, boolean fromClass, Boolean defaultValue) {
        JsonFormat.Shape shape;
        JsonFormat.Shape shape2 = shape = format == null ? null : format.getShape();
        if (shape == null) {
            return defaultValue;
        }
        if (shape == JsonFormat.Shape.ANY || shape == JsonFormat.Shape.SCALAR) {
            return defaultValue;
        }
        if (shape == JsonFormat.Shape.STRING || shape == JsonFormat.Shape.NATURAL) {
            return Boolean.FALSE;
        }
        if (shape.isNumeric() || shape == JsonFormat.Shape.ARRAY) {
            return Boolean.TRUE;
        }
        throw new IllegalArgumentException(String.format("Unsupported serialization shape (%s) for Enum %s, not supported as %s annotation", new Object[]{shape, enumClass.getName(), fromClass ? "class" : "property"}));
    }
}

