/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.graph;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterables;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.UnmodifiableIterator;
import com.gradle.maven.extension.internal.dep.com.google.common.graph.BaseGraph;
import com.gradle.maven.extension.internal.dep.com.google.common.graph.Network;
import com.gradle.maven.extension.internal.dep.com.google.common.graph.SuccessorsFunction;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public abstract class Traverser<N> {
    public static <N> Traverser<N> forTree(SuccessorsFunction<N> tree) {
        Preconditions.checkNotNull(tree);
        if (tree instanceof BaseGraph) {
            Preconditions.checkArgument(((BaseGraph)tree).isDirected(), "Undirected graphs can never be trees.");
        }
        if (tree instanceof Network) {
            Preconditions.checkArgument(((Network)tree).isDirected(), "Undirected networks can never be trees.");
        }
        return new TreeTraverser<N>(tree);
    }

    public abstract Iterable<N> depthFirstPreOrder(N var1);

    private Traverser() {
    }

    private static final class TreeTraverser<N>
    extends Traverser<N> {
        private final SuccessorsFunction<N> tree;

        TreeTraverser(SuccessorsFunction<N> tree) {
            this.tree = Preconditions.checkNotNull(tree);
        }

        @Override
        public Iterable<N> depthFirstPreOrder(N startNode) {
            Preconditions.checkNotNull(startNode);
            return this.depthFirstPreOrder((Iterable<? extends N>)ImmutableSet.of(startNode));
        }

        @Override
        public Iterable<N> depthFirstPreOrder(final Iterable<? extends N> startNodes) {
            Preconditions.checkNotNull(startNodes);
            if (Iterables.isEmpty(startNodes)) {
                return ImmutableSet.of();
            }
            for (N node : startNodes) {
                this.checkThatNodeIsInTree(node);
            }
            return new Iterable<N>(){

                @Override
                public Iterator<N> iterator() {
                    return new DepthFirstPreOrderIterator(startNodes);
                }
            };
        }

        private void checkThatNodeIsInTree(N startNode) {
            this.tree.successors(startNode);
        }

        private final class DepthFirstPreOrderIterator
        extends UnmodifiableIterator<N> {
            private final Deque<Iterator<? extends N>> stack = new ArrayDeque();

            DepthFirstPreOrderIterator(Iterable<? extends N> roots) {
                this.stack.addLast(roots.iterator());
            }

            @Override
            public boolean hasNext() {
                return !this.stack.isEmpty();
            }

            @Override
            public N next() {
                Iterator childIterator;
                Iterator iterator = this.stack.getLast();
                Object result = Preconditions.checkNotNull(iterator.next());
                if (!iterator.hasNext()) {
                    this.stack.removeLast();
                }
                if ((childIterator = TreeTraverser.this.tree.successors(result).iterator()).hasNext()) {
                    this.stack.addLast(childIterator);
                }
                return result;
            }
        }
    }
}

