/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.primitives;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;

public final class Longs {
    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    private static int indexOf(long[] array, long target, int start, int end) {
        for (int i2 = start; i2 < end; ++i2) {
            if (array[i2] != target) continue;
            return i2;
        }
        return -1;
    }

    private static int lastIndexOf(long[] array, long target, int start, int end) {
        for (int i2 = end - 1; i2 >= start; --i2) {
            if (array[i2] != target) continue;
            return i2;
        }
        return -1;
    }

    public static Long tryParse(String string, int radix) {
        int digit;
        int index;
        if (Preconditions.checkNotNull(string).isEmpty()) {
            return null;
        }
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException("radix must be between MIN_RADIX and MAX_RADIX but was " + radix);
        }
        boolean negative = string.charAt(0) == '-';
        int n2 = index = negative ? 1 : 0;
        if (index == string.length()) {
            return null;
        }
        if ((digit = AsciiDigits.digit(string.charAt(index++))) < 0 || digit >= radix) {
            return null;
        }
        long accum = -digit;
        long cap = Long.MIN_VALUE / (long)radix;
        while (index < string.length()) {
            if ((digit = AsciiDigits.digit(string.charAt(index++))) < 0 || digit >= radix || accum < cap) {
                return null;
            }
            if ((accum *= (long)radix) < Long.MIN_VALUE + (long)digit) {
                return null;
            }
            accum -= (long)digit;
        }
        if (negative) {
            return accum;
        }
        if (accum == Long.MIN_VALUE) {
            return null;
        }
        return -accum;
    }

    public static List<Long> asList(long ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new LongArrayAsList(backingArray);
    }

    private static class LongArrayAsList
    extends AbstractList<Long>
    implements Serializable,
    RandomAccess {
        final long[] array;
        final int start;
        final int end;

        LongArrayAsList(long[] array) {
            this(array, 0, array.length);
        }

        LongArrayAsList(long[] array, int start, int end) {
            this.array = array;
            this.start = start;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Long get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return this.array[this.start + index];
        }

        public Spliterator.OfLong spliterator() {
            return Spliterators.spliterator(this.array, this.start, this.end, 0);
        }

        @Override
        public boolean contains(Object target) {
            return target instanceof Long && Longs.indexOf(this.array, (Long)target, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object target) {
            int i2;
            if (target instanceof Long && (i2 = Longs.indexOf(this.array, (Long)target, this.start, this.end)) >= 0) {
                return i2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object target) {
            int i2;
            if (target instanceof Long && (i2 = Longs.lastIndexOf(this.array, (Long)target, this.start, this.end)) >= 0) {
                return i2 - this.start;
            }
            return -1;
        }

        @Override
        public Long set(int index, Long element) {
            Preconditions.checkElementIndex(index, this.size());
            long oldValue = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element);
            return oldValue;
        }

        @Override
        public List<Long> subList(int fromIndex, int toIndex) {
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new LongArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof LongArrayAsList) {
                LongArrayAsList that = (LongArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i2 = 0; i2 < size; ++i2) {
                    if (this.array[this.start + i2] == that.array[that.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int result = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                result = 31 * result + Longs.hashCode(this.array[i2]);
            }
            return result;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 10);
            builder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                builder.append(", ").append(this.array[i2]);
            }
            return builder.append(']').toString();
        }
    }

    static final class AsciiDigits {
        private static final byte[] asciiDigits;

        static int digit(char c2) {
            return c2 < '\u0080' ? asciiDigits[c2] : -1;
        }

        static {
            int i2;
            byte[] result = new byte[128];
            Arrays.fill(result, (byte)-1);
            for (i2 = 0; i2 < 10; ++i2) {
                result[48 + i2] = (byte)i2;
            }
            for (i2 = 0; i2 < 26; ++i2) {
                result[65 + i2] = (byte)(10 + i2);
                result[97 + i2] = (byte)(10 + i2);
            }
            asciiDigits = result;
        }
    }
}

