/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.IOCase;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.AbstractFileFilter;
import java.io.File;
import java.io.Serializable;

public class SuffixFileFilter
extends AbstractFileFilter
implements Serializable {
    private final String[] suffixes;
    private final IOCase caseSensitivity;

    public SuffixFileFilter(String suffix) {
        this(suffix, IOCase.SENSITIVE);
    }

    public SuffixFileFilter(String suffix, IOCase caseSensitivity) {
        if (suffix == null) {
            throw new IllegalArgumentException("The suffix must not be null");
        }
        this.suffixes = new String[]{suffix};
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    @Override
    public boolean accept(File file) {
        String name = file.getName();
        for (String suffix : this.suffixes) {
            if (!this.caseSensitivity.checkEndsWith(name, suffix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File file, String name) {
        for (String suffix : this.suffixes) {
            if (!this.caseSensitivity.checkEndsWith(name, suffix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append("(");
        if (this.suffixes != null) {
            for (int i2 = 0; i2 < this.suffixes.length; ++i2) {
                if (i2 > 0) {
                    buffer.append(",");
                }
                buffer.append(this.suffixes[i2]);
            }
        }
        buffer.append(")");
        return buffer.toString();
    }
}

