/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.codehaus.plexus.components.interactivity;

import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.components.interactivity.InputHandler;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.components.interactivity.OutputHandler;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.components.interactivity.Prompter;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.components.interactivity.PrompterException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;

public class DefaultPrompter
implements Prompter {
    private OutputHandler outputHandler;
    private InputHandler inputHandler;

    public String prompt(String message) throws PrompterException {
        try {
            this.writePrompt(message);
        }
        catch (IOException e2) {
            throw new PrompterException("Failed to present prompt", e2);
        }
        try {
            return this.inputHandler.readLine();
        }
        catch (IOException e3) {
            throw new PrompterException("Failed to read user response", e3);
        }
    }

    public String prompt(String message, String defaultReply) throws PrompterException {
        try {
            this.writePrompt(this.formatMessage(message, null, defaultReply));
        }
        catch (IOException e2) {
            throw new PrompterException("Failed to present prompt", e2);
        }
        try {
            String line = this.inputHandler.readLine();
            if (StringUtils.isEmpty((String)line)) {
                line = defaultReply;
            }
            return line;
        }
        catch (IOException e3) {
            throw new PrompterException("Failed to read user response", e3);
        }
    }

    public String prompt(String message, List possibleValues, String defaultReply) throws PrompterException {
        String line;
        String formattedMessage = this.formatMessage(message, possibleValues, defaultReply);
        do {
            try {
                this.writePrompt(formattedMessage);
            }
            catch (IOException e2) {
                throw new PrompterException("Failed to present prompt", e2);
            }
            try {
                line = this.inputHandler.readLine();
            }
            catch (IOException e3) {
                throw new PrompterException("Failed to read user response", e3);
            }
            if (StringUtils.isEmpty((String)line)) {
                line = defaultReply;
            }
            if (line == null || possibleValues.contains(line)) continue;
            try {
                this.outputHandler.writeLine("Invalid selection.");
            }
            catch (IOException e4) {
                throw new PrompterException("Failed to present feedback", e4);
            }
        } while (line == null || !possibleValues.contains(line));
        return line;
    }

    public String prompt(String message, List possibleValues) throws PrompterException {
        return this.prompt(message, possibleValues, null);
    }

    public String promptForPassword(String message) throws PrompterException {
        try {
            this.writePrompt(message);
        }
        catch (IOException e2) {
            throw new PrompterException("Failed to present prompt", e2);
        }
        try {
            return this.inputHandler.readPassword();
        }
        catch (IOException e3) {
            throw new PrompterException("Failed to read user response", e3);
        }
    }

    private String formatMessage(String message, List possibleValues, String defaultReply) {
        StringBuffer formatted = new StringBuffer(message.length() * 2);
        formatted.append(message);
        if (possibleValues != null && !possibleValues.isEmpty()) {
            formatted.append(" (");
            Iterator it = possibleValues.iterator();
            while (it.hasNext()) {
                String possibleValue = (String)it.next();
                formatted.append(possibleValue);
                if (!it.hasNext()) continue;
                formatted.append('/');
            }
            formatted.append(')');
        }
        if (defaultReply != null) {
            formatted.append(' ').append(defaultReply).append(": ");
        }
        return formatted.toString();
    }

    private void writePrompt(String message) throws IOException {
        this.outputHandler.write(message + ": ");
    }

    public void showMessage(String message) throws PrompterException {
        try {
            this.writePrompt(message);
        }
        catch (IOException e2) {
            throw new PrompterException("Failed to present prompt", e2);
        }
    }
}

