/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support;

import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.ConversionService;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.ConditionalGenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.GenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support.ConversionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.StringJoiner;

final class CollectionToStringConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public CollectionToStringConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Collection.class, String.class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return ConversionUtils.canConvertElements(sourceType.getElementTypeDescriptor(), targetType, this.conversionService);
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        Collection sourceCollection = (Collection)source;
        if (sourceCollection.isEmpty()) {
            return "";
        }
        StringJoiner sj = new StringJoiner(",");
        for (Object sourceElement : sourceCollection) {
            Object targetElement = this.conversionService.convert(sourceElement, sourceType.elementTypeDescriptor(sourceElement), targetType);
            sj.add(String.valueOf(targetElement));
        }
        return sj.toString();
    }
}

