/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.eventmodel;

import java.util.function.Supplier;

public final class Preconditions {
    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, Supplier<Object> errorMessage) {
        if (reference == null) {
            throw new NullPointerException(errorMessage.get().toString());
        }
        return reference;
    }

    public static void checkState(boolean expression, Supplier<Object> errorMessage) {
        if (!expression) {
            throw new IllegalStateException(errorMessage.get().toString());
        }
    }

    public static void checkArgument(boolean expression, Supplier<Object> errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage.get().toString());
        }
    }

    public static int checkNonNegative(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(name + " cannot be negative but was: " + value);
        }
        return value;
    }

    public static String checkNotEmpty(String value, String name) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("'" + name + "' cannot be empty");
        }
        return value;
    }

    private Preconditions() {
    }
}

