/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import com.gradle.protocols.ServerResponseBase;
import com.gradle.publish.Config;
import com.gradle.publish.DependenciesBuilder;
import com.gradle.publish.GroupId;
import com.gradle.publish.Hasher;
import com.gradle.publish.MavenCoordinates;
import com.gradle.publish.OAuthHttpClient;
import com.gradle.publish.PluginBundleExtension;
import com.gradle.publish.PluginConfig;
import com.gradle.publish.PluginPublishValidator;
import com.gradle.publish.PomWriter;
import com.gradle.publish.PropertiesStore;
import com.gradle.publish.ResponseUtil;
import com.gradle.publish.Util;
import com.gradle.publish.protocols.v1.models.ClientPostRequest;
import com.gradle.publish.protocols.v1.models.publish.ArtifactTypeCodec;
import com.gradle.publish.protocols.v1.models.publish.BuildMetadata;
import com.gradle.publish.protocols.v1.models.publish.PublishActivateRequest;
import com.gradle.publish.protocols.v1.models.publish.PublishArtifact;
import com.gradle.publish.protocols.v1.models.publish.PublishMavenCoordinates;
import com.gradle.publish.protocols.v1.models.publish.PublishNewVersionRequest;
import com.gradle.publish.protocols.v1.models.publish.PublishNewVersionResponse;
import com.gradle.publish.upload.Uploader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.model.Dependency;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.publish.tasks.GenerateModuleMetadata;
import org.gradle.api.resources.MissingResourceException;
import org.gradle.api.tasks.TaskAction;

public class PublishTask
extends DefaultTask {
    public static final String GRADLE_PUBLISH_SECRET = "gradle.publish.secret";
    public static final String GRADLE_PUBLISH_KEY = "gradle.publish.key";
    public static final String GRADLE_PUBLISH_SECRET_ENV = "GRADLE_PUBLISH_SECRET";
    public static final String GRADLE_PUBLISH_KEY_ENV = "GRADLE_PUBLISH_KEY";
    private static final String SKIP_NAMESPACE_CHECK_PROPERTY = "gradle.publish.skip.namespace.check";
    private static final String MAVEN_PUBLICATION_NAME = "pluginMaven";
    private static final String MAVEN_PUBLISH_POM_TASK_NAME = "generatePomFileForPluginMavenPublication";
    private static final String MAVEN_PUBLISH_GMM_TASK_NAME = "generateMetadataFileForPluginMavenPublication";
    private static final Logger LOGGER = Logging.getLogger(PublishTask.class);
    private final Config ghConfig = new Config(this.getProject());
    private File pomFile;
    private File gmmFile;
    private PluginBundleExtension bundleConfig;
    private PluginPublishValidator validator;
    private boolean useAutomatedPublishing;

    @TaskAction
    void publish() throws Exception {
        this.validator = new PluginPublishValidator(this.getProject().getVersion().toString(), System.getProperty(SKIP_NAMESPACE_CHECK_PROPERTY, "false").equals("true"), this.ghConfig.versionOverride());
        this.validator.validateBundle(this.bundleConfig);
        List<PublishNewVersionRequest> requests = this.buildPublishRequests();
        this.validatePluginDescriptors(requests);
        PublishMavenCoordinates mavenCoords = this.ensurePomIsAvailable();
        Map<PublishArtifact, File> artifacts = this.collectArtifacts();
        this.publishToPortal(requests, mavenCoords, artifacts);
    }

    private void validatePluginDescriptors(List<PublishNewVersionRequest> requests) {
        File artifactFile = this.findMainArtifact();
        try (ZipFile zip = new ZipFile(artifactFile);){
            for (PublishNewVersionRequest request : requests) {
                this.validatePluginDescriptor(zip, request.getPluginId());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to validate plugin jar " + artifactFile.getPath(), e);
        }
    }

    private void validatePluginDescriptor(ZipFile zip, String pluginId) throws IOException {
        String resPath = String.format("META-INF/gradle-plugins/%s.properties", pluginId);
        ZipEntry descriptorEntry = zip.getEntry(resPath);
        if (descriptorEntry == null) {
            throw new IllegalArgumentException(String.format("No plugin descriptor for plugin ID '%s'.\nCreate a 'META-INF/gradle-plugins/%s.properties' file with a 'implementation-class' property pointing to the plugin class implementation.", pluginId, pluginId));
        }
        Properties descriptor = new Properties();
        descriptor.load(zip.getInputStream(descriptorEntry));
        String pluginClassName = descriptor.getProperty("implementation-class");
        if (Util.isBlank(pluginClassName)) {
            throw new IllegalArgumentException(String.format("Plugin descriptor for plugin ID '%s' does not specify a plugin\nclass with the implementation-class property", pluginId));
        }
        String pluginClassResourcePath = pluginClassName.replace('.', '/').concat(".class");
        if (zip.getEntry(pluginClassResourcePath) == null) {
            throw new IllegalArgumentException(String.format("Plugin descriptor for plugin ID '%s' specifies a plugin\nclass '%s' that is not present in the jar file", pluginId, pluginClassName));
        }
    }

    private File findMainArtifact() {
        Configuration archivesConfiguration = this.getProject().getConfigurations().getByName("archives");
        for (org.gradle.api.artifacts.PublishArtifact artifact : archivesConfiguration.getAllArtifacts()) {
            if (!Util.isBlank(artifact.getClassifier()) || !"jar".equals(artifact.getExtension())) continue;
            return artifact.getFile();
        }
        throw new IllegalArgumentException("Cannot determine main artifact to upload - could not find jar artifact with empty classifier");
    }

    private PublishMavenCoordinates ensurePomIsAvailable() throws IOException {
        if (this.useAutomatedPublishing) {
            if (this.bundleConfig.getWithDependenciesBlock() != null) {
                LOGGER.warn("Could not reuse POM from pluginMaven publication because withDependencies() was used");
            } else if (this.bundleConfig.getMavenCoordinates() != null && !this.bundleConfig.getMavenCoordinates().isEmpty()) {
                LOGGER.warn("Could not reuse POM from pluginMaven publication because mavenCoordinates() was used");
            } else {
                GenerateMavenPom pomTask = (GenerateMavenPom)this.getProject().getTasks().getByName(MAVEN_PUBLISH_POM_TASK_NAME);
                this.pomFile = pomTask.getDestination();
                if (!this.pomFile.exists()) {
                    throw new MissingResourceException(this.pomFile.toURI(), "Could not use POM from generatePomFileForPluginMavenPublication task because it does not exist");
                }
                PublishingExtension publishing = (PublishingExtension)this.getProject().getExtensions().getByType(PublishingExtension.class);
                MavenPublication publication = (MavenPublication)publishing.getPublications().getByName(MAVEN_PUBLICATION_NAME);
                return this.validateMavenCoordinates(publication.getGroupId(), publication.getArtifactId(), publication.getVersion(), null);
            }
        }
        PublishMavenCoordinates mavenCoords = this.getMavenCoordinatesFromBundleConfig();
        this.generatePom(mavenCoords);
        return mavenCoords;
    }

    private void generatePom(PublishMavenCoordinates coords) throws IOException {
        List<Dependency> deps = new DependenciesBuilder().buildMavenDependencies(this.getProject().getConfigurations());
        if (this.bundleConfig.getWithDependenciesBlock() != null) {
            LOGGER.warn("The withDependencies block is deprecated and will be removed in the next version of the plugin-publish plugin. Please use the java-gradle-plugin and maven-publish plugins to customize the POM instead.");
            this.bundleConfig.getWithDependenciesBlock().execute(deps);
        }
        new PomWriter().writePom(this.pomFile, coords, deps);
    }

    void addAndHashArtifact(Map<PublishArtifact, File> artifacts, org.gradle.api.artifacts.PublishArtifact configuredArtifact) throws IOException {
        this.addAndHashArtifact(artifacts, configuredArtifact.getFile(), configuredArtifact.getType(), configuredArtifact.getClassifier());
    }

    void addAndHashArtifact(Map<PublishArtifact, File> artifacts, File file, String type, String classifier) throws IOException {
        if (file != null) {
            try (FileInputStream fis = new FileInputStream(file);){
                String hash = Hasher.hash(fis);
                try {
                    String artifactType = ArtifactTypeCodec.encode(type, classifier);
                    artifacts.put(new PublishArtifact(artifactType, hash), file);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Ignoring unknown artifact with type \"{}\" and classifier \"{}\".\nYou can only upload normal jars, sources jars, javadoc jars and groovydoc jars\nwith or without signatures to the Plugin Portal at this time.", (Object)type, (Object)classifier);
                }
            }
        }
    }

    private void publishToPortal(List<PublishNewVersionRequest> requests, PublishMavenCoordinates mavenCoords, Map<PublishArtifact, File> artifacts) throws Exception {
        ArrayList<PublishNewVersionResponse> apiResponses = new ArrayList<PublishNewVersionResponse>();
        for (PublishNewVersionRequest request : requests) {
            LOGGER.lifecycle("Publishing plugin {} version {}", new Object[]{request.getPluginId(), request.getPluginVersion()});
            request.setMavenCoordinates(mavenCoords);
            request.setArtifacts(new ArrayList<PublishArtifact>(artifacts.keySet()));
            PublishNewVersionResponse apiResponse = this.doSignedPost(request);
            this.handleApiResponse(request.getPluginId(), apiResponse);
            apiResponses.add(apiResponse);
        }
        LOGGER.debug("Uploading artifacts");
        this.publishArtifacts((PublishNewVersionResponse)apiResponses.get(0), artifacts);
        for (PublishNewVersionResponse apiResponse : apiResponses) {
            this.activate(apiResponse.getNextRequest());
        }
    }

    private Map<PublishArtifact, File> collectArtifacts() throws IOException {
        LinkedHashMap<PublishArtifact, File> artifacts = new LinkedHashMap<PublishArtifact, File>();
        Configuration archivesConfiguration = this.getProject().getConfigurations().getByName("archives");
        if (this.useAutomatedPublishing) {
            SoftwareComponentInternal component = (SoftwareComponentInternal)this.getProject().getComponents().getByName("java");
            for (UsageContext variant : component.getUsages()) {
                for (org.gradle.api.artifacts.PublishArtifact artifact : variant.getArtifacts()) {
                    this.addAndHashArtifact(artifacts, artifact);
                }
            }
        } else {
            for (org.gradle.api.artifacts.PublishArtifact artifact : archivesConfiguration.getAllArtifacts()) {
                this.addAndHashArtifact(artifacts, artifact);
            }
        }
        this.addAndHashArtifact(artifacts, this.getPomFile(), "pom", null);
        this.addAndHashArtifact(artifacts, this.getGmmFile(), "module", null);
        return artifacts;
    }

    private void publishArtifacts(PublishNewVersionResponse apiResponse, Map<PublishArtifact, File> artifactHashes) throws IOException {
        Map<String, String> publishedHashAndUrls = apiResponse.getPublishTo();
        for (Map.Entry<PublishArtifact, File> art : artifactHashes.entrySet()) {
            String uploadUrl = publishedHashAndUrls.get(art.getKey().getHash());
            File artifactFile = art.getValue();
            this.uploadArtifactIfNecessary(artifactFile, uploadUrl);
        }
    }

    private void handleApiResponse(String pluginId, PublishNewVersionResponse apiResponse) {
        ResponseUtil.assertValidResponse("Request to publish new plugin '" + pluginId + "' failed!", apiResponse);
        if (apiResponse.hasFailed().booleanValue()) {
            throw new RuntimeException("Cannot publish plugin '" + pluginId + "'\nServer responded with: " + apiResponse.getErrorMessage());
        }
        if (apiResponse.hasWarning().booleanValue()) {
            LOGGER.warn(apiResponse.getWarningMessage());
        }
    }

    private PublishMavenCoordinates getMavenCoordinatesFromBundleConfig() {
        MavenCoordinates coordinates = this.bundleConfig.getMavenCoordinates();
        String groupId = GroupId.createGroupId(this.getProject(), this.bundleConfig);
        String specifiedArtifactId = coordinates != null ? coordinates.getArtifactId() : null;
        String artifactId = !Util.isBlank(specifiedArtifactId) ? specifiedArtifactId : this.getProject().getName();
        String version = coordinates != null && !Util.isBlank(coordinates.getVersion()) ? coordinates.getVersion() : this.getProject().getVersion().toString();
        return this.validateMavenCoordinates(groupId, artifactId, version, coordinates);
    }

    private PublishMavenCoordinates validateMavenCoordinates(String groupId, String artifactId, String version, MavenCoordinates coordinates) {
        this.validator.validateMavenCoordinates(groupId, artifactId, version, coordinates);
        return new PublishMavenCoordinates(groupId, artifactId, version);
    }

    private List<PublishNewVersionRequest> buildPublishRequests() {
        ArrayList<PublishNewVersionRequest> reqs = new ArrayList<PublishNewVersionRequest>();
        for (PluginConfig pluginConfig : this.bundleConfig.getPlugins()) {
            reqs.add(this.buildPublishRequest(pluginConfig));
        }
        return reqs;
    }

    private List<String> getTags(PluginConfig plugin) {
        Collection<String> configTags = plugin.getTags();
        if (configTags.isEmpty()) {
            configTags = this.bundleConfig.getTags();
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (String tag : configTags) {
            if (PluginPublishValidator.ILLEGAL_TAGS.contains(tag = tag.toLowerCase()) || tags.contains(tag)) continue;
            tags.add(tag);
        }
        return tags;
    }

    private PublishNewVersionRequest buildPublishRequest(PluginConfig plugin) {
        PublishNewVersionRequest request = new PublishNewVersionRequest();
        BuildMetadata buildMetadata = new BuildMetadata(this.getProject().getGradle().getGradleVersion());
        request.setBuildMetadata(buildMetadata);
        request.setPluginId(plugin.getId());
        String pluginVersion = plugin.getVersion() != null ? plugin.getVersion() : this.getProject().getVersion().toString();
        request.setPluginVersion(pluginVersion);
        request.setDisplayName(plugin.getDisplayName());
        String desc = plugin.getDescription();
        desc = desc != null ? desc : this.bundleConfig.getDescription();
        request.setDescription(desc);
        request.setTags(this.getTags(plugin));
        request.setWebSite(this.bundleConfig.getWebsite());
        request.setVcsUrl(this.bundleConfig.getVcsUrl());
        return request;
    }

    private <T extends ServerResponseBase> T doSignedPost(ClientPostRequest<T> postRequest) throws Exception {
        return this.buildOAuthClient().send(postRequest);
    }

    private void activate(PublishActivateRequest activePlugin) throws Exception {
        LOGGER.lifecycle("Activating plugin {} version {}", new Object[]{activePlugin.getPluginId(), activePlugin.getVersion()});
        this.doSignedPost(activePlugin);
    }

    private File getPomFile() {
        return this.pomFile;
    }

    private File getGmmFile() {
        return this.gmmFile;
    }

    private void uploadArtifactIfNecessary(File artifactFile, String uploadUrl) throws IOException {
        URI filePath = this.getProject().getProjectDir().toURI().relativize(artifactFile.toURI());
        if (uploadUrl != null) {
            LOGGER.lifecycle("Publishing artifact {}", new Object[]{filePath});
            LOGGER.debug("Publishing {} to {}", (Object)filePath, (Object)uploadUrl);
            Uploader.putFile(artifactFile, uploadUrl);
        } else {
            LOGGER.info("Skipping upload of artifact {} as it has been previously uploaded", (Object)filePath);
        }
    }

    public void setPomFile(File pomFile) {
        this.pomFile = pomFile;
    }

    public void setBundleConfig(PluginBundleExtension bundleConfig) {
        this.bundleConfig = bundleConfig;
    }

    private Properties createPropertiesStore() {
        return PropertiesStore.all(this.getProject());
    }

    private OAuthHttpClient buildOAuthClient() {
        Properties props = this.createPropertiesStore();
        String key = this.getEnvThenSystemProperty(GRADLE_PUBLISH_KEY_ENV, props, GRADLE_PUBLISH_KEY);
        String secret = this.getEnvThenSystemProperty(GRADLE_PUBLISH_SECRET_ENV, props, GRADLE_PUBLISH_SECRET);
        if (key == null || key.trim().isEmpty() || secret == null || secret.trim().isEmpty()) {
            throw new IllegalArgumentException("Missing publishing keys. Please set gradle.publish.key/gradle.publish.secret system properties or GRADLE_PUBLISH_KEY/GRADLE_PUBLISH_SECRET env variables or login using the login task.");
        }
        return new OAuthHttpClient(this.ghConfig.getPortalUrl(), key, secret);
    }

    private String getEnvThenSystemProperty(String envName, Properties properties, String propertyName) {
        String envValue = System.getenv(envName);
        if (envValue == null) {
            return properties.getProperty(propertyName);
        }
        return envValue;
    }

    public void useAutomatedPublishing() {
        this.dependsOn(new Object[]{this.getProject().getTasks().matching(task -> MAVEN_PUBLISH_POM_TASK_NAME.equals(task.getName()))});
        this.useAutomatedPublishing = true;
    }

    public void useGradleModuleMetadataIfAvailable() {
        this.getProject().getTasks().stream().filter(t -> t.getName().equals(MAVEN_PUBLISH_GMM_TASK_NAME) && t.getEnabled()).forEach(task -> {
            GenerateModuleMetadata gmmTask = (GenerateModuleMetadata)task;
            this.dependsOn(new Object[]{gmmTask.getOutputFile()});
            this.gmmFile = (File)gmmTask.getOutputFile().getAsFile().getOrNull();
        });
    }
}

