/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.perceptron.accessories;

import com.hankcs.hanlp.dependency.perceptron.accessories.CoNLLReader;
import com.hankcs.hanlp.dependency.perceptron.accessories.Pair;
import com.hankcs.hanlp.dependency.perceptron.transition.configuration.CompactTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class Evaluator {
    public static double[] evaluate(String testPath, String predictedPath, HashSet<String> puncTags) throws IOException {
        CoNLLReader goldReader = new CoNLLReader(testPath);
        CoNLLReader predictedReader = new CoNLLReader(predictedPath);
        ArrayList<CompactTree> goldConfiguration = goldReader.readStringData();
        ArrayList<CompactTree> predConfiguration = predictedReader.readStringData();
        float unlabMatch = 0.0f;
        float labMatch = 0.0f;
        int all = 0;
        float fullULabMatch = 0.0f;
        float fullLabMatch = 0.0f;
        int numTree = 0;
        for (int i = 0; i < predConfiguration.size(); ++i) {
            HashMap<Integer, Pair<Integer, String>> goldDeps = goldConfiguration.get((int)i).goldDependencies;
            HashMap<Integer, Pair<Integer, String>> predDeps = predConfiguration.get((int)i).goldDependencies;
            ArrayList<String> goldTags = goldConfiguration.get((int)i).posTags;
            ++numTree;
            boolean fullMatch = true;
            boolean fullUnlabMatch = true;
            for (int dep : goldDeps.keySet()) {
                if (puncTags.contains(goldTags.get(dep - 1).trim())) continue;
                ++all;
                int gh = (Integer)goldDeps.get((Object)Integer.valueOf((int)dep)).first;
                int ph = (Integer)predDeps.get((Object)Integer.valueOf((int)dep)).first;
                String gl = ((String)goldDeps.get((Object)Integer.valueOf((int)dep)).second).trim();
                String pl = ((String)predDeps.get((Object)Integer.valueOf((int)dep)).second).trim();
                if (ph == gh) {
                    unlabMatch += 1.0f;
                    if (pl.equals(gl)) {
                        labMatch += 1.0f;
                        continue;
                    }
                    fullMatch = false;
                    continue;
                }
                fullMatch = false;
                fullUnlabMatch = false;
            }
            if (fullMatch) {
                fullLabMatch += 1.0f;
            }
            if (!fullUnlabMatch) continue;
            fullULabMatch += 1.0f;
        }
        double labeledAccuracy = 100.0 * (double)labMatch / (double)all;
        double unlabaledAccuracy = 100.0 * (double)unlabMatch / (double)all;
        double labExact = 100.0 * (double)fullLabMatch / (double)numTree;
        double ulabExact = 100.0 * (double)fullULabMatch / (double)numTree;
        return new double[]{unlabaledAccuracy, labeledAccuracy};
    }
}

