/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.cdn.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListDomainsRequest {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="domain_name")
    private String domainName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="business_type")
    private BusinessTypeEnum businessType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="domain_status")
    private DomainStatusEnum domainStatus;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="service_area")
    private ServiceAreaEnum serviceArea;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="page_size")
    private Integer pageSize;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="page_number")
    private Integer pageNumber;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="enterprise_project_id")
    private String enterpriseProjectId;

    public ListDomainsRequest withDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public ListDomainsRequest withBusinessType(BusinessTypeEnum businessType) {
        this.businessType = businessType;
        return this;
    }

    public BusinessTypeEnum getBusinessType() {
        return this.businessType;
    }

    public void setBusinessType(BusinessTypeEnum businessType) {
        this.businessType = businessType;
    }

    public ListDomainsRequest withDomainStatus(DomainStatusEnum domainStatus) {
        this.domainStatus = domainStatus;
        return this;
    }

    public DomainStatusEnum getDomainStatus() {
        return this.domainStatus;
    }

    public void setDomainStatus(DomainStatusEnum domainStatus) {
        this.domainStatus = domainStatus;
    }

    public ListDomainsRequest withServiceArea(ServiceAreaEnum serviceArea) {
        this.serviceArea = serviceArea;
        return this;
    }

    public ServiceAreaEnum getServiceArea() {
        return this.serviceArea;
    }

    public void setServiceArea(ServiceAreaEnum serviceArea) {
        this.serviceArea = serviceArea;
    }

    public ListDomainsRequest withPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public ListDomainsRequest withPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public ListDomainsRequest withEnterpriseProjectId(String enterpriseProjectId) {
        this.enterpriseProjectId = enterpriseProjectId;
        return this;
    }

    public String getEnterpriseProjectId() {
        return this.enterpriseProjectId;
    }

    public void setEnterpriseProjectId(String enterpriseProjectId) {
        this.enterpriseProjectId = enterpriseProjectId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListDomainsRequest listDomainsRequest = (ListDomainsRequest)o;
        return Objects.equals(this.domainName, listDomainsRequest.domainName) && Objects.equals(this.businessType, listDomainsRequest.businessType) && Objects.equals(this.domainStatus, listDomainsRequest.domainStatus) && Objects.equals(this.serviceArea, listDomainsRequest.serviceArea) && Objects.equals(this.pageSize, listDomainsRequest.pageSize) && Objects.equals(this.pageNumber, listDomainsRequest.pageNumber) && Objects.equals(this.enterpriseProjectId, listDomainsRequest.enterpriseProjectId);
    }

    public int hashCode() {
        return Objects.hash(this.domainName, this.businessType, this.domainStatus, this.serviceArea, this.pageSize, this.pageNumber, this.enterpriseProjectId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListDomainsRequest {\n");
        sb.append("    domainName: ").append(this.toIndentedString(this.domainName)).append("\n");
        sb.append("    businessType: ").append(this.toIndentedString(this.businessType)).append("\n");
        sb.append("    domainStatus: ").append(this.toIndentedString(this.domainStatus)).append("\n");
        sb.append("    serviceArea: ").append(this.toIndentedString(this.serviceArea)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    enterpriseProjectId: ").append(this.toIndentedString(this.enterpriseProjectId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ServiceAreaEnum {
        public static final ServiceAreaEnum MAINLAND_CHINA = new ServiceAreaEnum("mainland_china");
        public static final ServiceAreaEnum OUTSIDE_MAINLAND_CHINA = new ServiceAreaEnum("outside_mainland_china");
        public static final ServiceAreaEnum GLOBAL = new ServiceAreaEnum("global");
        private static final Map<String, ServiceAreaEnum> STATIC_FIELDS = ServiceAreaEnum.createStaticFields();
        private String value;

        private static Map<String, ServiceAreaEnum> createStaticFields() {
            HashMap<String, ServiceAreaEnum> map = new HashMap<String, ServiceAreaEnum>();
            map.put("mainland_china", MAINLAND_CHINA);
            map.put("outside_mainland_china", OUTSIDE_MAINLAND_CHINA);
            map.put("global", GLOBAL);
            return Collections.unmodifiableMap(map);
        }

        ServiceAreaEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServiceAreaEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            ServiceAreaEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new ServiceAreaEnum(value);
            }
            return result;
        }

        public static ServiceAreaEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            ServiceAreaEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof ServiceAreaEnum) {
                return this.value.equals(((ServiceAreaEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class DomainStatusEnum {
        public static final DomainStatusEnum ONLINE = new DomainStatusEnum("online");
        public static final DomainStatusEnum OFFLINE = new DomainStatusEnum("offline");
        public static final DomainStatusEnum CONFIGURING = new DomainStatusEnum("configuring");
        public static final DomainStatusEnum CONFIGURE_FAILED = new DomainStatusEnum("configure_failed");
        public static final DomainStatusEnum CHECKING = new DomainStatusEnum("checking");
        public static final DomainStatusEnum CHECK_FAILED = new DomainStatusEnum("check_failed");
        public static final DomainStatusEnum DELETING = new DomainStatusEnum("deleting");
        private static final Map<String, DomainStatusEnum> STATIC_FIELDS = DomainStatusEnum.createStaticFields();
        private String value;

        private static Map<String, DomainStatusEnum> createStaticFields() {
            HashMap<String, DomainStatusEnum> map = new HashMap<String, DomainStatusEnum>();
            map.put("online", ONLINE);
            map.put("offline", OFFLINE);
            map.put("configuring", CONFIGURING);
            map.put("configure_failed", CONFIGURE_FAILED);
            map.put("checking", CHECKING);
            map.put("check_failed", CHECK_FAILED);
            map.put("deleting", DELETING);
            return Collections.unmodifiableMap(map);
        }

        DomainStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DomainStatusEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            DomainStatusEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new DomainStatusEnum(value);
            }
            return result;
        }

        public static DomainStatusEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            DomainStatusEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof DomainStatusEnum) {
                return this.value.equals(((DomainStatusEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class BusinessTypeEnum {
        public static final BusinessTypeEnum WEB = new BusinessTypeEnum("web");
        public static final BusinessTypeEnum DOWNLOAD = new BusinessTypeEnum("download");
        public static final BusinessTypeEnum VIDEO = new BusinessTypeEnum("video");
        public static final BusinessTypeEnum WHOLESITE = new BusinessTypeEnum("wholeSite");
        private static final Map<String, BusinessTypeEnum> STATIC_FIELDS = BusinessTypeEnum.createStaticFields();
        private String value;

        private static Map<String, BusinessTypeEnum> createStaticFields() {
            HashMap<String, BusinessTypeEnum> map = new HashMap<String, BusinessTypeEnum>();
            map.put("web", WEB);
            map.put("download", DOWNLOAD);
            map.put("video", VIDEO);
            map.put("wholeSite", WHOLESITE);
            return Collections.unmodifiableMap(map);
        }

        BusinessTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BusinessTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            BusinessTypeEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new BusinessTypeEnum(value);
            }
            return result;
        }

        public static BusinessTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            BusinessTypeEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof BusinessTypeEnum) {
                return this.value.equals(((BusinessTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

