/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.cdn.v1.region;

import com.huaweicloud.sdk.core.region.Region;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CdnRegion {
    public static final Region CN_NORTH_1 = new Region("cn-north-1", "https://cdn.myhuaweicloud.com");
    public static final Region AP_SOUTHEAST_1 = new Region("ap-southeast-1", "https://cdn.myhuaweicloud.com");
    private static final Map<String, Region> STATIC_FIELDS = CdnRegion.createStaticFields();

    private static Map<String, Region> createStaticFields() {
        HashMap<String, Region> map = new HashMap<String, Region>();
        map.put("cn-north-1", CN_NORTH_1);
        map.put("ap-southeast-1", AP_SOUTHEAST_1);
        return Collections.unmodifiableMap(map);
    }

    public static Region valueOf(String regionId) {
        if (StringUtils.isEmpty((CharSequence)regionId)) {
            throw new IllegalArgumentException("Unexpected empty parameter: regionId.");
        }
        Region result = STATIC_FIELDS.get(regionId);
        if (Objects.nonNull(result)) {
            return result;
        }
        throw new IllegalArgumentException("Unexpected regionId: " + regionId);
    }
}

