/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.util;

import java.util.HashMap;
import java.util.Map;

public class TagProcessorMapping {
    private static String DEFAULT_DISPLAY_KEY = "defaultKey";
    private Map<String, Map<String, Class<?>>> mapping = new HashMap();

    public void putMapping(String tag, Class<?> mappingClass) {
        this.ensureMappingExists(tag).put(DEFAULT_DISPLAY_KEY, mappingClass);
    }

    public void putMapping(String tag, String display, Class<?> mappingClass) {
        this.ensureMappingExists(tag).put(display, mappingClass);
    }

    public Class<?> getMapping(String tag) {
        return this.getMapping(tag, DEFAULT_DISPLAY_KEY);
    }

    public Class<?> getMapping(String tag, String display) {
        Map<String, Class<?>> tagMapping = this.mapping.get(tag);
        if (tagMapping == null) {
            return null;
        }
        return tagMapping.get(display);
    }

    private Map<String, Class<?>> ensureMappingExists(String tag) {
        if (this.mapping.containsKey(tag)) {
            return this.mapping.get(tag);
        }
        HashMap tagMapping = new HashMap();
        this.mapping.put(tag, tagMapping);
        return tagMapping;
    }
}

