/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.borders;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.borders.Border;

public class RoundDotsBorder
extends Border {
    private static final float GAP_MODIFIER = 2.5f;

    public RoundDotsBorder(float width) {
        super(width);
    }

    public RoundDotsBorder(Color color, float width) {
        super(color, width);
    }

    public RoundDotsBorder(Color color, float width, float opacity) {
        super(color, width, opacity);
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, Border.Side defaultSide, float borderWidthBefore, float borderWidthAfter) {
        float initialGap = this.width * 2.5f;
        float dx = x2 - x1;
        float dy = y2 - y1;
        double borderLength = Math.sqrt(dx * dx + dy * dy);
        float adjustedGap = this.getDotsGap(borderLength, initialGap);
        float widthHalf = this.width / 2.0f;
        Border.Side borderSide = this.getBorderSide(x1, y1, x2, y2, defaultSide);
        switch (borderSide) {
            case TOP: {
                y1 += widthHalf;
                y2 += widthHalf;
                break;
            }
            case RIGHT: {
                x1 += widthHalf;
                x2 += widthHalf;
                break;
            }
            case BOTTOM: {
                y1 -= widthHalf;
                y2 -= widthHalf;
                break;
            }
            case LEFT: {
                x1 -= widthHalf;
                x2 -= widthHalf;
            }
        }
        canvas.saveState().setStrokeColor(this.transparentColor.getColor()).setLineWidth(this.width).setLineCapStyle(1);
        this.transparentColor.applyStrokeTransparency(canvas);
        canvas.setLineDash(0.0f, adjustedGap, adjustedGap / 2.0f).moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2).stroke().restoreState();
    }

    @Override
    public void drawCellBorder(PdfCanvas canvas, float x1, float y1, float x2, float y2, Border.Side defaultSide) {
        float initialGap = this.width * 2.5f;
        float dx = x2 - x1;
        float dy = y2 - y1;
        double borderLength = Math.sqrt(dx * dx + dy * dy);
        float adjustedGap = this.getDotsGap(borderLength, initialGap);
        boolean isHorizontal = false;
        if (Math.abs(y2 - y1) < 5.0E-4f) {
            isHorizontal = true;
        }
        if (isHorizontal) {
            x2 -= this.width;
        }
        canvas.saveState();
        canvas.setStrokeColor(this.transparentColor.getColor());
        this.transparentColor.applyStrokeTransparency(canvas);
        canvas.setLineWidth(this.width);
        canvas.setLineCapStyle(1);
        canvas.setLineDash(0.0f, adjustedGap, adjustedGap / 2.0f).moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2).stroke();
        canvas.restoreState();
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float horizontalRadius1, float verticalRadius1, float horizontalRadius2, float verticalRadius2, Border.Side defaultSide, float borderWidthBefore, float borderWidthAfter) {
        float curv = 0.447f;
        float initialGap = this.width * 2.5f;
        float dx = x2 - x1;
        float dy = y2 - y1;
        double borderLength = Math.sqrt(dx * dx + dy * dy);
        float adjustedGap = this.getDotsGap(borderLength, initialGap);
        float x0 = x1;
        float y0 = y1;
        float x3 = x2;
        float y3 = y2;
        float widthHalf = this.width / 2.0f;
        canvas.saveState().setStrokeColor(this.transparentColor.getColor());
        this.transparentColor.applyStrokeTransparency(canvas);
        canvas.setLineWidth(this.width).setLineCapStyle(1).setLineDash(0.0f, adjustedGap, adjustedGap / 2.0f);
        Border.Side borderSide = this.getBorderSide(x1, y1, x2, y2, defaultSide);
        switch (borderSide) {
            case TOP: {
                float innerRadiusBefore = Math.max(0.0f, horizontalRadius1 - borderWidthBefore);
                float innerRadiusFirst = Math.max(0.0f, verticalRadius1 - this.width);
                float innerRadiusSecond = Math.max(0.0f, verticalRadius2 - this.width);
                float innerRadiusAfter = Math.max(0.0f, horizontalRadius2 - borderWidthAfter);
                Point clipPoint1 = this.getIntersectionPoint(new Point((double)(x1 - borderWidthBefore), (double)(y1 + this.width)), new Point((double)x1, (double)y1), new Point((double)(x0 -= borderWidthBefore / 2.0f), (double)(y0 -= innerRadiusFirst)), new Point((double)(x0 + 10.0f), (double)y0));
                Point clipPoint2 = this.getIntersectionPoint(new Point((double)(x2 + borderWidthAfter), (double)(y2 + this.width)), new Point((double)x2, (double)y2), new Point((double)(x3 += borderWidthAfter / 2.0f), (double)(y3 -= innerRadiusSecond)), new Point((double)(x3 - 10.0f), (double)y3));
                if (clipPoint1.x > clipPoint2.x) {
                    Point clipPoint = this.getIntersectionPoint(new Point((double)(x1 - borderWidthBefore), (double)(y1 + this.width)), clipPoint1, clipPoint2, new Point((double)(x2 + borderWidthAfter), (double)(y2 + this.width)));
                    canvas.moveTo((double)(x1 - borderWidthBefore), (double)(y1 + this.width)).lineTo(clipPoint.x, clipPoint.y).lineTo((double)(x2 + borderWidthAfter), (double)(y2 + this.width)).lineTo((double)(x1 - borderWidthBefore), (double)(y1 + this.width));
                } else {
                    canvas.moveTo((double)(x1 - borderWidthBefore), (double)(y1 + this.width)).lineTo(clipPoint1.x, clipPoint1.y).lineTo(clipPoint2.x, clipPoint2.y).lineTo((double)(x2 + borderWidthAfter), (double)(y2 + this.width)).lineTo((double)(x1 - borderWidthBefore), (double)(y1 + this.width));
                }
                canvas.clip().newPath();
                canvas.moveTo((double)x0, (double)y0).curveTo((double)x0, (double)(y0 + innerRadiusFirst * curv), (double)((x1 += innerRadiusBefore) - innerRadiusBefore * curv), (double)(y1 += widthHalf), (double)x1, (double)y1).lineTo((double)(x2 -= innerRadiusAfter), (double)(y2 += widthHalf)).curveTo((double)(x2 + innerRadiusAfter * curv), (double)y2, (double)x3, (double)(y3 + innerRadiusSecond * curv), (double)x3, (double)y3);
                break;
            }
            case RIGHT: {
                float innerRadiusBefore = Math.max(0.0f, verticalRadius1 - borderWidthBefore);
                float innerRadiusFirst = Math.max(0.0f, horizontalRadius1 - this.width);
                float innerRadiusSecond = Math.max(0.0f, horizontalRadius2 - this.width);
                float innerRadiusAfter = Math.max(0.0f, verticalRadius2 - borderWidthAfter);
                Point clipPoint1 = this.getIntersectionPoint(new Point((double)(x1 + this.width), (double)(y1 + borderWidthBefore)), new Point((double)x1, (double)y1), new Point((double)(x0 -= innerRadiusFirst), (double)(y0 += borderWidthBefore / 2.0f)), new Point((double)x0, (double)(y0 - 10.0f)));
                Point clipPoint2 = this.getIntersectionPoint(new Point((double)(x2 + this.width), (double)(y2 - borderWidthAfter)), new Point((double)x2, (double)y2), new Point((double)(x3 -= innerRadiusSecond), (double)(y3 -= borderWidthAfter)), new Point((double)x3, (double)(y3 - 10.0f)));
                if (clipPoint1.y < clipPoint2.y) {
                    Point clipPoint = this.getIntersectionPoint(new Point((double)(x1 + this.width), (double)(y1 + borderWidthBefore)), clipPoint1, clipPoint2, new Point((double)(x2 + this.width), (double)(y2 - borderWidthAfter)));
                    canvas.moveTo((double)(x1 + this.width), (double)(y1 + borderWidthBefore)).lineTo(clipPoint.x, clipPoint.y).lineTo((double)(x2 + this.width), (double)(y2 - borderWidthAfter)).lineTo((double)(x1 + this.width), (double)(y1 + borderWidthBefore)).clip().newPath();
                } else {
                    canvas.moveTo((double)(x1 + this.width), (double)(y1 + borderWidthBefore)).lineTo(clipPoint1.x, clipPoint1.y).lineTo(clipPoint2.x, clipPoint2.y).lineTo((double)(x2 + this.width), (double)(y2 - borderWidthAfter)).lineTo((double)(x1 + this.width), (double)(y1 + borderWidthBefore)).clip().newPath();
                }
                canvas.clip().newPath();
                canvas.moveTo((double)x0, (double)y0).curveTo((double)(x0 + innerRadiusFirst * curv), (double)y0, (double)(x1 += widthHalf), (double)((y1 -= innerRadiusBefore) + innerRadiusBefore * curv), (double)x1, (double)y1).lineTo((double)(x2 += widthHalf), (double)(y2 += innerRadiusAfter)).curveTo((double)x2, (double)(y2 - innerRadiusAfter * curv), (double)(x3 + innerRadiusSecond * curv), (double)y3, (double)x3, (double)y3);
                break;
            }
            case BOTTOM: {
                float innerRadiusBefore = Math.max(0.0f, horizontalRadius1 - borderWidthBefore);
                float innerRadiusFirst = Math.max(0.0f, verticalRadius1 - this.width);
                float innerRadiusSecond = Math.max(0.0f, verticalRadius2 - this.width);
                float innerRadiusAfter = Math.max(0.0f, horizontalRadius2 - borderWidthAfter);
                Point clipPoint1 = this.getIntersectionPoint(new Point((double)(x1 + borderWidthBefore), (double)(y1 - this.width)), new Point((double)x1, (double)y1), new Point((double)(x0 += borderWidthBefore / 2.0f), (double)(y0 += innerRadiusFirst)), new Point((double)(x0 - 10.0f), (double)y0));
                Point clipPoint2 = this.getIntersectionPoint(new Point((double)(x2 - borderWidthAfter), (double)(y2 - this.width)), new Point((double)x2, (double)y2), new Point((double)(x3 -= borderWidthAfter / 2.0f), (double)(y3 += innerRadiusSecond)), new Point((double)(x3 + 10.0f), (double)y3));
                if (clipPoint1.x < clipPoint2.x) {
                    Point clipPoint = this.getIntersectionPoint(new Point((double)(x1 + borderWidthBefore), (double)(y1 - this.width)), clipPoint1, clipPoint2, new Point((double)(x2 - borderWidthAfter), (double)(y2 - this.width)));
                    canvas.moveTo((double)(x1 + borderWidthBefore), (double)(y1 - this.width)).lineTo(clipPoint.x, clipPoint.y).lineTo((double)(x2 - borderWidthAfter), (double)(y2 - this.width)).lineTo((double)(x1 + borderWidthBefore), (double)(y1 - this.width));
                } else {
                    canvas.moveTo((double)(x1 + borderWidthBefore), (double)(y1 - this.width)).lineTo(clipPoint1.x, clipPoint1.y).lineTo(clipPoint2.x, clipPoint2.y).lineTo((double)(x2 - borderWidthAfter), (double)(y2 - this.width)).lineTo((double)(x1 + borderWidthBefore), (double)(y1 - this.width));
                }
                canvas.clip().newPath();
                canvas.moveTo((double)x0, (double)y0).curveTo((double)x0, (double)(y0 - innerRadiusFirst * curv), (double)((x1 -= innerRadiusBefore) + innerRadiusBefore * curv), (double)(y1 -= widthHalf), (double)x1, (double)y1).lineTo((double)(x2 += innerRadiusAfter), (double)(y2 -= widthHalf)).curveTo((double)(x2 - innerRadiusAfter * curv), (double)y2, (double)x3, (double)(y3 - innerRadiusSecond * curv), (double)x3, (double)y3);
                break;
            }
            case LEFT: {
                float innerRadiusBefore = Math.max(0.0f, verticalRadius1 - borderWidthBefore);
                float innerRadiusFirst = Math.max(0.0f, horizontalRadius1 - this.width);
                float innerRadiusSecond = Math.max(0.0f, horizontalRadius2 - this.width);
                float innerRadiusAfter = Math.max(0.0f, verticalRadius2 - borderWidthAfter);
                Point clipPoint1 = this.getIntersectionPoint(new Point((double)(x1 - this.width), (double)(y1 - borderWidthBefore)), new Point((double)x1, (double)y1), new Point((double)(x0 += innerRadiusFirst), (double)(y0 -= borderWidthBefore / 2.0f)), new Point((double)x0, (double)(y0 + 10.0f)));
                Point clipPoint2 = this.getIntersectionPoint(new Point((double)(x2 - this.width), (double)(y2 + borderWidthAfter)), new Point((double)x2, (double)y2), new Point((double)(x3 += innerRadiusSecond), (double)(y3 += borderWidthAfter)), new Point((double)x3, (double)(y3 + 10.0f)));
                if (clipPoint1.y > clipPoint2.y) {
                    Point clipPoint = this.getIntersectionPoint(new Point((double)(x1 - this.width), (double)(y1 - borderWidthBefore)), clipPoint1, clipPoint2, new Point((double)(x2 - this.width), (double)(y2 + borderWidthAfter)));
                    canvas.moveTo((double)(x1 - this.width), (double)(y1 - borderWidthBefore)).lineTo(clipPoint.x, clipPoint.y).lineTo((double)(x2 - this.width), (double)(y2 + borderWidthAfter)).lineTo((double)(x1 - this.width), (double)(y1 - borderWidthBefore));
                } else {
                    canvas.moveTo((double)(x1 - this.width), (double)(y1 - borderWidthBefore)).lineTo(clipPoint1.x, clipPoint1.y).lineTo(clipPoint2.x, clipPoint2.y).lineTo((double)(x2 - this.width), (double)(y2 + borderWidthAfter)).lineTo((double)(x1 - this.width), (double)(y1 - borderWidthBefore));
                }
                canvas.clip().newPath();
                canvas.moveTo((double)x0, (double)y0).curveTo((double)(x0 - innerRadiusFirst * curv), (double)y0, (double)(x1 -= widthHalf), (double)((y1 += innerRadiusBefore) - innerRadiusBefore * curv), (double)x1, (double)y1).lineTo((double)(x2 -= widthHalf), (double)(y2 -= innerRadiusAfter)).curveTo((double)x2, (double)(y2 + innerRadiusAfter * curv), (double)(x3 - innerRadiusSecond * curv), (double)y3, (double)x3, (double)y3);
            }
        }
        canvas.stroke().restoreState();
    }

    protected float getDotsGap(double distance, float initialGap) {
        double gapsNum = Math.ceil(distance / (double)initialGap);
        if (gapsNum == 0.0) {
            return initialGap;
        }
        return (float)(distance / gapsNum);
    }
}

