/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.ISvgTextNodeRenderer;
import com.itextpdf.svg.utils.SvgTextUtil;

public class TextLeafSvgNodeRenderer
extends AbstractSvgNodeRenderer
implements ISvgTextNodeRenderer {
    @Override
    public ISvgNodeRenderer createDeepCopy() {
        TextLeafSvgNodeRenderer copy = new TextLeafSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }

    @Override
    public float getTextContentLength(float parentFontSize, PdfFont font) {
        float contentLength = 0.0f;
        if (font != null && this.attributesAndStyles != null && this.attributesAndStyles.containsKey("text_content")) {
            float fontSize = SvgTextUtil.resolveFontSize(this, parentFontSize);
            String content = (String)this.attributesAndStyles.get("text_content");
            contentLength = font.getWidth(content, fontSize);
        }
        return contentLength;
    }

    @Override
    public float[] getRelativeTranslation() {
        return new float[]{0.0f, 0.0f};
    }

    @Override
    public boolean containsRelativeMove() {
        return false;
    }

    @Override
    public boolean containsAbsolutePositionChange() {
        return false;
    }

    @Override
    public float[][] getAbsolutePositionChanges() {
        float[] part = new float[]{0.0f};
        return new float[][]{part, part};
    }

    @Override
    protected void doDraw(SvgDrawContext context) {
        if (this.attributesAndStyles != null && this.attributesAndStyles.containsKey("text_content")) {
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            currentCanvas.moveText((double)context.getTextMove()[0], (double)context.getTextMove()[1]);
            currentCanvas.showText((String)this.attributesAndStyles.get("text_content"));
        }
    }

    @Override
    protected boolean canElementFill() {
        return false;
    }
}

