/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fasttext;

import com.mayabot.nlp.fasttext.FastText;
import com.mayabot.nlp.fasttext.Model;
import com.mayabot.nlp.fasttext.args.Args;
import com.mayabot.nlp.fasttext.args.ModelName;
import com.mayabot.nlp.fasttext.blas.DenseArrayMatrixKt;
import com.mayabot.nlp.fasttext.blas.Matrix;
import com.mayabot.nlp.fasttext.blas.QuantMatrixKt;
import com.mayabot.nlp.fasttext.dictionary.Dictionary;
import com.mayabot.nlp.fasttext.loss.Loss;
import com.mayabot.nlp.fasttext.loss.LossKt;
import com.mayabot.nlp.fasttext.utils.AutoDataInput;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/mayabot/nlp/fasttext/CppFastTextSupport;", "", "()V", "load", "Lcom/mayabot/nlp/fasttext/FastText;", "modelFile", "Ljava/io/File;", "loadCModel", "inputStream", "Ljava/io/InputStream;", "fastText4j"})
public final class CppFastTextSupport {
    public static final CppFastTextSupport INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final FastText loadCModel(@NotNull InputStream inputStream) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        Closeable closeable = inputStream;
        int n = 0x100000;
        boolean bl = false;
        BufferedInputStream bufferedInputStream = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        InputStream inputStream2 = bufferedInputStream;
        DataInputStream ins = new DataInputStream(inputStream2);
        closeable = ins;
        n = 0;
        Throwable throwable = null;
        try {
            Matrix input;
            boolean quantInput;
            DataInputStream it = (DataInputStream)closeable;
            boolean bl2 = false;
            DataInput dataInput = it;
            ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteOrder, (String)"ByteOrder.LITTLE_ENDIAN");
            AutoDataInput buffer = new AutoDataInput(dataInput, byteOrder);
            int magic = buffer.readInt();
            int version = buffer.readInt();
            if (magic != 793712314) {
                throw (Throwable)new RuntimeException("Model file has wrong file format!");
            }
            if (version > 12) {
                throw (Throwable)new RuntimeException("Model file has wrong file format! version is " + version);
            }
            CppFastTextSupport cppFastTextSupport = INSTANCE;
            boolean bl3 = false;
            boolean bl4 = false;
            CppFastTextSupport $this$run = cppFastTextSupport;
            boolean bl5 = false;
            Args args_ = Args.Companion.load(buffer);
            if (version == 11 && args_.getModel() == ModelName.sup) {
                args_ = Args.copy$default(args_, 0, 0, 0, 0, 0, 0, 0.0, 0, 0, 0, 0, 0, null, null, 0, 0, 0, null, 0.0, null, null, null, 0, 0, null, 0x1FFFFDF, null);
            }
            Args args = args_;
            Dictionary dictionary = Dictionary.Companion.loadModel(args, buffer);
            boolean quant_ = quantInput = buffer.readUnsignedByte() != 0;
            Matrix matrix = input = quantInput ? (Matrix)QuantMatrixKt.loadQuantMatrix(buffer) : (Matrix)DenseArrayMatrixKt.loadFloatArrayMatrixCPP(buffer);
            if (!quantInput && dictionary.isPruned()) {
                throw (Throwable)new RuntimeException("Invalid model file.\nPlease download the updated model from www.fasttext.cc.\nSee issue #332 on Github for more information.\n");
            }
            boolean qout = buffer.readUnsignedByte() != 0;
            Matrix output = quantInput && qout ? (Matrix)QuantMatrixKt.loadQuantMatrix(buffer) : (Matrix)DenseArrayMatrixKt.loadFloatArrayMatrixCPP(buffer);
            Loss loss = LossKt.createLoss(args, output, args.getModel(), dictionary);
            boolean normalizeGradient = args.getModel() == ModelName.sup;
            FastText fastText = new FastText(args, dictionary, new Model(input, output, loss, normalizeGradient), quant_);
            return fastText;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final FastText load(@NotNull File modelFile) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)modelFile, (String)"modelFile");
        if (!(modelFile.exists() && modelFile.isFile() && modelFile.canRead())) {
            throw (Throwable)new IOException("Model file cannot be opened for loading!");
        }
        File file = modelFile;
        CppFastTextSupport cppFastTextSupport = this;
        boolean bl = false;
        FileInputStream fileInputStream = new FileInputStream(file);
        return cppFastTextSupport.loadCModel(fileInputStream);
    }

    private CppFastTextSupport() {
    }

    static {
        CppFastTextSupport cppFastTextSupport;
        INSTANCE = cppFastTextSupport = new CppFastTextSupport();
    }
}

