/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fasttext;

import com.mayabot.nlp.fasttext.CppFastTextSupport;
import com.mayabot.nlp.fasttext.FastText;
import com.mayabot.nlp.fasttext.Meter;
import com.mayabot.nlp.fasttext.Model;
import com.mayabot.nlp.fasttext.ScoreIdPair;
import com.mayabot.nlp.fasttext.ScoreLabelPair;
import com.mayabot.nlp.fasttext.args.Args;
import com.mayabot.nlp.fasttext.args.InputArgs;
import com.mayabot.nlp.fasttext.args.ModelName;
import com.mayabot.nlp.fasttext.blas.BlasUtilsKt;
import com.mayabot.nlp.fasttext.blas.DenseArrayMatrix;
import com.mayabot.nlp.fasttext.blas.DenseArrayMatrixKt;
import com.mayabot.nlp.fasttext.blas.DenseMatrix;
import com.mayabot.nlp.fasttext.blas.DenseVector;
import com.mayabot.nlp.fasttext.blas.Matrix;
import com.mayabot.nlp.fasttext.blas.QuantMatrix;
import com.mayabot.nlp.fasttext.blas.QuantMatrixKt;
import com.mayabot.nlp.fasttext.blas.Vector;
import com.mayabot.nlp.fasttext.dictionary.BuildDictFromSourceKt;
import com.mayabot.nlp.fasttext.dictionary.Dictionary;
import com.mayabot.nlp.fasttext.loss.Loss;
import com.mayabot.nlp.fasttext.loss.LossKt;
import com.mayabot.nlp.fasttext.train.FastTextTrain;
import com.mayabot.nlp.fasttext.train.FileSampleLineIterable;
import com.mayabot.nlp.fasttext.train.LoadPretraindVectorKt;
import com.mayabot.nlp.fasttext.train.MemSampleLineList;
import com.mayabot.nlp.fasttext.train.SampleLine;
import com.mayabot.nlp.fasttext.utils.AutoDataInput;
import com.mayabot.nlp.fasttext.utils.IOUtilsKt;
import com.mayabot.nlp.fasttext.utils.IntArrayList;
import com.mayabot.nlp.fasttext.utils.LogUtilsKt;
import com.mayabot.nlp.fasttext.utils.TopMaxK;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 L2\u00020\u0001:\u0001LB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J,\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020#J4\u0010,\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010-\u001a\u00020!2\u0006\u0010+\u001a\u00020#2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020(0/H\u0002J\u001e\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020!2\f\u00102\u001a\b\u0012\u0004\u0012\u00020(03H\u0002J\u0014\u00100\u001a\u00020!2\f\u00102\u001a\b\u0012\u0004\u0012\u00020(03J\u0016\u00104\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u00105\u001a\u00020(J\u000e\u00104\u001a\u00020!2\u0006\u00105\u001a\u00020(J\u001c\u00106\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u00107\u001a\u00020(2\u0006\u0010+\u001a\u00020#J$\u00108\u001a\b\u0012\u0004\u0012\u0002090%2\u0006\u0010+\u001a\u00020#2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=J*\u00108\u001a\b\u0012\u0004\u0012\u00020&0%2\f\u00102\u001a\b\u0012\u0004\u0012\u00020(032\u0006\u0010+\u001a\u00020#2\u0006\u0010<\u001a\u00020=J&\u0010>\u001a\u00020\u00002\b\b\u0002\u0010?\u001a\u00020#2\b\b\u0002\u0010@\u001a\u00020\t2\b\b\u0002\u0010A\u001a\u00020\tH\u0007J\u000e\u0010B\u001a\u00020\u001f2\u0006\u0010C\u001a\u00020(J\u000e\u0010D\u001a\u00020\u001f2\u0006\u0010C\u001a\u00020EJ\u000e\u0010F\u001a\u00020\u001f2\u0006\u0010G\u001a\u00020(J,\u0010H\u001a\u00020I2\u0006\u0010C\u001a\u00020E2\b\b\u0002\u0010+\u001a\u00020#2\b\b\u0002\u0010<\u001a\u00020=2\b\b\u0002\u0010J\u001a\u00020\tJ2\u0010H\u001a\u00020I2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020K032\b\b\u0002\u0010+\u001a\u00020#2\b\b\u0002\u0010<\u001a\u00020=2\b\b\u0002\u0010J\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006M"}, d2={"Lcom/mayabot/nlp/fasttext/FastText;", "", "args", "Lcom/mayabot/nlp/fasttext/args/Args;", "dict", "Lcom/mayabot/nlp/fasttext/dictionary/Dictionary;", "model", "Lcom/mayabot/nlp/fasttext/Model;", "quant", "", "(Lcom/mayabot/nlp/fasttext/args/Args;Lcom/mayabot/nlp/fasttext/dictionary/Dictionary;Lcom/mayabot/nlp/fasttext/Model;Z)V", "getArgs", "()Lcom/mayabot/nlp/fasttext/args/Args;", "getDict", "()Lcom/mayabot/nlp/fasttext/dictionary/Dictionary;", "input", "Lcom/mayabot/nlp/fasttext/blas/Matrix;", "getModel", "()Lcom/mayabot/nlp/fasttext/Model;", "output", "getOutput", "()Lcom/mayabot/nlp/fasttext/blas/Matrix;", "getQuant", "()Z", "wordVectors", "Lcom/mayabot/nlp/fasttext/blas/DenseMatrix;", "getWordVectors", "()Lcom/mayabot/nlp/fasttext/blas/DenseMatrix;", "wordVectors$delegate", "Lkotlin/Lazy;", "addInputVector", "", "vec", "Lcom/mayabot/nlp/fasttext/blas/Vector;", "ind", "", "analogies", "", "Lcom/mayabot/nlp/fasttext/ScoreLabelPair;", "A", "", "B", "C", "k", "findNN", "queryVec", "sets", "", "getSentenceVector", "svec", "tokens", "", "getWordVector", "word", "nearestNeighbor", "wordQuery", "predict", "Lcom/mayabot/nlp/fasttext/ScoreIdPair;", "words", "Lcom/mayabot/nlp/fasttext/utils/IntArrayList;", "threshold", "", "quantize", "dsub", "qnorm", "qout", "saveModel", "file", "saveModelToSingleFile", "Ljava/io/File;", "saveVectors", "path", "test", "Lcom/mayabot/nlp/fasttext/Meter;", "print", "Lcom/mayabot/nlp/fasttext/train/SampleLine;", "Companion", "fastText4j"})
public final class FastText {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Matrix input;
    @NotNull
    private final Matrix output;
    private final Lazy wordVectors$delegate;
    @NotNull
    private final Args args;
    @NotNull
    private final Dictionary dict;
    @NotNull
    private final Model model;
    private final boolean quant;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(FastText.class), "wordVectors", "getWordVectors()Lcom/mayabot/nlp/fasttext/blas/DenseMatrix;"))};
        Companion = new Companion(null);
    }

    @NotNull
    public final Matrix getOutput() {
        return this.output;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ScoreLabelPair> predict(@NotNull Iterable<String> tokens, int k, float threshold2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(tokens, (String)"tokens");
        List tokens2 = CollectionsKt.toMutableList(tokens);
        tokens2.add("</s>");
        IntArrayList words = new IntArrayList(0, null, 3, null);
        IntArrayList labels = new IntArrayList(0, null, 3, null);
        this.dict.getLine(tokens2, words, labels);
        if (words.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List<ScoreIdPair> result = this.predict(k, words, threshold2);
        Iterable $this$map$iv = result;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void x;
            ScoreIdPair scoreIdPair = (ScoreIdPair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            float f = x.getScore();
            boolean bl2 = false;
            float f2 = (float)Math.exp(f);
            String string = this.dict.getLabel(x.getId());
            float f3 = f2;
            ScoreLabelPair scoreLabelPair = new ScoreLabelPair(f3, string);
            collection.add(scoreLabelPair);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<ScoreIdPair> predict(int k, @NotNull IntArrayList words, float threshold2) {
        Intrinsics.checkParameterIsNotNull((Object)words, (String)"words");
        if (words.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (this.args.getModel() != ModelName.sup) {
            String string = "Model needs to be supervised for prediction!";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Model.State state = new Model.State(this.args.getDim(), this.dict.getNlabels(), 0);
        ArrayList predictions = new ArrayList();
        this.model.predict(words, k, threshold2, predictions, state);
        return predictions;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ScoreLabelPair> findNN(DenseMatrix wordVectors2, Vector queryVec, int k, Set<String> sets) {
        void $this$mapTo$iv$iv;
        Pair it;
        Iterable $this$filterTo$iv$iv;
        float queryNorm = queryVec.norm2();
        boolean bl = false;
        if ((double)Math.abs(queryNorm) < 1.0E-8) {
            queryNorm = 1.0f;
        }
        TopMaxK<String> top = new TopMaxK<String>(k + sets.size());
        int n = 0;
        int n2 = this.dict.getNwords();
        while (n < n2) {
            void i;
            float dp = wordVectors2.get((int)i).times(queryVec) / queryNorm;
            if (top.canPush(dp)) {
                top.push(this.dict.getWord((int)i), dp);
            }
            ++i;
        }
        Iterable $this$filter$iv = top.result();
        boolean $i$f$filter = false;
        Iterable dp = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl2 = false;
            if (!(((Number)it.getSecond()).floatValue() != -1.0f && !sets.contains(it.getFirst()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            ScoreLabelPair scoreLabelPair = new ScoreLabelPair(((Number)it.getSecond()).floatValue(), (String)it.getFirst());
            collection.add(scoreLabelPair);
        }
        return CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)k);
    }

    private final DenseMatrix getWordVectors() {
        Lazy lazy = this.wordVectors$delegate;
        FastText fastText = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (DenseMatrix)lazy.getValue();
    }

    @NotNull
    public final List<ScoreLabelPair> nearestNeighbor(@NotNull String wordQuery, int k) {
        Intrinsics.checkParameterIsNotNull((Object)wordQuery, (String)"wordQuery");
        Vector queryVec = this.getWordVector(wordQuery);
        HashSet<String> sets = new HashSet<String>();
        sets.add(wordQuery);
        return this.findNN(this.getWordVectors(), queryVec, k, (Set<String>)sets);
    }

    @NotNull
    public final List<ScoreLabelPair> analogies(@NotNull String A, @NotNull String B, @NotNull String C, int k) {
        Intrinsics.checkParameterIsNotNull((Object)A, (String)"A");
        Intrinsics.checkParameterIsNotNull((Object)B, (String)"B");
        Intrinsics.checkParameterIsNotNull((Object)C, (String)"C");
        DenseVector buffer = BlasUtilsKt.floatArrayVector(this.args.getDim());
        DenseVector query = BlasUtilsKt.floatArrayVector(this.args.getDim());
        this.getWordVector(buffer, A);
        query.plusAssign(buffer);
        this.getWordVector(buffer, B);
        query.plusAssign((Pair<? extends Number, ? extends Vector>)TuplesKt.to((Object)Float.valueOf(-1.0f), (Object)buffer));
        this.getWordVector(buffer, C);
        query.plusAssign(buffer);
        HashSet sets = SetsKt.hashSetOf((Object[])new String[]{A, B, C});
        return this.findNN(this.getWordVectors(), query, k, sets);
    }

    public final void getWordVector(@NotNull Vector vec, @NotNull String word) {
        Intrinsics.checkParameterIsNotNull((Object)vec, (String)"vec");
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        vec.zero();
        IntArrayList ngrams = this.dict.getSubwords(word);
        int[] buffer = ngrams.getBuffer();
        int len = ngrams.size();
        for (int i = 0; i < len; ++i) {
            this.addInputVector(vec, buffer[i]);
        }
        if (ngrams.size() > 0) {
            vec.timesAssign(Float.valueOf(1.0f / (float)ngrams.size()));
        }
    }

    @NotNull
    public final Vector getWordVector(@NotNull String word) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        DenseVector vec = BlasUtilsKt.floatArrayVector(this.args.getDim());
        this.getWordVector(vec, word);
        return vec;
    }

    @NotNull
    public final Meter test(@NotNull File file, int k, float threshold2, boolean print2) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.test(new FileSampleLineIterable(file), k, threshold2, print2);
    }

    public static /* synthetic */ Meter test$default(FastText fastText, File file, int n, float f, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        if ((n2 & 4) != 0) {
            f = 0.0f;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return fastText.test(file, n, f, bl);
    }

    @NotNull
    public final Meter test(@NotNull Iterable<SampleLine> file, int k, float threshold2, boolean print2) {
        Intrinsics.checkParameterIsNotNull(file, (String)"file");
        IntArrayList line = new IntArrayList(0, null, 3, null);
        IntArrayList labels = new IntArrayList(0, null, 3, null);
        Meter meter = new Meter(null, 0L, null, 7, null);
        for (SampleLine sample : file) {
            line.clear();
            labels.clear();
            this.dict.getLine((Iterable<String>)sample.getWords(), line, labels);
            if (labels.isEmpty() || line.isEmpty()) continue;
            List<ScoreIdPair> predictions = this.predict(k, line, threshold2);
            meter.log(labels, predictions);
        }
        if (print2) {
            meter.print(this.dict, k, true);
        }
        return meter;
    }

    public static /* synthetic */ Meter test$default(FastText fastText, Iterable iterable, int n, float f, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        if ((n2 & 4) != 0) {
            f = 0.0f;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return fastText.test(iterable, n, f, bl);
    }

    @NotNull
    public final Vector getSentenceVector(@NotNull Iterable<String> tokens) {
        Intrinsics.checkParameterIsNotNull(tokens, (String)"tokens");
        DenseVector svec = BlasUtilsKt.floatArrayVector(this.args.getDim());
        this.getSentenceVector(svec, tokens);
        return svec;
    }

    /*
     * WARNING - void declaration
     */
    private final void getSentenceVector(Vector svec, Iterable<String> tokens) {
        svec.zero();
        if (this.args.getModel() == ModelName.sup) {
            IntArrayList line = new IntArrayList(0, null, 3, null);
            IntArrayList labels = new IntArrayList(0, null, 3, null);
            this.dict.getLine(tokens, line, labels);
            int n = 0;
            int n2 = line.size();
            while (n < n2) {
                void i;
                this.addInputVector(svec, line.get((int)i));
                ++i;
            }
            if (!line.isEmpty()) {
                svec.timesAssign(Float.valueOf(1.0f / (float)line.size()));
            }
        } else {
            DenseVector vec = BlasUtilsKt.floatArrayVector(this.args.getDim());
            int count = 0;
            for (String word : tokens) {
                this.getWordVector(vec, word);
                float norm = vec.norm2();
                if (!(norm > 0.0f)) continue;
                vec.timesAssign(Float.valueOf(1.0f / norm));
                svec.plusAssign(vec);
                ++count;
            }
            if (count > 0) {
                svec.timesAssign(Float.valueOf(1.0f / (float)count));
            }
        }
    }

    private final void addInputVector(Vector vec, int ind) {
        Matrix.DefaultImpls.addRowToVector$default(this.input, vec, ind, null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void saveVectors(@NotNull String path) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String fileName = path;
        if (!StringsKt.endsWith$default((String)fileName, (String)"vec", (boolean)false, (int)2, null)) {
            fileName = fileName + ".vec";
        }
        File file = new File(fileName);
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file;
        boolean bl3 = false;
        if ($this$apply.exists()) {
            $this$apply.delete();
        }
        if ($this$apply.getParentFile() != null) {
            $this$apply.getParentFile().mkdirs();
        }
        File file2 = file;
        DenseVector vec = BlasUtilsKt.floatArrayVector(this.args.getDim());
        DecimalFormat df = new DecimalFormat("0.#####");
        Object object = file2;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        boolean bl4 = false;
        Object object2 = object;
        int n2 = 0;
        Object object3 = object2;
        boolean bl5 = false;
        object3 = new FileOutputStream((File)object3);
        bl5 = false;
        object2 = new OutputStreamWriter((OutputStream)object3, charset);
        n2 = 0;
        object = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
        boolean bl6 = false;
        Throwable throwable = null;
        try {
            BufferedWriter writer = (BufferedWriter)object;
            boolean bl7 = false;
            writer.write("" + this.dict.getNwords() + ' ' + this.args.getDim() + '\n');
            n2 = 0;
            int n3 = this.dict.getNwords();
            while (n2 < n3) {
                void i;
                String word = this.dict.getWord((int)i);
                this.getWordVector(vec, word);
                writer.write(word);
                writer.write(" ");
                int n4 = 0;
                int n5 = vec.length();
                while (n4 < n5) {
                    void j;
                    writer.write(df.format(vec.get((int)j)));
                    writer.write(" ");
                    ++j;
                }
                writer.write("\n");
                ++i;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveModel(@NotNull String file) throws Exception {
        FileChannel it2;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        File path = new File(file);
        if (path.exists()) {
            FilesKt.deleteRecursively((File)path);
        }
        path.mkdirs();
        Object object = new File(path, "dict.bin");
        boolean bl = false;
        object = new FileOutputStream((File)object).getChannel();
        bl = false;
        Throwable throwable = null;
        try {
            it2 = (FileChannel)object;
            boolean bl2 = false;
            FileChannel fileChannel = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileChannel, (String)"it");
            this.dict.save(fileChannel);
            it2 = Unit.INSTANCE;
        }
        catch (Throwable it2) {
            throwable = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        object = new File(path, "args.bin");
        bl = false;
        object = new FileOutputStream((File)object).getChannel();
        bl = false;
        throwable = null;
        try {
            it2 = (FileChannel)object;
            boolean bl3 = false;
            FileChannel fileChannel = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileChannel, (String)"it");
            this.args.save(fileChannel);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        String qInputFlag = this.input instanceof QuantMatrix ? "q" : "";
        this.input.save(new File(path, qInputFlag + "input.matrix"));
        String qOutputFlag = this.output instanceof QuantMatrix ? "q" : "";
        this.output.save(new File(path, qOutputFlag + "output.matrix"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveModelToSingleFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!file.exists()) {
            file.createNewFile();
        }
        boolean bl = file.isFile();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Object object = file;
        bl2 = false;
        object = new FileOutputStream((File)object).getChannel();
        bl2 = false;
        Throwable throwable = null;
        try {
            FileChannel channel = (FileChannel)object;
            boolean bl5 = false;
            FileChannel fileChannel = channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileChannel, (String)"channel");
            this.args.save(fileChannel);
            this.dict.save(channel);
            IOUtilsKt.writeBoolean(channel, this.input instanceof QuantMatrix);
            IOUtilsKt.writeBoolean(channel, this.output instanceof QuantMatrix);
            this.input.save(channel);
            this.output.save(channel);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @JvmOverloads
    @NotNull
    public final FastText quantize(int dsub, boolean qnorm, boolean qout) {
        if (this.args.getModel() != ModelName.sup) {
            String string = "For now we only support quantization of supervised models";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        boolean normalizeGradient = this.args.getModel() == ModelName.sup;
        Matrix matrix = this.input;
        if (matrix == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.mayabot.nlp.fasttext.blas.DenseMatrix");
        }
        QuantMatrix input_ = QuantMatrixKt.buildQMatrix((DenseMatrix)matrix, dsub, qnorm);
        Matrix output_ = this.output;
        Loss loss_ = this.model.getLoss();
        if (qout) {
            Matrix matrix2 = this.output;
            if (matrix2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.mayabot.nlp.fasttext.blas.DenseMatrix");
            }
            output_ = QuantMatrixKt.buildQMatrix((DenseMatrix)matrix2, 2, qnorm);
            loss_ = LossKt.createLoss(this.args, output_, this.args.getModel(), this.dict);
        }
        return new FastText(this.args, this.dict, new Model(input_, output_, loss_, normalizeGradient), true);
    }

    public static /* synthetic */ FastText quantize$default(FastText fastText, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            bl2 = false;
        }
        return fastText.quantize(n, bl, bl2);
    }

    @JvmOverloads
    @NotNull
    public final FastText quantize(int dsub, boolean qnorm) {
        return FastText.quantize$default(this, dsub, qnorm, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final FastText quantize(int dsub) {
        return FastText.quantize$default(this, dsub, false, false, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final FastText quantize() {
        return FastText.quantize$default(this, 0, false, false, 7, null);
    }

    @NotNull
    public final Args getArgs() {
        return this.args;
    }

    @NotNull
    public final Dictionary getDict() {
        return this.dict;
    }

    @NotNull
    public final Model getModel() {
        return this.model;
    }

    public final boolean getQuant() {
        return this.quant;
    }

    public FastText(@NotNull Args args, @NotNull Dictionary dict, @NotNull Model model, boolean quant) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)dict, (String)"dict");
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        this.args = args;
        this.dict = dict;
        this.model = model;
        this.quant = quant;
        this.input = this.model.getWi();
        this.output = this.model.getWo();
        this.wordVectors$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DenseArrayMatrix>(this){
            final /* synthetic */ FastText this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final DenseArrayMatrix invoke() {
                void var2_2;
                Function1<DenseMatrix, Unit> $fun$preComputeWordVectors$1 = new Function1<DenseMatrix, Unit>(this){
                    final /* synthetic */ wordVectors.2 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull DenseMatrix wordVectors2) {
                        Intrinsics.checkParameterIsNotNull((Object)wordVectors2, (String)"wordVectors");
                        DenseVector vec = BlasUtilsKt.floatArrayVector(this.this$0.this$0.getArgs().getDim());
                        wordVectors2.zero();
                        int n = 0;
                        int n2 = this.this$0.this$0.getDict().getNwords();
                        while (n < n2) {
                            void i;
                            String word = this.this$0.this$0.getDict().getWord((int)i);
                            this.this$0.this$0.getWordVector(vec, word);
                            float norm = vec.norm2();
                            if (norm > 0.0f) {
                                wordVectors2.get((int)i).plusAssign((Pair<? extends Number, ? extends Vector>)TuplesKt.to((Object)Float.valueOf(1.0f / norm), (Object)vec));
                            }
                            ++i;
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                };
                DenseArrayMatrix matrix = BlasUtilsKt.floatArrayMatrix(this.this$0.getDict().getNwords(), this.this$0.getArgs().getDim());
                long s1 = System.currentTimeMillis();
                $fun$preComputeWordVectors$1.invoke((DenseMatrix)matrix);
                long s2 = System.currentTimeMillis();
                LogUtilsKt.loggerln("Init wordVectors martix use time " + (s2 - s1) + " ms");
                return var2_2;
            }
            {
                this.this$0 = fastText;
                super(0);
            }
        }));
    }

    @JvmStatic
    @NotNull
    public static final FastText trainSupervised(@NotNull File file, @NotNull InputArgs inputArgs) {
        return Companion.trainSupervised(file, inputArgs);
    }

    @JvmStatic
    @NotNull
    public static final FastText trainCow(@NotNull File file, @NotNull InputArgs inputArgs) {
        return Companion.trainCow(file, inputArgs);
    }

    @JvmStatic
    @NotNull
    public static final FastText trainSkipgram(@NotNull File file, @NotNull InputArgs inputArgs) {
        return Companion.trainSkipgram(file, inputArgs);
    }

    @JvmStatic
    @NotNull
    public static final FastText train(@NotNull File file, @NotNull ModelName modelName, @NotNull InputArgs inputArgs) {
        return Companion.train(file, modelName, inputArgs);
    }

    @JvmStatic
    @NotNull
    public static final FastText train(@NotNull List<? extends Iterable<SampleLine>> sources, @NotNull ModelName modelName, @NotNull InputArgs inputArgs) {
        return Companion.train(sources, modelName, inputArgs);
    }

    @JvmStatic
    @NotNull
    public static final FastText loadCppModel(@NotNull File file) {
        return Companion.loadCppModel(file);
    }

    @JvmStatic
    @NotNull
    public static final FastText loadCppModel(@NotNull InputStream ins) {
        return Companion.loadCppModel(ins);
    }

    @JvmStatic
    @NotNull
    public static final FastText loadModelFromSingleFile(@NotNull File file) {
        return Companion.loadModelFromSingleFile(file);
    }

    @JvmStatic
    @NotNull
    public static final FastText loadModel(@NotNull File moduleDir, boolean mmap) {
        return Companion.loadModel(moduleDir, mmap);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J,\u0010\u000e\u001a\u00020\u00042\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u001a\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J\u001a\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J\u001a\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007\u00a8\u0006\u001a"}, d2={"Lcom/mayabot/nlp/fasttext/FastText$Companion;", "", "()V", "loadCppModel", "Lcom/mayabot/nlp/fasttext/FastText;", "file", "Ljava/io/File;", "ins", "Ljava/io/InputStream;", "loadModel", "moduleDir", "mmap", "", "loadModelFromSingleFile", "train", "modelName", "Lcom/mayabot/nlp/fasttext/args/ModelName;", "inputArgs", "Lcom/mayabot/nlp/fasttext/args/InputArgs;", "sources", "", "", "Lcom/mayabot/nlp/fasttext/train/SampleLine;", "trainCow", "trainSkipgram", "trainSupervised", "fastText4j"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final FastText trainSupervised(@NotNull File file, @NotNull InputArgs inputArgs) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)inputArgs, (String)"inputArgs");
            return this.train(file, ModelName.sup, inputArgs);
        }

        public static /* synthetic */ FastText trainSupervised$default(Companion companion, File file, InputArgs inputArgs, int n, Object object) {
            if ((n & 2) != 0) {
                inputArgs = new InputArgs();
            }
            return companion.trainSupervised(file, inputArgs);
        }

        @JvmStatic
        @NotNull
        public final FastText trainCow(@NotNull File file, @NotNull InputArgs inputArgs) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)inputArgs, (String)"inputArgs");
            return this.train(file, ModelName.cbow, inputArgs);
        }

        public static /* synthetic */ FastText trainCow$default(Companion companion, File file, InputArgs inputArgs, int n, Object object) {
            if ((n & 2) != 0) {
                inputArgs = new InputArgs();
            }
            return companion.trainCow(file, inputArgs);
        }

        @JvmStatic
        @NotNull
        public final FastText trainSkipgram(@NotNull File file, @NotNull InputArgs inputArgs) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)inputArgs, (String)"inputArgs");
            return this.train(file, ModelName.sg, inputArgs);
        }

        public static /* synthetic */ FastText trainSkipgram$default(Companion companion, File file, InputArgs inputArgs, int n, Object object) {
            if ((n & 2) != 0) {
                inputArgs = new InputArgs();
            }
            return companion.trainSkipgram(file, inputArgs);
        }

        @JvmStatic
        @NotNull
        public final FastText train(@NotNull File file, @NotNull ModelName modelName, @NotNull InputArgs inputArgs) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)((Object)modelName), (String)"modelName");
            Intrinsics.checkParameterIsNotNull((Object)inputArgs, (String)"inputArgs");
            Args args = inputArgs.parse(modelName);
            Function0<List<? extends Iterable<? extends SampleLine>>> $fun$prepareSources$1 = new Function0<List<? extends Iterable<? extends SampleLine>>>(file, args){
                final /* synthetic */ File $file;
                final /* synthetic */ Args $args;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<Iterable<SampleLine>> invoke() {
                    List list;
                    FileSampleLineIterable parent = new FileSampleLineIterable(this.$file);
                    int thread = this.$args.getThread();
                    int Size50M = 0x6400000;
                    int lines = -1;
                    if (this.$file.length() < (long)Size50M && (lines = parent.lines()) <= thread * 10) {
                        thread = 1;
                    }
                    if (thread == 1) {
                        list = this.$file.length() < (long)Size50M ? CollectionsKt.listOf((Object)parent.toMemList()) : CollectionsKt.listOf((Object)parent);
                    } else if (this.$file.length() < (long)Size50M) {
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv = parent.splitMutiFiles(thread);
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            FileSampleLineIterable fileSampleLineIterable = (FileSampleLineIterable)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            MemSampleLineList memSampleLineList = it.toMemList();
                            collection.add(memSampleLineList);
                        }
                        list = (List)destination$iv$iv;
                    } else {
                        list = parent.splitMutiFiles(thread);
                    }
                    return list;
                }
                {
                    this.$file = file;
                    this.$args = args;
                    super(0);
                }
            };
            return this.train((List<? extends Iterable<SampleLine>>)$fun$prepareSources$1.invoke(), modelName, inputArgs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final FastText train(@NotNull List<? extends Iterable<SampleLine>> sources, @NotNull ModelName modelName, @NotNull InputArgs inputArgs) {
            Intrinsics.checkParameterIsNotNull(sources, (String)"sources");
            Intrinsics.checkParameterIsNotNull((Object)((Object)modelName), (String)"modelName");
            Intrinsics.checkParameterIsNotNull((Object)inputArgs, (String)"inputArgs");
            Args args = inputArgs.parse(modelName);
            try {
                boolean bl;
                Matrix matrix;
                Dictionary dict = BuildDictFromSourceKt.buildFromFile$default(args, sources, args.getMaxVocabSize(), 0, 8, null);
                if (args.getPreTrainedVectors() != null) {
                    matrix = LoadPretraindVectorKt.loadPreTrainVectors(dict, args.getPreTrainedVectors(), args);
                } else {
                    DenseArrayMatrix denseArrayMatrix = BlasUtilsKt.floatArrayMatrix(dict.getNwords() + args.getBucket(), args.getDim());
                    boolean bl2 = false;
                    bl = false;
                    DenseArrayMatrix $this$apply = denseArrayMatrix;
                    boolean bl3 = false;
                    $this$apply.uniform(Float.valueOf(1.0f / (float)args.getDim()));
                    matrix = denseArrayMatrix;
                }
                Matrix input = matrix;
                dict.init();
                DenseArrayMatrix denseArrayMatrix = BlasUtilsKt.floatArrayMatrix(ModelName.sup == args.getModel() ? dict.getNlabels() : dict.getNwords(), args.getDim());
                bl = false;
                boolean $this$apply = false;
                DenseArrayMatrix $this$apply2 = denseArrayMatrix;
                boolean bl4 = false;
                $this$apply2.zero();
                DenseArrayMatrix output = denseArrayMatrix;
                Loss loss = LossKt.createLoss(args, output, args.getModel(), dict);
                boolean normalizeGradient = args.getModel() == ModelName.sup;
                Model model = new Model(input, output, loss, normalizeGradient);
                FastText fastText = new FastText(args, dict, model, false);
                new FastTextTrain(args, fastText).startThreads(sources);
                FastText fastText2 = fastText;
                return fastText2;
            }
            finally {
                for (Iterable<SampleLine> iterable : sources) {
                    if (!(iterable instanceof FileSampleLineIterable)) continue;
                    ((FileSampleLineIterable)iterable).getFile().delete();
                }
            }
        }

        @JvmStatic
        @NotNull
        public final FastText loadCppModel(@NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            return CppFastTextSupport.INSTANCE.load(file);
        }

        @JvmStatic
        @NotNull
        public final FastText loadCppModel(@NotNull InputStream ins) {
            Intrinsics.checkParameterIsNotNull((Object)ins, (String)"ins");
            return CppFastTextSupport.INSTANCE.loadCModel(ins);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final FastText loadModelFromSingleFile(@NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            boolean bl = file.exists() && file.isFile();
            int n = 0;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Object object = file;
            n = 0;
            object = new FileInputStream((File)object);
            n = 8192;
            bl2 = false;
            object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            n = 0;
            Throwable throwable = null;
            try {
                Matrix inputMatrix;
                BufferedInputStream ins = (BufferedInputStream)object;
                boolean bl4 = false;
                AutoDataInput adi = new AutoDataInput(new DataInputStream(ins), null, 2, null);
                Args args = Args.Companion.load(adi);
                Dictionary dict = Dictionary.Companion.loadModel(args, adi);
                boolean quantInput = adi.readBoolean();
                boolean quantOutput = adi.readBoolean();
                Matrix matrix = inputMatrix = quantInput ? (Matrix)QuantMatrixKt.loadQuantMatrix(adi) : (Matrix)DenseArrayMatrixKt.loadDenseMatrix(adi);
                if (!quantInput && dict.isPruned()) {
                    String string = "Invalid model file.\nPlease download the updated model from www.fasttext.cc.\nSee issue #332 on Github for more information.\n";
                    boolean bl5 = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                Matrix output = quantOutput ? (Matrix)QuantMatrixKt.loadQuantMatrix(adi) : (Matrix)DenseArrayMatrixKt.loadDenseMatrix(adi);
                Loss loss = LossKt.createLoss(args, output, args.getModel(), dict);
                boolean normalizeGradient = args.getModel() == ModelName.sup;
                FastText fastText = new FastText(args, dict, new Model(inputMatrix, output, loss, normalizeGradient), quantInput);
                return fastText;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final FastText loadModel(@NotNull File moduleDir, boolean mmap) {
            Matrix input;
            Intrinsics.checkParameterIsNotNull((Object)moduleDir, (String)"moduleDir");
            boolean bl = moduleDir.exists() && moduleDir.isDirectory();
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Args args = Args.Companion.load(new File(moduleDir, "args.bin"));
            Closeable closeable = IOUtilsKt.openDataInputStream(new File(moduleDir, "dict.bin"));
            bl4 = false;
            Object object = null;
            try {
                Object it = (DataInputStream)closeable;
                boolean bl6 = false;
                it = Dictionary.Companion.loadModel(args, new AutoDataInput((DataInput)it, null, 2, null));
            }
            catch (Throwable it) {
                object = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            Object dict = it;
            boolean quant = new File(moduleDir, "qinput.matrix").exists();
            Matrix matrix = input = quant ? (Matrix)QuantMatrixKt.loadQuantMatrix(new File(moduleDir, "qinput.matrix")) : (Matrix)DenseArrayMatrixKt.loadDenseMatrix(new File(moduleDir, "input.matrix"), mmap);
            if (!quant && ((Dictionary)dict).isPruned()) {
                object = "Invalid model file.\nPlease download the updated model from www.fasttext.cc.\nSee issue #332 on Github for more information.\n";
                boolean it = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            Matrix output = new File(moduleDir, "qoutput.matrix").exists() ? (Matrix)QuantMatrixKt.loadQuantMatrix(new File(moduleDir, "qoutput.matrix")) : (Matrix)DenseArrayMatrixKt.loadDenseMatrix(new File(moduleDir, "output.matrix"), mmap);
            Loss loss = LossKt.createLoss(args, output, args.getModel(), (Dictionary)dict);
            boolean normalizeGradient = args.getModel() == ModelName.sup;
            return new FastText(args, (Dictionary)dict, new Model(input, output, loss, normalizeGradient), quant);
        }

        public static /* synthetic */ FastText loadModel$default(Companion companion, File file, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.loadModel(file, bl);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

