/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fasttext.blas;

import com.mayabot.nlp.fasttext.blas.ByteBufferDenseVector;
import com.mayabot.nlp.fasttext.blas.ByteBufferMatrix;
import com.mayabot.nlp.fasttext.blas.DenseArrayMatrix;
import com.mayabot.nlp.fasttext.blas.DenseVector;
import com.mayabot.nlp.fasttext.blas.Vector;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b\u001a\u0016\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003\u001a\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b\u001a\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u0003\u00a8\u0006\u0016"}, d2={"byteBufferMatrix", "Lcom/mayabot/nlp/fasttext/blas/ByteBufferMatrix;", "rows", "", "cols", "byteBufferVector", "Lcom/mayabot/nlp/fasttext/blas/ByteBufferDenseVector;", "size", "cosine", "", "a", "Lcom/mayabot/nlp/fasttext/blas/Vector;", "b", "directByteBufferMatrix", "directByteBufferVector", "dot", "floatArrayMatrix", "Lcom/mayabot/nlp/fasttext/blas/DenseArrayMatrix;", "data", "", "floatArrayVector", "Lcom/mayabot/nlp/fasttext/blas/DenseVector;", "fastText4j"})
public final class BlasUtilsKt {
    public static final float dot(@NotNull Vector a, @NotNull Vector b) {
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        return a.times(b);
    }

    public static final float cosine(@NotNull Vector a, @NotNull Vector b) {
        float f;
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        float normA = a.times(a);
        float normB = b.times(b);
        if (normA == 0.0f || normB == 0.0f) {
            f = 0.0f;
        } else {
            double d = normA * normB;
            double d2 = a.times(b);
            boolean bl = false;
            double d3 = Math.sqrt(d);
            f = (float)(d2 / d3);
        }
        return f;
    }

    @NotNull
    public static final DenseVector floatArrayVector(int size) {
        return new DenseVector(size);
    }

    @NotNull
    public static final ByteBufferDenseVector byteBufferVector(int size) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(size << 2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.allocate(size shl 2)");
        return new ByteBufferDenseVector(byteBuffer, 0, size);
    }

    @NotNull
    public static final ByteBufferDenseVector directByteBufferVector(int size) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(size << 2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.allocateDirect(size shl 2)");
        return new ByteBufferDenseVector(byteBuffer, 0, size);
    }

    @NotNull
    public static final DenseArrayMatrix floatArrayMatrix(int rows, int cols, @NotNull float[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return new DenseArrayMatrix(rows, cols, data);
    }

    @NotNull
    public static final DenseArrayMatrix floatArrayMatrix(int rows, int cols) {
        return new DenseArrayMatrix(rows, cols);
    }

    @NotNull
    public static final ByteBufferMatrix byteBufferMatrix(int rows, int cols) {
        return new ByteBufferMatrix(rows, cols, false);
    }

    @NotNull
    public static final ByteBufferMatrix directByteBufferMatrix(int rows, int cols) {
        return new ByteBufferMatrix(rows, cols, true);
    }
}

