/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fasttext.blas;

import com.mayabot.nlp.fasttext.blas.BasicDenseMatrix;
import com.mayabot.nlp.fasttext.blas.ByteBufferDenseVector;
import com.mayabot.nlp.fasttext.blas.Vector;
import com.mayabot.nlp.fasttext.utils.IOUtilsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001d\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0004H\u0096\u0002J\u0019\u0010\u0013\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0096\u0002J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J!\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0015H\u0096\u0002J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u001aH\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/mayabot/nlp/fasttext/blas/ByteBufferMatrix;", "Lcom/mayabot/nlp/fasttext/blas/BasicDenseMatrix;", "()V", "rows", "", "cols", "direct", "", "(IIZ)V", "row", "col", "data", "Ljava/nio/ByteBuffer;", "(IILjava/nio/ByteBuffer;)V", "getData", "()Ljava/nio/ByteBuffer;", "length", "rnd", "Ljava/util/Random;", "get", "Lcom/mayabot/nlp/fasttext/blas/Vector;", "", "i", "j", "index", "save", "", "file", "Ljava/io/File;", "channel", "Ljava/nio/channels/FileChannel;", "set", "v", "uniform", "number", "", "zero", "fastText4j"})
public final class ByteBufferMatrix
extends BasicDenseMatrix {
    private final int length;
    private final Random rnd;
    @NotNull
    private final ByteBuffer data;

    /*
     * WARNING - void declaration
     */
    @Override
    public void zero() {
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.length)), (int)4);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                void i;
                this.data.putFloat((int)i, 0.0f);
                if (i == n2) break;
                n = i + n3;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void uniform(@NotNull Number number) {
        Intrinsics.checkParameterIsNotNull((Object)number, (String)"number");
        float a = number.floatValue();
        float lower = -a;
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.length)), (int)4);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                void i;
                this.data.putFloat((int)i, this.rnd.nextFloat() * (a - lower) + lower);
                if (i == n2) break;
                i += n3;
            }
        }
    }

    @Override
    public float get(int i, int j) {
        return this.data.getFloat(this.index(i, j) << 2);
    }

    @Override
    public void set(int i, int j, float v) {
        this.data.putFloat(this.index(i, j) << 2, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Object object = file;
        boolean bl = false;
        object = new FileOutputStream((File)object).getChannel();
        bl = false;
        Throwable throwable = null;
        try {
            FileChannel channel = (FileChannel)object;
            boolean bl2 = false;
            FileChannel fileChannel = channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileChannel, (String)"channel");
            this.save(fileChannel);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @Override
    public void save(@NotNull FileChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Function1<FileChannel, Unit> $fun$write$2 = new Function1<FileChannel, Unit>(this){
            final /* synthetic */ ByteBufferMatrix this$0;

            public final void invoke(@NotNull FileChannel channel) {
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                this.this$0.getData().position(0);
                this.this$0.getData().limit(this.this$0.getData().capacity());
                channel.write(this.this$0.getData());
            }
            {
                this.this$0 = byteBufferMatrix;
                super(1);
            }
        };
        IOUtilsKt.writeInt(channel, this.getRow());
        IOUtilsKt.writeInt(channel, this.getCol());
        $fun$write$2.invoke(channel);
    }

    private final int index(int i, int j) {
        return i * this.getCol() + j;
    }

    @Override
    @NotNull
    public Vector get(int row) {
        return new ByteBufferDenseVector(this.data, row * this.getCol(), this.getCol());
    }

    @NotNull
    public final ByteBuffer getData() {
        return this.data;
    }

    public ByteBufferMatrix(int row, int col, @NotNull ByteBuffer data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        super(row, col);
        this.data = data;
        this.length = row * col;
        this.rnd = new Random();
    }

    public ByteBufferMatrix() {
        this(0, 0, false, 4, null);
    }

    public ByteBufferMatrix(int rows, int cols, boolean direct) {
        ByteBuffer byteBuffer = direct ? ByteBuffer.allocateDirect(rows * cols << 2) : ByteBuffer.allocate(rows * cols << 2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"if (direct)\n            \u2026cate((rows * cols) shl 2)");
        this(rows, cols, byteBuffer);
    }

    public /* synthetic */ ByteBufferMatrix(int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            bl = true;
        }
        this(n, n2, bl);
    }
}

