/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fasttext.blas;

import com.mayabot.nlp.fasttext.blas.DenseMatrix;
import com.mayabot.nlp.fasttext.blas.Vector;
import com.mayabot.nlp.fasttext.utils.IOUtilsKt;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0002 !B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u001d\u001a\u00060\u001eR\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0003H\u0086\u0002R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0004\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u0011\u0010\u0017\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000eR\u0011\u0010\u0019\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000eR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/mayabot/nlp/fasttext/blas/CentroidTable;", "", "dim", "", "ksub", "dsub", "(III)V", "centroidData", "", "getCentroidData", "()[F", "setCentroidData", "([F)V", "getDsub$fastText4j", "()I", "setDsub$fastText4j", "(I)V", "eps_", "", "getEps_", "()F", "getKsub$fastText4j", "setKsub$fastText4j", "lastdsub", "getLastdsub", "nsubq", "getNsubq", "random", "Ljava/util/Random;", "get", "Lcom/mayabot/nlp/fasttext/blas/CentroidTable$MCentroid;", "m", "Companion", "MCentroid", "fastText4j"})
public final class CentroidTable {
    private final Random random;
    private final float eps_ = 1.0E-7f;
    @NotNull
    private float[] centroidData;
    private final int nsubq;
    private final int lastdsub;
    private int ksub;
    private int dsub;
    private static final int niter_ = 25;
    public static final Companion Companion = new Companion(null);

    public final float getEps_() {
        return this.eps_;
    }

    @NotNull
    public final float[] getCentroidData() {
        return this.centroidData;
    }

    public final void setCentroidData(@NotNull float[] fArray) {
        Intrinsics.checkParameterIsNotNull((Object)fArray, (String)"<set-?>");
        this.centroidData = fArray;
    }

    public final int getNsubq() {
        return this.nsubq;
    }

    public final int getLastdsub() {
        return this.lastdsub;
    }

    @NotNull
    public final MCentroid get(int m) {
        return new MCentroid(m);
    }

    public final int getKsub$fastText4j() {
        return this.ksub;
    }

    public final void setKsub$fastText4j(int n) {
        this.ksub = n;
    }

    public final int getDsub$fastText4j() {
        return this.dsub;
    }

    public final void setDsub$fastText4j(int n) {
        this.dsub = n;
    }

    public CentroidTable(int dim, int ksub, int dsub) {
        this.ksub = ksub;
        this.dsub = dsub;
        this.random = new Random(1234L);
        this.eps_ = 1.0E-7f;
        this.centroidData = new float[dim * this.ksub];
        this.nsubq = IOUtilsKt.pages(dim, this.dsub);
        this.lastdsub = dim % this.dsub == 0 ? this.dsub : dim % this.dsub;
    }

    static {
        niter_ = 25;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/mayabot/nlp/fasttext/blas/CentroidTable$MCentroid;", "", "m", "", "(Lcom/mayabot/nlp/fasttext/blas/CentroidTable;I)V", "d", "getD", "()I", "getM", "start", "assignCentroid", "", "data", "Lcom/mayabot/nlp/fasttext/blas/Vector;", "offset", "distL2", "", "dataRow", "iZ", "index", "i", "kmeans", "", "xslice", "Lcom/mayabot/nlp/fasttext/blas/DenseMatrix;", "fastText4j"})
    public final class MCentroid {
        private final int start;
        private final int d;
        private final int m;

        public final int getD() {
            return this.d;
        }

        /*
         * WARNING - void declaration
         */
        public final void kmeans(@NotNull DenseMatrix xslice) {
            int ii;
            int n;
            Intrinsics.checkParameterIsNotNull((Object)xslice, (String)"xslice");
            int n2 = xslice.getRow();
            int[] perm = new int[n2];
            IOUtilsKt.iota(perm);
            IOUtilsKt.shuffle(perm, CentroidTable.this.random);
            int n3 = 0;
            int n4 = CentroidTable.this.getKsub$fastText4j();
            while (n3 < n4) {
                void i;
                Vector r = xslice.get(perm[i]);
                int s = this.start + i * this.d;
                int n5 = 0;
                n = this.d;
                while (n5 < n) {
                    CentroidTable.this.getCentroidData()[s++] = r.get(ii);
                    ++ii;
                }
                ++i;
            }
            short[] codes = new short[n2];
            n4 = 0;
            int n6 = Companion.getNiter_();
            while (n4 < n6) {
                void q;
                int n7;
                int k;
                int i;
                int s = 0;
                ii = n2;
                while (s < ii) {
                    void i2;
                    codes[i2] = this.assignCentroid(xslice.get((int)i2), 0);
                    ++i2;
                }
                int[] nelts = new int[CentroidTable.this.getKsub$fastText4j()];
                ii = this.start;
                n = CentroidTable.this.getKsub$fastText4j() * this.d;
                while (ii < n) {
                    CentroidTable.this.getCentroidData()[i] = 0.0f;
                    ++i;
                }
                n = n2;
                for (i = 0; i < n; ++i) {
                    short k2 = codes[i];
                    int t = 0;
                    Vector r = xslice.get(i);
                    int j = this.start + k2 * this.d;
                    int max = this.start + k2 * this.d + this.d;
                    while (j < max) {
                        float[] fArray = CentroidTable.this.getCentroidData();
                        int n8 = j++;
                        fArray[n8] = fArray[n8] + r.get(t++);
                    }
                    short s2 = k2;
                    int n9 = nelts[s2];
                    nelts[s2] = n9 + 1;
                }
                int c = this.start;
                n = 0;
                int n10 = CentroidTable.this.getKsub$fastText4j();
                while (n < n10) {
                    int z = nelts[k];
                    if (z != 0) {
                        int r = 0;
                        n7 = this.d;
                        while (r < n7) {
                            void j;
                            float[] fArray = CentroidTable.this.getCentroidData();
                            int n11 = c++;
                            fArray[n11] = fArray[n11] / (float)z;
                            ++j;
                        }
                    } else {
                        c += this.d;
                    }
                    ++k;
                }
                n10 = CentroidTable.this.getKsub$fastText4j();
                for (k = 0; k < n10; ++k) {
                    if (nelts[k] != 0) continue;
                    int m = 0;
                    while (CentroidTable.this.random.nextFloat() * (float)(n2 - CentroidTable.this.getKsub$fastText4j()) >= (float)(nelts[m] - 1)) {
                        m = (m + 1) % CentroidTable.this.getKsub$fastText4j();
                    }
                    System.arraycopy(CentroidTable.this.getCentroidData(), this.start + m * this.d, CentroidTable.this.getCentroidData(), this.start + k * this.d, this.d);
                    n7 = this.d;
                    for (int j = 0; j < n7; ++j) {
                        int sign = j % 2 * 2 - 1;
                        float[] fArray = CentroidTable.this.getCentroidData();
                        int n12 = this.start + k * this.d + j;
                        fArray[n12] = fArray[n12] + (float)sign * CentroidTable.this.getEps_();
                        float[] fArray2 = CentroidTable.this.getCentroidData();
                        int n13 = this.start + m * this.d + j;
                        fArray2[n13] = fArray2[n13] - (float)sign * CentroidTable.this.getEps_();
                    }
                    nelts[k] = nelts[m] / 2;
                    int n14 = m;
                    nelts[n14] = nelts[n14] - nelts[k];
                }
                ++q;
            }
        }

        private final int index(int i) {
            return this.start + i * this.d;
        }

        /*
         * WARNING - void declaration
         */
        public final short assignCentroid(@NotNull Vector data, int offset) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            float dis = this.distL2(data, offset, 0);
            short code = 0;
            int n = 1;
            int n2 = CentroidTable.this.getKsub$fastText4j();
            while (n < n2) {
                void j;
                float disij = this.distL2(data, offset, (int)j);
                if (disij < dis) {
                    code = (short)j;
                    dis = disij;
                }
                ++j;
            }
            return code;
        }

        /*
         * WARNING - void declaration
         */
        public final float distL2(@NotNull Vector dataRow, int offset, int iZ) {
            Intrinsics.checkParameterIsNotNull((Object)dataRow, (String)"dataRow");
            float dist = 0.0f;
            int j = this.index(iZ);
            int n = offset;
            int n2 = offset + this.d;
            while (n < n2) {
                void i;
                float tmp = dataRow.get((int)i) - CentroidTable.this.getCentroidData()[j];
                dist += tmp * tmp;
                ++j;
                ++i;
            }
            return dist;
        }

        public final int getM() {
            return this.m;
        }

        public MCentroid(int m) {
            this.m = m;
            this.start = this.m * CentroidTable.this.getKsub$fastText4j() * CentroidTable.this.getDsub$fastText4j();
            this.d = this.m == CentroidTable.this.getNsubq() - 1 ? CentroidTable.this.getLastdsub() : CentroidTable.this.getDsub$fastText4j();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/mayabot/nlp/fasttext/blas/CentroidTable$Companion;", "", "()V", "niter_", "", "getNiter_", "()I", "fastText4j"})
    public static final class Companion {
        public final int getNiter_() {
            return niter_;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

