/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fasttext.blas;

import com.mayabot.nlp.fasttext.blas.BlasUtilsKt;
import com.mayabot.nlp.fasttext.blas.CentroidTable;
import com.mayabot.nlp.fasttext.blas.DenseArrayMatrix;
import com.mayabot.nlp.fasttext.blas.DenseMatrix;
import com.mayabot.nlp.fasttext.blas.Vector;
import com.mayabot.nlp.fasttext.utils.AutoDataInput;
import com.mayabot.nlp.fasttext.utils.IOUtilsKt;
import com.mayabot.nlp.fasttext.utils.LogUtilsKt;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0001+B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001aJ\u0016\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%J&\u0010&\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/mayabot/nlp/fasttext/blas/ProductQuantizer;", "", "dim", "", "dsub", "(II)V", "centroidTable", "Lcom/mayabot/nlp/fasttext/blas/CentroidTable;", "getCentroidTable", "()Lcom/mayabot/nlp/fasttext/blas/CentroidTable;", "getDim", "()I", "getDsub", "lastdsub_", "getLastdsub_", "nsubq_", "getNsubq_", "setNsubq_", "(I)V", "random", "Ljava/util/Random;", "addCode", "", "x", "Lcom/mayabot/nlp/fasttext/blas/Vector;", "codes_", "", "t", "alpha", "", "compute_codes", "data", "Lcom/mayabot/nlp/fasttext/blas/DenseMatrix;", "codes", "get_centroids", "m", "i", "", "mulCode", "save", "chan", "Ljava/nio/channels/FileChannel;", "train", "Companion", "fastText4j"})
public final class ProductQuantizer {
    private int nsubq_;
    private final int lastdsub_;
    private final Random random;
    @NotNull
    private final CentroidTable centroidTable;
    private final int dim;
    private final int dsub;
    private static final int nbits_ = 8;
    private static final int ksub_ = 256;
    private static final int max_points_per_cluster_ = 256;
    private static final int max_points_ = 65536;
    public static final Companion Companion = new Companion(null);

    public final int getNsubq_() {
        return this.nsubq_;
    }

    public final void setNsubq_(int n) {
        this.nsubq_ = n;
    }

    public final int getLastdsub_() {
        return this.lastdsub_;
    }

    @NotNull
    public final CentroidTable getCentroidTable() {
        return this.centroidTable;
    }

    public final void save(@NotNull FileChannel chan) {
        ByteBuffer byteBuffer;
        Intrinsics.checkParameterIsNotNull((Object)chan, (String)"chan");
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(16 + this.centroidTable.getCentroidData().length * 4);
        FileChannel fileChannel = chan;
        boolean bl = false;
        boolean bl2 = false;
        ByteBuffer $this$apply = byteBuffer2;
        boolean bl3 = false;
        $this$apply.putInt(this.dim);
        $this$apply.putInt(this.nsubq_);
        $this$apply.putInt(this.dsub);
        $this$apply.putInt(this.lastdsub_);
        IOUtilsKt.writeFloatArray($this$apply, this.centroidTable.getCentroidData());
        byteBuffer2 = byteBuffer = byteBuffer2;
        bl = false;
        bl2 = false;
        $this$apply = byteBuffer2;
        boolean bl4 = false;
        $this$apply.flip();
        byteBuffer = byteBuffer2;
        fileChannel.write(byteBuffer);
    }

    /*
     * WARNING - void declaration
     */
    public final void train(@NotNull DenseMatrix data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        int n = data.getRow();
        int n2 = max_points_;
        boolean bl = false;
        int np = Math.min(n, n2);
        int[] perm = new int[data.getRow()];
        IOUtilsKt.iota(perm);
        int d = this.dsub;
        DenseArrayMatrix xslice = BlasUtilsKt.floatArrayMatrix(np, this.dsub);
        float[] xsliceData = xslice.getData();
        LogUtilsKt.logger("Product Quantize 0%");
        int n3 = 0;
        int n4 = this.nsubq_;
        while (n3 < n4) {
            void m;
            LogUtilsKt.logger("\r");
            LogUtilsKt.logger("pq " + (int)((double)(m + true) * 100.0 / (double)this.nsubq_) + '%');
            if (m == this.nsubq_ - 1) {
                d = this.lastdsub_;
            }
            if (np != data.getRow()) {
                IOUtilsKt.shuffle(perm, this.random);
            }
            int xp = 0;
            int n5 = 0;
            int n6 = np;
            while (n5 < n6) {
                void j;
                int row = perm[j];
                void var13_15 = m * this.dsub;
                void var14_16 = m * this.dsub + d;
                while (var13_15 < var14_16) {
                    void p;
                    xsliceData[xp++] = data.get(row, (int)p);
                    ++p;
                }
                ++j;
            }
            this.centroidTable.get((int)m).kmeans(xslice);
            ++m;
        }
        LogUtilsKt.logger("\n");
    }

    /*
     * WARNING - void declaration
     */
    public final void compute_codes(@NotNull DenseMatrix data, @NotNull short[] codes) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)codes, (String)"codes");
        int n = 0;
        int n2 = data.getRow();
        while (n < n2) {
            void i;
            void c = i * this.nsubq_;
            Vector dataRow = data.get((int)i);
            int n3 = 0;
            int n4 = this.nsubq_;
            while (n3 < n4) {
                void m;
                CentroidTable.MCentroid mCentroid = this.centroidTable.get((int)m);
                short k = mCentroid.assignCentroid(dataRow, (int)(m * this.dsub));
                codes[c + m] = k;
                ++m;
            }
            ++i;
        }
    }

    public final int get_centroids(int m, short i) {
        return m == this.nsubq_ - 1 ? m * ksub_ * this.dsub + i * this.lastdsub_ : (m * ksub_ + i) * this.dsub;
    }

    /*
     * WARNING - void declaration
     */
    public final void addCode(@NotNull Vector x, @NotNull short[] codes_, int t, float alpha) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Intrinsics.checkParameterIsNotNull((Object)codes_, (String)"codes_");
        int d = this.dsub;
        int codeOffset = this.nsubq_ * t;
        float[] centroidData = this.centroidTable.getCentroidData();
        int n = 0;
        int n2 = this.nsubq_;
        while (n < n2) {
            void m;
            int c = this.get_centroids((int)m, codes_[codeOffset + m]);
            if (m == this.nsubq_ - 1) {
                d = this.lastdsub_;
            }
            int n3 = 0;
            int n4 = d;
            while (n3 < n4) {
                void n5;
                try {
                    Vector vector = x;
                    void v1 = m * this.dsub + n5;
                    vector.set((int)v1, vector.get((int)v1) + alpha * centroidData[c + n5]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n5;
            }
            ++m;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final float mulCode(@NotNull Vector x, @NotNull short[] codes_, int t, float alpha) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Intrinsics.checkParameterIsNotNull((Object)codes_, (String)"codes_");
        float res = 0.0f;
        int d = this.dsub;
        int codeOffset = this.nsubq_ * t;
        float[] centroidData = this.centroidTable.getCentroidData();
        int n = 0;
        int n2 = this.nsubq_;
        while (n < n2) {
            void m;
            int c = this.get_centroids((int)m, codes_[codeOffset + m]);
            if (m == this.nsubq_ - 1) {
                d = this.lastdsub_;
            }
            int n3 = 0;
            int n4 = d;
            while (n3 < n4) {
                void n5;
                res += x.get((int)(m * this.dsub + n5)) * centroidData[c + n5];
                ++n5;
            }
            ++m;
        }
        return res * alpha;
    }

    public final int getDim() {
        return this.dim;
    }

    public final int getDsub() {
        return this.dsub;
    }

    public ProductQuantizer(int dim, int dsub) {
        this.dim = dim;
        this.dsub = dsub;
        this.nsubq_ = IOUtilsKt.pages(this.dim, this.dsub);
        this.lastdsub_ = this.dim % this.dsub == 0 ? this.dsub : this.dim % this.dsub;
        this.random = new Random(1234L);
        this.centroidTable = new CentroidTable(this.dim, ksub_, this.dsub);
    }

    static {
        nbits_ = 8;
        ksub_ = 1 << nbits_;
        max_points_per_cluster_ = 256;
        max_points_ = max_points_per_cluster_ * ksub_;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/mayabot/nlp/fasttext/blas/ProductQuantizer$Companion;", "", "()V", "ksub_", "", "getKsub_", "()I", "max_points_", "getMax_points_", "max_points_per_cluster_", "getMax_points_per_cluster_", "nbits_", "getNbits_", "loadFromBuffer", "Lcom/mayabot/nlp/fasttext/blas/ProductQuantizer;", "buffer", "Lcom/mayabot/nlp/fasttext/utils/AutoDataInput;", "fastText4j"})
    public static final class Companion {
        public final int getNbits_() {
            return nbits_;
        }

        public final int getKsub_() {
            return ksub_;
        }

        public final int getMax_points_per_cluster_() {
            return max_points_per_cluster_;
        }

        public final int getMax_points_() {
            return max_points_;
        }

        @NotNull
        public final ProductQuantizer loadFromBuffer(@NotNull AutoDataInput buffer) {
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            int dim = buffer.readInt();
            int nsubq = buffer.readInt();
            int dsub = buffer.readInt();
            int lastdsub = buffer.readInt();
            ProductQuantizer result = new ProductQuantizer(dim, dsub);
            buffer.readFloatArray(result.getCentroidTable().getCentroidData());
            return result;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

