/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fasttext.blas;

import com.mayabot.nlp.fasttext.blas.BlasUtilsKt;
import com.mayabot.nlp.fasttext.blas.DenseArrayMatrix;
import com.mayabot.nlp.fasttext.blas.DenseMatrix;
import com.mayabot.nlp.fasttext.blas.DenseVector;
import com.mayabot.nlp.fasttext.blas.Matrix;
import com.mayabot.nlp.fasttext.blas.ProductQuantizer;
import com.mayabot.nlp.fasttext.blas.Vector;
import com.mayabot.nlp.fasttext.utils.IOUtilsKt;
import com.mayabot.nlp.fasttext.utils.LogUtilsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ'\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00032\b\u0010$\u001a\u0004\u0018\u00010%H\u0016\u00a2\u0006\u0002\u0010&J \u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010$\u001a\u00020*H\u0016J\u0018\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003H\u0016J\u000e\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020/J\u0010\u00100\u001a\u00020 2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020 2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00103\u001a\u00020 2\u0006\u00106\u001a\u000207H\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0010\u00a8\u00068"}, d2={"Lcom/mayabot/nlp/fasttext/blas/QuantMatrix;", "Lcom/mayabot/nlp/fasttext/blas/Matrix;", "m", "", "n", "codeSize", "pq", "Lcom/mayabot/nlp/fasttext/blas/ProductQuantizer;", "npq", "codes", "", "normCodes", "qnorm", "", "(IIILcom/mayabot/nlp/fasttext/blas/ProductQuantizer;Lcom/mayabot/nlp/fasttext/blas/ProductQuantizer;[S[SZ)V", "getCodeSize", "()I", "getCodes", "()[S", "col", "getCol", "getM", "getN", "getNormCodes", "getNpq", "()Lcom/mayabot/nlp/fasttext/blas/ProductQuantizer;", "getPq", "getQnorm", "()Z", "row", "getRow", "addRowToVector", "", "target", "Lcom/mayabot/nlp/fasttext/blas/Vector;", "i", "a", "", "(Lcom/mayabot/nlp/fasttext/blas/Vector;ILjava/lang/Double;)V", "addVectorToRow", "vector", "rows", "", "dotRow", "vec", "quantize", "matrix", "Lcom/mayabot/nlp/fasttext/blas/DenseMatrix;", "quantizeNorm", "norms", "Lcom/mayabot/nlp/fasttext/blas/DenseVector;", "save", "file", "Ljava/io/File;", "channel", "Ljava/nio/channels/FileChannel;", "fastText4j"})
public final class QuantMatrix
implements Matrix {
    private final int row;
    private final int col;
    private final int m;
    private final int n;
    private final int codeSize;
    @NotNull
    private final ProductQuantizer pq;
    @NotNull
    private final ProductQuantizer npq;
    @NotNull
    private final short[] codes;
    @NotNull
    private final short[] normCodes;
    private final boolean qnorm;

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public int getCol() {
        return this.col;
    }

    public final void quantize(@NotNull DenseMatrix matrix) {
        Intrinsics.checkParameterIsNotNull((Object)matrix, (String)"matrix");
        if (this.qnorm) {
            DenseVector norms = BlasUtilsKt.floatArrayVector(this.m);
            matrix.l2NormRow(norms);
            DenseMatrix.DefaultImpls.divideRow$default(matrix, norms, 0, 0, 6, null);
            this.quantizeNorm(norms);
        }
        this.pq.train(matrix);
        LogUtilsKt.loggerln("compute_codes...");
        this.pq.compute_codes(matrix, this.codes);
        LogUtilsKt.loggerln("compute_codes success");
    }

    private final void quantizeNorm(DenseVector norms) {
        boolean bl = this.qnorm;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = norms.length() == this.m;
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        DenseArrayMatrix data = BlasUtilsKt.floatArrayMatrix(this.m, 1, norms.data());
        this.npq.train(data);
        this.npq.compute_codes(data, this.normCodes);
    }

    @Override
    public float dotRow(@NotNull Vector vec, int i) {
        Intrinsics.checkParameterIsNotNull((Object)vec, (String)"vec");
        int n = i;
        n = 0 <= n && this.m > n && vec.length() == this.n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (n == 0) {
            boolean bl4 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        float norm = 1.0f;
        if (this.qnorm) {
            norm = this.npq.getCentroidTable().getCentroidData()[this.npq.get_centroids(0, this.normCodes[i])];
        }
        return this.pq.mulCode(vec, this.codes, i, norm);
    }

    @Override
    public void addVectorToRow(@NotNull Vector vector, int rows, float a) {
        Intrinsics.checkParameterIsNotNull((Object)vector, (String)"vector");
        String string = "Operation not permitted on quantized";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @Override
    public void addRowToVector(@NotNull Vector target, int i, @Nullable Double a) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        int norm = 1;
        if (this.qnorm) {
            norm = this.npq.get_centroids(0, this.normCodes[i]);
        }
        if (a == null) {
            this.pq.addCode(target, this.codes, i, norm);
        } else {
            this.pq.addCode(target, this.codes, i, (float)(a * (double)norm));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Object object = file;
        boolean bl = false;
        object = new FileOutputStream((File)object).getChannel();
        bl = false;
        Throwable throwable = null;
        try {
            FileChannel channel = (FileChannel)object;
            boolean bl2 = false;
            FileChannel fileChannel = channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileChannel, (String)"channel");
            this.save(fileChannel);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @Override
    public void save(@NotNull FileChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        boolean bl = false;
        boolean bl2 = false;
        FileChannel $this$with = channel;
        boolean bl3 = false;
        IOUtilsKt.writeBoolean($this$with, this.qnorm);
        IOUtilsKt.writeLong($this$with, this.m);
        IOUtilsKt.writeLong($this$with, this.n);
        IOUtilsKt.writeInt($this$with, this.codeSize);
        IOUtilsKt.writeShortArray($this$with, this.codes);
        this.pq.save(channel);
        if (this.qnorm) {
            IOUtilsKt.writeShortArray($this$with, this.normCodes);
            this.npq.save(channel);
        }
    }

    public final int getM() {
        return this.m;
    }

    public final int getN() {
        return this.n;
    }

    public final int getCodeSize() {
        return this.codeSize;
    }

    @NotNull
    public final ProductQuantizer getPq() {
        return this.pq;
    }

    @NotNull
    public final ProductQuantizer getNpq() {
        return this.npq;
    }

    @NotNull
    public final short[] getCodes() {
        return this.codes;
    }

    @NotNull
    public final short[] getNormCodes() {
        return this.normCodes;
    }

    public final boolean getQnorm() {
        return this.qnorm;
    }

    public QuantMatrix(int m, int n, int codeSize, @NotNull ProductQuantizer pq, @NotNull ProductQuantizer npq, @NotNull short[] codes, @NotNull short[] normCodes, boolean qnorm) {
        Intrinsics.checkParameterIsNotNull((Object)pq, (String)"pq");
        Intrinsics.checkParameterIsNotNull((Object)npq, (String)"npq");
        Intrinsics.checkParameterIsNotNull((Object)codes, (String)"codes");
        Intrinsics.checkParameterIsNotNull((Object)normCodes, (String)"normCodes");
        this.m = m;
        this.n = n;
        this.codeSize = codeSize;
        this.pq = pq;
        this.npq = npq;
        this.codes = codes;
        this.normCodes = normCodes;
        this.qnorm = qnorm;
        this.row = this.m;
        this.col = this.n;
    }

    public /* synthetic */ QuantMatrix(int n, int n2, int n3, ProductQuantizer productQuantizer, ProductQuantizer productQuantizer2, short[] sArray, short[] sArray2, boolean bl, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x80) != 0) {
            bl = false;
        }
        this(n, n2, n3, productQuantizer, productQuantizer2, sArray, sArray2, bl);
    }
}

