/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fasttext.blas;

import com.mayabot.nlp.fasttext.blas.DenseMatrix;
import com.mayabot.nlp.fasttext.blas.ProductQuantizer;
import com.mayabot.nlp.fasttext.blas.QuantMatrix;
import com.mayabot.nlp.fasttext.utils.AutoDataInput;
import com.mayabot.nlp.fasttext.utils.IOUtilsKt;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"buildQMatrix", "Lcom/mayabot/nlp/fasttext/blas/QuantMatrix;", "mat", "Lcom/mayabot/nlp/fasttext/blas/DenseMatrix;", "dsub", "", "qnorm", "", "loadQuantMatrix", "input", "Lcom/mayabot/nlp/fasttext/utils/AutoDataInput;", "file", "Ljava/io/File;", "fastText4j"})
public final class QuantMatrixKt {
    @NotNull
    public static final QuantMatrix buildQMatrix(@NotNull DenseMatrix mat, int dsub, boolean qnorm) {
        Intrinsics.checkParameterIsNotNull((Object)mat, (String)"mat");
        int m = mat.getRow();
        int n = mat.getCol();
        int codeSize = m * IOUtilsKt.pages(n, dsub);
        ProductQuantizer pq = new ProductQuantizer(n, dsub);
        short[] codes = new short[codeSize];
        ProductQuantizer npq = new ProductQuantizer(1, 1);
        short[] normCodes = qnorm ? new short[m] : new short[]{};
        QuantMatrix qm = new QuantMatrix(mat.getRow(), mat.getCol(), codeSize, pq, npq, codes, normCodes, qnorm);
        qm.quantize(mat);
        return qm;
    }

    public static /* synthetic */ QuantMatrix buildQMatrix$default(DenseMatrix denseMatrix, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return QuantMatrixKt.buildQMatrix(denseMatrix, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final QuantMatrix loadQuantMatrix(@NotNull File file) {
        QuantMatrix quantMatrix;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Closeable closeable = IOUtilsKt.openDataInputStream(file);
        boolean bl = false;
        Throwable throwable = null;
        try {
            DataInputStream it = (DataInputStream)closeable;
            boolean bl2 = false;
            quantMatrix = QuantMatrixKt.loadQuantMatrix(new AutoDataInput(it, null, 2, null));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return quantMatrix;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final QuantMatrix loadQuantMatrix(@NotNull AutoDataInput input) {
        void npq;
        Pair pair;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        boolean qnorm = input.readUnsignedByte() != 0;
        int m = (int)input.readLong();
        int n = (int)input.readLong();
        int codeSize = input.readInt();
        short[] codes = new short[codeSize];
        input.readShortArray(codes);
        ProductQuantizer pq = ProductQuantizer.Companion.loadFromBuffer(input);
        if (qnorm) {
            short[] normCodes = new short[m];
            input.readShortArray(normCodes);
            ProductQuantizer npq2 = ProductQuantizer.Companion.loadFromBuffer(input);
            pair = TuplesKt.to((Object)npq2, (Object)normCodes);
        } else {
            pair = TuplesKt.to((Object)new ProductQuantizer(1, 1), (Object)new short[0]);
        }
        Pair pair2 = pair;
        ProductQuantizer productQuantizer = (ProductQuantizer)pair2.component1();
        short[] normCodes = (short[])pair2.component2();
        return new QuantMatrix(m, n, codeSize, pq, (ProductQuantizer)npq, codes, normCodes, qnorm);
    }
}

