/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fasttext.dictionary;

import com.mayabot.nlp.fasttext.args.Args;
import com.mayabot.nlp.fasttext.dictionary.Dictionary;
import com.mayabot.nlp.fasttext.dictionary.DictionaryBuilder;
import com.mayabot.nlp.fasttext.train.SampleLine;
import com.mayabot.nlp.fasttext.utils.LogUtilsKt;
import java.util.Arrays;
import java.util.List;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u0007\u00a8\u0006\u000b"}, d2={"buildFromFile", "Lcom/mayabot/nlp/fasttext/dictionary/Dictionary;", "args", "Lcom/mayabot/nlp/fasttext/args/Args;", "sources", "", "", "Lcom/mayabot/nlp/fasttext/train/SampleLine;", "maxVocabSize", "", "initWordListSize", "fastText4j"})
public final class BuildDictFromSourceKt {
    /*
     * WARNING - void declaration
     */
    @ExperimentalUnsignedTypes
    @NotNull
    public static final Dictionary buildFromFile(@NotNull Args args, @NotNull List<? extends Iterable<SampleLine>> sources, int maxVocabSize, int initWordListSize) throws Exception {
        void thresholdCount;
        void lastMinThreshold;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull(sources, (String)"sources");
        DictionaryBuilder builder = new DictionaryBuilder(args.getLabel(), maxVocabSize, initWordListSize);
        double mmm = 0.75 * (double)maxVocabSize;
        Ref.LongRef longRef = new Ref.LongRef();
        longRef.element = 1L;
        LogUtilsKt.loggerln("Read file build dictionary ...");
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        Function0<Unit> $fun$thresholdBuilder$1 = new Function0<Unit>((Ref.LongRef)lastMinThreshold, (Ref.IntRef)thresholdCount, builder, mmm){
            final /* synthetic */ Ref.LongRef $lastMinThreshold;
            final /* synthetic */ Ref.IntRef $thresholdCount;
            final /* synthetic */ DictionaryBuilder $builder;
            final /* synthetic */ double $mmm;

            public final void invoke() {
                long minThreshold = this.$lastMinThreshold.element;
                int n = this.$thresholdCount.element;
                this.$thresholdCount.element = n + 1;
                while ((double)this.$builder.getSize() > this.$mmm * (double)0.75f) {
                    int before = this.$builder.getSize();
                    this.$builder.threshold(minThreshold, minThreshold);
                    this.$lastMinThreshold.element = minThreshold;
                    LogUtilsKt.loggerln("word size from " + before + " to " + this.$builder.getSize() + " , threshold min " + minThreshold);
                    long l = minThreshold;
                    minThreshold = l + 1L;
                }
            }
            {
                this.$lastMinThreshold = longRef;
                this.$thresholdCount = intRef;
                this.$builder = dictionaryBuilder;
                this.$mmm = d;
                super(0);
            }
        };
        for (Iterable<SampleLine> iterable : sources) {
            for (SampleLine sample : iterable) {
                Iterable $this$forEach$iv = sample.getWords();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String token = (String)element$iv;
                    boolean bl = false;
                    builder.add(token);
                    if (builder.getNtokens() % (long)1000000 == 0L) {
                        LogUtilsKt.logger("\rRead " + builder.getNtokens() / (long)1000000 + "M words");
                    }
                    if (!((double)builder.getSize() > mmm)) continue;
                    $fun$thresholdBuilder$1.invoke();
                }
                builder.add("</s>");
            }
        }
        builder.threshold(args.getMinCount(), args.getMinCountLabel());
        builder.getWordIdMap().collapseWordHash2Id();
        String string = "\rRead %dM words\n";
        Object[] objectArray = new Object[]{builder.getNtokens() / (long)1000000};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        LogUtilsKt.loggerln(string2);
        LogUtilsKt.loggerln("Number of words:  " + builder.getNwords());
        LogUtilsKt.loggerln("Number of labels: " + builder.getNlabels());
        if (thresholdCount.element > 0) {
            LogUtilsKt.loggerln("Max threshold count: " + lastMinThreshold.element);
        }
        if (builder.getWordIdMap().getSize() == 0) {
            throw (Throwable)new RuntimeException("Empty vocabulary. Try a smaller -minCount second.");
        }
        Dictionary dictionary = builder.toDictionary(args);
        LogUtilsKt.loggerln("Number of wordHash2Id: " + dictionary.getOnehotMap().getWordHash2WordId().length);
        return dictionary;
    }

    public static /* synthetic */ Dictionary buildFromFile$default(Args args, List list, int n, int n2, int n3, Object object) throws Exception {
        if ((n3 & 4) != 0) {
            n = 500000;
        }
        if ((n3 & 8) != 0) {
            n2 = 5000;
        }
        return BuildDictFromSourceKt.buildFromFile(args, list, n, n2);
    }
}

