/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fasttext.dictionary;

import com.mayabot.nlp.fasttext.args.Args;
import com.mayabot.nlp.fasttext.args.ModelName;
import com.mayabot.nlp.fasttext.dictionary.DictUtilsKt;
import com.mayabot.nlp.fasttext.dictionary.Entry;
import com.mayabot.nlp.fasttext.dictionary.EntryType;
import com.mayabot.nlp.fasttext.dictionary.FastWordMap;
import com.mayabot.nlp.fasttext.utils.AutoDataInput;
import com.mayabot.nlp.fasttext.utils.IOUtilsKt;
import com.mayabot.nlp.fasttext.utils.IntArrayList;
import com.mayabot.nlp.fasttext.utils.LogUtilsKt;
import com.mayabot.nlp.fasttext.utils.LongArrayList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.UnsignedKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \\2\u00020\u0001:\u0001\\B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ \u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\tH\u0002J \u0010.\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\tH\u0002J\u0018\u00102\u001a\u00020(2\u0006\u00103\u001a\u00020,2\u0006\u00104\u001a\u00020*H\u0002J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\t2\u0006\u00108\u001a\u000209H\u0002J\u0011\u0010:\u001a\u00020\t2\u0006\u00103\u001a\u00020,H\u0086\u0002J\u000e\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>J\u000e\u0010?\u001a\u00020,2\u0006\u0010@\u001a\u00020\tJ$\u0010A\u001a\u00020\t2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020,0C2\u0006\u0010D\u001a\u00020*2\u0006\u0010E\u001a\u00020*J$\u0010A\u001a\u00020\t2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020,0F2\u0006\u0010D\u001a\u00020*2\u0006\u0010G\u001a\u00020HJ\u000e\u0010I\u001a\u00020*2\u0006\u00107\u001a\u00020\tJ\u000e\u0010I\u001a\u00020*2\u0006\u00103\u001a\u00020,J$\u0010I\u001a\u00020(2\u0006\u00103\u001a\u00020,2\u0006\u00104\u001a\u00020*2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020,0KJ\u000e\u0010L\u001a\u00020,2\u0006\u0010-\u001a\u00020\tJ\u000e\u0010M\u001a\u00020N2\u0006\u0010-\u001a\u00020\tJ\u000e\u0010O\u001a\u00020\t2\u0006\u00103\u001a\u00020,J\u0006\u0010P\u001a\u00020(J\u0006\u0010Q\u001a\u00020(J\u0006\u0010R\u001a\u00020(J\u0006\u0010S\u001a\u000206J\u0010\u0010T\u001a\u0002062\u0006\u0010U\u001a\u00020VH\u0002J\u0018\u0010W\u001a\u00020(2\u0006\u0010/\u001a\u00020*2\u0006\u0010X\u001a\u00020\tH\u0002J\u000e\u0010Y\u001a\u00020(2\u0006\u0010Z\u001a\u00020[R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001d\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001ej\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0017\"\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0015R\u000e\u0010&\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006]"}, d2={"Lcom/mayabot/nlp/fasttext/dictionary/Dictionary;", "", "args", "Lcom/mayabot/nlp/fasttext/args/Args;", "onehotMap", "Lcom/mayabot/nlp/fasttext/dictionary/FastWordMap;", "ntokens", "", "nwords", "", "nlabels", "(Lcom/mayabot/nlp/fasttext/args/Args;Lcom/mayabot/nlp/fasttext/dictionary/FastWordMap;JII)V", "getArgs", "()Lcom/mayabot/nlp/fasttext/args/Args;", "bucket", "bucketULong", "Lkotlin/ULong;", "J", "maxn", "minn", "getNlabels", "()I", "getNtokens", "()J", "getNwords", "getOnehotMap", "()Lcom/mayabot/nlp/fasttext/dictionary/FastWordMap;", "pdiscard", "", "pruneidx", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "pruneidxSize", "getPruneidxSize", "setPruneidxSize", "(J)V", "size", "getSize", "wordNgrams", "addSubwords", "", "line", "Lcom/mayabot/nlp/fasttext/utils/IntArrayList;", "token", "", "wid", "addWordNgrams", "hashes", "Lcom/mayabot/nlp/fasttext/utils/LongArrayList;", "n", "computeSubwords", "word", "ngrams", "discard", "", "id", "rand", "", "get", "getCounts", "", "type", "Lcom/mayabot/nlp/fasttext/dictionary/EntryType;", "getLabel", "lid", "getLine", "tokens", "", "words", "labels", "", "rng", "Lkotlin/random/Random;", "getSubwords", "substrings", "", "getWord", "getWordEntity", "Lcom/mayabot/nlp/fasttext/dictionary/Entry;", "getWordId", "init", "initNgrams", "initTableDiscard", "isPruned", "isWhiteSpaceChar", "ch", "", "pushHash", "id_", "save", "channel", "Ljava/nio/channels/FileChannel;", "Companion", "fastText4j"})
@ExperimentalUnsignedTypes
public final class Dictionary {
    private float[] pdiscard;
    private long pruneidxSize;
    private final HashMap<Integer, Integer> pruneidx;
    private final int maxn;
    private final int minn;
    private final int bucket;
    private final long bucketULong;
    private final int wordNgrams;
    @NotNull
    private final Args args;
    @NotNull
    private final FastWordMap onehotMap;
    private final long ntokens;
    private final int nwords;
    private final int nlabels;
    public static final Companion Companion = new Companion(null);

    public final long getPruneidxSize() {
        return this.pruneidxSize;
    }

    public final void setPruneidxSize(long l) {
        this.pruneidxSize = l;
    }

    public final int getSize() {
        return this.onehotMap.getSize();
    }

    public final boolean isPruned() {
        return this.pruneidxSize >= 0L;
    }

    private final boolean isWhiteSpaceChar(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final long[] getCounts(@NotNull EntryType type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        long[] counts = EntryType.label == type ? new long[this.nlabels] : new long[this.nwords];
        int i = 0;
        for (Entry entry : this.onehotMap.getWordList()) {
            void count;
            long l = entry.component2();
            EntryType type1 = entry.component3();
            if (type1 != type) continue;
            counts[i++] = count;
        }
        return counts;
    }

    public final int getLine(@NotNull Iterable<String> tokens, @NotNull IntArrayList words, @NotNull IntArrayList labels) {
        Intrinsics.checkParameterIsNotNull(tokens, (String)"tokens");
        Intrinsics.checkParameterIsNotNull((Object)words, (String)"words");
        Intrinsics.checkParameterIsNotNull((Object)labels, (String)"labels");
        LongArrayList word_hashes = new LongArrayList(0, null, 3, null);
        int ntokens = 0;
        words.clear();
        labels.clear();
        for (String token : tokens) {
            int h;
            int wid = this.onehotMap.getId-Q46RfKk(token, h = DictUtilsKt.fnv1aHash(token));
            EntryType type = wid < 0 ? this.onehotMap.getType(token) : this.onehotMap.getType(wid);
            ++ntokens;
            if (type == EntryType.word) {
                this.addSubwords(words, token, wid);
                int n = h;
                LongArrayList longArrayList = word_hashes;
                boolean bl = false;
                long l = (long)n & 0xFFFFFFFFL;
                longArrayList.add(l);
                continue;
            }
            if (type != EntryType.label || wid < 0) continue;
            labels.add(wid - this.nwords);
        }
        this.addWordNgrams(words, word_hashes, this.wordNgrams);
        return ntokens;
    }

    public final int getLine(@NotNull List<String> tokens, @NotNull IntArrayList words, @NotNull Random rng) {
        Intrinsics.checkParameterIsNotNull(tokens, (String)"tokens");
        Intrinsics.checkParameterIsNotNull((Object)words, (String)"words");
        Intrinsics.checkParameterIsNotNull((Object)rng, (String)"rng");
        int ntokens = 0;
        words.clear();
        for (String token : tokens) {
            int h = this.onehotMap.find(token);
            int wid = this.onehotMap.getWordHash2WordId()[h];
            if (wid < 0) continue;
            ++ntokens;
            if (this.onehotMap.getType(wid) == EntryType.word && !this.discard(wid, rng.nextFloat())) {
                words.add(wid);
            }
            if (ntokens <= 1024 && !Intrinsics.areEqual((Object)token, (Object)"</s>")) continue;
            break;
        }
        return ntokens;
    }

    /*
     * WARNING - void declaration
     */
    private final void addWordNgrams(IntArrayList line, LongArrayList hashes, int n) {
        int hashSize = hashes.size();
        int n2 = 0;
        int n3 = hashSize;
        while (n2 < n3) {
            void i;
            long l = hashes.get((int)i);
            int n4 = 0;
            long h = ULong.constructor-impl((long)l);
            void var9_8 = i + true;
            n4 = i + n;
            boolean bl = false;
            int n5 = Math.min(hashSize, n4);
            while (var9_8 < n5) {
                long l2;
                void j;
                long l3 = h;
                long l4 = 116049371L;
                boolean bl2 = false;
                l3 = ULong.constructor-impl((long)(l3 * l4));
                l4 = hashes.get((int)j);
                bl2 = false;
                l4 = ULong.constructor-impl((long)l4);
                bl2 = false;
                l3 = h = ULong.constructor-impl((long)(l3 + l4));
                l4 = this.bucketULong;
                IntArrayList intArrayList = line;
                Dictionary dictionary = this;
                bl2 = false;
                l3 = l2 = UnsignedKt.ulongRemainder-eb3DHEI((long)l3, (long)l4);
                boolean bl3 = false;
                int n6 = (int)l3;
                dictionary.pushHash(intArrayList, n6);
                ++j;
            }
            ++i;
        }
    }

    private final void addSubwords(IntArrayList line, String token, int wid) {
        if (wid < 0) {
            if (Intrinsics.areEqual((Object)"</s>", (Object)token) ^ true) {
                this.computeSubwords("<" + token + ">", line);
            }
        } else if (this.maxn <= 0) {
            line.add(wid);
        } else {
            IntArrayList ngrams = this.getSubwords(wid);
            line.addAll(ngrams);
        }
    }

    @NotNull
    public final IntArrayList getSubwords(int id) {
        boolean bl = id >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = id < this.nwords;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.onehotMap.get(id).getSubwords();
    }

    @NotNull
    public final IntArrayList getSubwords(@NotNull String word) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        int i = this.onehotMap.getId(word);
        if (i >= 0) {
            return this.onehotMap.get(i).getSubwords();
        }
        IntArrayList ngrams = new IntArrayList(0, null, 3, null);
        if (Intrinsics.areEqual((Object)word, (Object)"</s>") ^ true) {
            this.computeSubwords("<" + word + ">", ngrams);
        }
        return ngrams;
    }

    public final void getSubwords(@NotNull String word, @NotNull IntArrayList ngrams, @NotNull List<String> substrings) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        Intrinsics.checkParameterIsNotNull((Object)ngrams, (String)"ngrams");
        Intrinsics.checkParameterIsNotNull(substrings, (String)"substrings");
        int i = this.onehotMap.getId(word);
        ngrams.clear();
        substrings.clear();
        if (i >= 0) {
            ngrams.add(i);
            substrings.add(this.onehotMap.get(i).getWord());
        } else {
            ngrams.add(-1);
            substrings.add(word);
        }
        if (Intrinsics.areEqual((Object)word, (Object)"</s>") ^ true) {
            this.computeSubwords("<" + word + ">", ngrams);
        }
    }

    private final boolean discard(int id, float rand) {
        boolean bl = id >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = id < this.nwords;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.args.getModel() == ModelName.sup ? false : rand > this.pdiscard[id];
    }

    @NotNull
    public final String getLabel(int lid) {
        boolean bl = lid >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = lid < this.nlabels;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.onehotMap.get(lid + this.nwords).getWord();
    }

    public final int get(@NotNull String word) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        return this.onehotMap.getId(word);
    }

    public final int getWordId(@NotNull String word) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        return this.onehotMap.getId(word);
    }

    public final void init() {
        this.initTableDiscard();
        this.initNgrams();
    }

    /*
     * WARNING - void declaration
     */
    public final void initTableDiscard() {
        float[] pdiscard = new float[this.onehotMap.getSize()];
        double t = this.args.getT();
        ArrayList<Entry> wordList2 = this.onehotMap.getWordList();
        int n = 0;
        int n2 = this.onehotMap.getSize();
        while (n < n2) {
            void i;
            float f = (float)wordList2.get((int)i).getCount() * 1.0f / (float)this.ntokens;
            double d = t / (double)f;
            void var12_10 = i++;
            float[] fArray = pdiscard;
            boolean bl = false;
            double d2 = Math.sqrt(d);
            fArray[var12_10] = (float)(d2 + t / (double)f);
        }
        this.pdiscard = pdiscard;
    }

    /*
     * WARNING - void declaration
     */
    public final void initNgrams() {
        ArrayList<Entry> wordList2 = this.onehotMap.getWordList();
        int n = 0;
        int n2 = this.onehotMap.getSize();
        while (n < n2) {
            Entry e;
            void id;
            Intrinsics.checkExpressionValueIsNotNull((Object)wordList2.get((int)id), (String)"wordList[id]");
            String word = "<" + e.getWord() + ">";
            if (this.maxn == 0) {
                e.setSubwords(IntArrayList.Companion.from(new int[]{id}));
            } else {
                e.setSubwords(new IntArrayList(1, null, 2, null));
                e.getSubwords().add((int)id);
                if (Intrinsics.areEqual((Object)e.getWord(), (Object)"</s>") ^ true) {
                    this.computeSubwords(word, e.getSubwords());
                }
            }
            ++id;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void computeSubwords(String word, IntArrayList ngrams) {
        int word_len = word.length();
        int n = 0;
        int n2 = word_len;
        while (n < n2) {
            void i;
            if (!this.isWhiteSpaceChar(word.charAt((int)i))) {
                StringBuilder ngram = null;
                void j = i;
                for (int n3 = 1; j < word_len && n3 <= this.maxn; ++n3) {
                    if (ngram == null) {
                        ngram = new StringBuilder();
                    }
                    ngram.append(word.charAt((int)j++));
                    while (j < word.length() && this.isWhiteSpaceChar(word.charAt((int)j))) {
                        ngram.append(word.charAt((int)j++));
                    }
                    if (n3 < this.minn || n3 == 1 && (i == false || j == word.length())) continue;
                    String string = ngram.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ngram.toString()");
                    int n4 = DictUtilsKt.fnv1aHash(string);
                    boolean bl = false;
                    int h = (int)(((long)n4 & 0xFFFFFFFFL) % (long)this.bucket);
                    if (h < 0) {
                        LogUtilsKt.loggerln("computeSubwords h<0: " + h + " on word: " + word);
                    }
                    this.pushHash(ngrams, h);
                }
            }
            ++i;
        }
    }

    private final void pushHash(IntArrayList hashes, int id_) {
        int id = id_;
        if (this.pruneidxSize == 0L || id < 0) {
            return;
        }
        if (this.pruneidxSize > 0L) {
            if (this.pruneidx.containsKey(id)) {
                id = ((Number)MapsKt.getValue((Map)this.pruneidx, (Object)id)).intValue();
            } else {
                return;
            }
        }
        hashes.add(this.nwords + id);
    }

    public final void save(@NotNull FileChannel channel) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        IOUtilsKt.writeInt(channel, this.getSize());
        IOUtilsKt.writeInt(channel, this.nwords);
        IOUtilsKt.writeInt(channel, this.nlabels);
        IOUtilsKt.writeLong(channel, this.ntokens);
        IOUtilsKt.writeLong(channel, this.pruneidxSize);
        ByteBuffer buffer = ByteBuffer.allocate(0x100000);
        float em = (float)buffer.capacity() * 0.25f;
        ArrayList<Entry> wordList2 = this.onehotMap.getWordList();
        for (Entry entry : wordList2) {
            ByteBuffer byteBuffer = buffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
            IOUtilsKt.writeUTF(byteBuffer, entry.getWord());
            buffer.putLong(entry.getCount());
            buffer.put((byte)entry.getType().getValue());
            if (!((float)buffer.remaining() < em)) continue;
            buffer.flip();
            while (buffer.hasRemaining()) {
                channel.write(buffer);
            }
            buffer.clear();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            channel.write(buffer);
        }
        ByteBuffer buffer2 = ByteBuffer.allocate(this.pruneidx.size() * 4);
        Map $this$forEach$iv = this.pruneidx;
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl2 = false;
            buffer2.putInt(((Number)it.getKey()).intValue(), ((Number)it.getValue()).intValue());
        }
        buffer2.flip();
        channel.write(buffer2);
    }

    @NotNull
    public final String getWord(int wid) {
        return this.onehotMap.getWord(wid);
    }

    @NotNull
    public final Entry getWordEntity(int wid) {
        return this.onehotMap.get(wid);
    }

    @NotNull
    public final Args getArgs() {
        return this.args;
    }

    @NotNull
    public final FastWordMap getOnehotMap() {
        return this.onehotMap;
    }

    public final long getNtokens() {
        return this.ntokens;
    }

    public final int getNwords() {
        return this.nwords;
    }

    public final int getNlabels() {
        return this.nlabels;
    }

    public Dictionary(@NotNull Args args, @NotNull FastWordMap onehotMap, long ntokens, int nwords, int nlabels) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)onehotMap, (String)"onehotMap");
        this.args = args;
        this.onehotMap = onehotMap;
        this.ntokens = ntokens;
        this.nwords = nwords;
        this.nlabels = nlabels;
        this.pdiscard = new float[0];
        this.pruneidxSize = -1L;
        this.pruneidx = new HashMap();
        this.maxn = this.args.getMaxn();
        this.minn = this.args.getMinn();
        int n = this.bucket = this.args.getBucket();
        Dictionary dictionary = this;
        boolean bl = false;
        dictionary.bucketULong = l = ULong.constructor-impl((long)n);
        this.wordNgrams = this.args.getWordNgrams();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/mayabot/nlp/fasttext/dictionary/Dictionary$Companion;", "", "()V", "loadModel", "Lcom/mayabot/nlp/fasttext/dictionary/Dictionary;", "args", "Lcom/mayabot/nlp/fasttext/args/Args;", "buffer", "Lcom/mayabot/nlp/fasttext/utils/AutoDataInput;", "fastText4j"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Dictionary loadModel(@NotNull Args args, @NotNull AutoDataInput buffer) throws IOException {
            int[] nArray;
            int first;
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            int size = buffer.readInt();
            int nwords = buffer.readInt();
            int nlabels = buffer.readInt();
            long ntokens = buffer.readLong();
            long pruneidxSize = buffer.readLong();
            ArrayList<Entry> wordList2 = new ArrayList<Entry>(size);
            int n = 0;
            int n2 = size;
            while (n < n2) {
                void i;
                Entry e = new Entry(buffer.readUTF(), buffer.readLong(), EntryType.Companion.fromValue(buffer.readUnsignedByte()));
                wordList2.add(e);
                ++i;
            }
            HashMap<Integer, Integer> pruneidx = new HashMap<Integer, Integer>();
            long l = 0L;
            long l2 = pruneidxSize;
            while (l < l2) {
                void i;
                first = buffer.readInt();
                int second = buffer.readInt();
                pruneidx.put(first, second);
                ++i;
            }
            int n3 = (int)((double)size / 0.75);
            Args args2 = args;
            int[] nArray2 = new int[n3];
            int n4 = 0;
            while (n4 < n3) {
                int n5;
                first = n4;
                int n6 = n4++;
                nArray = nArray2;
                boolean bl = false;
                nArray[n6] = n5 = -1;
            }
            nArray = nArray2;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n7 = 4;
            String string = null;
            ArrayList<Entry> arrayList = wordList2;
            int[] nArray3 = nArray;
            int n8 = nlabels;
            int n9 = nwords;
            long l3 = ntokens;
            FastWordMap fastWordMap = new FastWordMap(nArray3, arrayList, string, n7, defaultConstructorMarker);
            Args args3 = args2;
            Dictionary dict = new Dictionary(args3, fastWordMap, l3, n9, n8);
            dict.initTableDiscard();
            dict.initNgrams();
            dict.getOnehotMap().initWordHash2WordId();
            return dict;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

