/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fasttext.dictionary;

import com.mayabot.nlp.fasttext.args.Args;
import com.mayabot.nlp.fasttext.dictionary.Dictionary;
import com.mayabot.nlp.fasttext.dictionary.DictionaryBuilder;
import com.mayabot.nlp.fasttext.dictionary.Entry;
import com.mayabot.nlp.fasttext.dictionary.EntryType;
import com.mayabot.nlp.fasttext.dictionary.FastWordMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003J\u0016\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000eJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\fR\u0011\u0010\u0016\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\nR\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006&"}, d2={"Lcom/mayabot/nlp/fasttext/dictionary/DictionaryBuilder;", "", "label", "", "vocabSize", "", "initWordListSize", "(Ljava/lang/String;ILjava/lang/Integer;)V", "nlabels", "getNlabels", "()I", "setNlabels", "(I)V", "ntokens", "", "getNtokens", "()J", "setNtokens", "(J)V", "nwords", "getNwords", "setNwords", "size", "getSize", "wordIdMap", "Lcom/mayabot/nlp/fasttext/dictionary/FastWordMap;", "getWordIdMap", "()Lcom/mayabot/nlp/fasttext/dictionary/FastWordMap;", "add", "", "word", "threshold", "t", "minLabelCount", "toDictionary", "Lcom/mayabot/nlp/fasttext/dictionary/Dictionary;", "args", "Lcom/mayabot/nlp/fasttext/args/Args;", "fastText4j"})
@ExperimentalUnsignedTypes
public final class DictionaryBuilder {
    @NotNull
    private final FastWordMap wordIdMap;
    private long ntokens;
    private int nwords;
    private int nlabels;

    @NotNull
    public final FastWordMap getWordIdMap() {
        return this.wordIdMap;
    }

    public final long getNtokens() {
        return this.ntokens;
    }

    public final void setNtokens(long l) {
        this.ntokens = l;
    }

    public final int getNwords() {
        return this.nwords;
    }

    public final void setNwords(int n) {
        this.nwords = n;
    }

    public final int getNlabels() {
        return this.nlabels;
    }

    public final void setNlabels(int n) {
        this.nlabels = n;
    }

    @NotNull
    public final Dictionary toDictionary(@NotNull Args args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        return new Dictionary(args, this.wordIdMap, this.ntokens, this.nwords, this.nlabels);
    }

    public final int getSize() {
        return this.wordIdMap.getSize();
    }

    public final void add(@NotNull String word) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        this.wordIdMap.add(word);
        long l = this.ntokens;
        this.ntokens = l + 1L;
    }

    /*
     * WARNING - void declaration
     */
    public final void threshold(long t, long minLabelCount) {
        List wordList2;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = this.wordIdMap.getWordList();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Entry it = (Entry)element$iv$iv;
            boolean bl = false;
            if (it.getType() == EntryType.word && it.getCount() < t || it.getType() == EntryType.label && it.getCount() < minLabelCount) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = wordList2 = CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)threshold.wordList.2.INSTANCE));
        if (list == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.ArrayList<com.mayabot.nlp.fasttext.dictionary.Entry>");
        }
        ((ArrayList)list).trimToSize();
        this.nwords = 0;
        this.nlabels = 0;
        this.wordIdMap.getWordList().clear();
        this.wordIdMap.getWordList().addAll(wordList2);
        int[] word_hash_2_id = this.wordIdMap.getWordHash2WordId();
        ArraysKt.fill$default((int[])word_hash_2_id, (int)-1, (int)0, (int)0, (int)6, null);
        $i$f$filterNot = false;
        for (Entry entry : (Iterable)wordList2) {
            void index;
            int h = this.wordIdMap.find(entry.getWord());
            word_hash_2_id[h] = index;
            if (entry.getType() == EntryType.word) {
                int n = this.nwords;
                this.nwords = n + 1;
            } else if (entry.getType() == EntryType.label) {
                int n = this.nlabels;
                this.nlabels = n + 1;
            }
            ++index;
        }
    }

    public DictionaryBuilder(@NotNull String label, int vocabSize, @Nullable Integer initWordListSize) {
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        this.wordIdMap = new FastWordMap(label, vocabSize, initWordListSize);
    }

    public /* synthetic */ DictionaryBuilder(String string, int n, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 30000000;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        this(string, n, n2);
    }
}

