/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fasttext.dictionary;

import com.mayabot.nlp.fasttext.dictionary.DictUtilsKt;
import com.mayabot.nlp.fasttext.dictionary.Entry;
import com.mayabot.nlp.fasttext.dictionary.EntryType;
import java.util.ArrayList;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007B/\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003J\u0006\u0010\u001d\u001a\u00020\u001bJ\u000e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0003J \u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 \u00f8\u0001\u0000\u00a2\u0006\u0004\b!\u0010\"J\u0011\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u0005H\u0086\u0002J\u000e\u0010%\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0003J \u0010%\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010&\u001a\u00020 \u00f8\u0001\u0000\u00a2\u0006\u0004\b'\u0010\"J\u000e\u0010(\u001a\u00020)2\u0006\u0010$\u001a\u00020\u0005J\u000e\u0010(\u001a\u00020)2\u0006\u0010\u001c\u001a\u00020\u0003J\u000e\u0010*\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0005J\u0006\u0010+\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R!\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006,"}, d2={"Lcom/mayabot/nlp/fasttext/dictionary/FastWordMap;", "", "label", "", "vocabSize", "", "initWordListSize", "(Ljava/lang/String;ILjava/lang/Integer;)V", "wordHash2WordId", "", "wordList", "Ljava/util/ArrayList;", "Lcom/mayabot/nlp/fasttext/dictionary/Entry;", "Lkotlin/collections/ArrayList;", "([ILjava/util/ArrayList;Ljava/lang/String;)V", "getLabel", "()Ljava/lang/String;", "size", "getSize", "()I", "getWordHash2WordId", "()[I", "setWordHash2WordId", "([I)V", "getWordList", "()Ljava/util/ArrayList;", "add", "", "w", "collapseWordHash2Id", "find", "hash", "Lkotlin/UInt;", "find-Q46RfKk", "(Ljava/lang/String;I)I", "get", "id", "getId", "h", "getId-Q46RfKk", "getType", "Lcom/mayabot/nlp/fasttext/dictionary/EntryType;", "getWord", "initWordHash2WordId", "fastText4j"})
@ExperimentalUnsignedTypes
public final class FastWordMap {
    @NotNull
    private int[] wordHash2WordId;
    @NotNull
    private final ArrayList<Entry> wordList;
    @NotNull
    private final String label;

    public final int getSize() {
        return this.wordList.size();
    }

    @NotNull
    public final Entry get(int id) {
        Entry entry = this.wordList.get(id);
        Intrinsics.checkExpressionValueIsNotNull((Object)entry, (String)"wordList[id]");
        return entry;
    }

    public final void add(@NotNull String w) {
        Intrinsics.checkParameterIsNotNull((Object)w, (String)"w");
        int h = this.find(w);
        int id = this.wordHash2WordId[h];
        if (id == -1) {
            this.wordHash2WordId[h] = this.wordList.size();
            this.wordList.add(new Entry(w, 1L, this.getType(w)));
        } else {
            Entry entry = this.wordList.get(id);
            long l = entry.getCount();
            entry.setCount(l + 1L);
        }
    }

    @NotNull
    public final String getWord(int id) {
        return this.wordList.get(id).getWord();
    }

    @NotNull
    public final EntryType getType(int id) {
        return this.wordList.get(id).getType();
    }

    @NotNull
    public final EntryType getType(@NotNull String w) {
        Intrinsics.checkParameterIsNotNull((Object)w, (String)"w");
        return StringsKt.startsWith$default((String)w, (String)this.label, (boolean)false, (int)2, null) ? EntryType.label : EntryType.word;
    }

    public final int getId(@NotNull String w) {
        Intrinsics.checkParameterIsNotNull((Object)w, (String)"w");
        int id = this.find(w);
        return id == -1 ? -1 : this.wordHash2WordId[id];
    }

    public final int getId-Q46RfKk(@NotNull String w, int h) {
        Intrinsics.checkParameterIsNotNull((Object)w, (String)"w");
        int id = this.find-Q46RfKk(w, h);
        return id == -1 ? -1 : this.wordHash2WordId[id];
    }

    public final int find(@NotNull String w) {
        Intrinsics.checkParameterIsNotNull((Object)w, (String)"w");
        return this.find-Q46RfKk(w, DictUtilsKt.fnv1aHash(w));
    }

    public final int find-Q46RfKk(@NotNull String w, int hash) {
        Intrinsics.checkParameterIsNotNull((Object)w, (String)"w");
        int word2intSize = this.wordHash2WordId.length;
        int n = hash;
        boolean bl = false;
        int id = (int)(((long)n & 0xFFFFFFFFL) % (long)word2intSize);
        while (this.wordHash2WordId[id] != -1 && Intrinsics.areEqual((Object)this.wordList.get(this.wordHash2WordId[id]).getWord(), (Object)w) ^ true) {
            id = (id + 1) % word2intSize;
        }
        return id;
    }

    /*
     * WARNING - void declaration
     */
    public final void initWordHash2WordId() {
        int n = 0;
        int n2 = this.getSize();
        while (n < n2) {
            void i;
            this.wordHash2WordId[this.find((String)this.wordList.get((int)i).getWord())] = i;
            ++i;
        }
    }

    public final void collapseWordHash2Id() {
        int[] nArray;
        int n = (int)((double)this.getSize() / 0.75);
        FastWordMap fastWordMap = this;
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n2;
            int n5 = n2++;
            nArray = nArray2;
            boolean bl = false;
            nArray[n5] = n3 = -1;
        }
        nArray = nArray2;
        fastWordMap.wordHash2WordId = nArray;
        this.initWordHash2WordId();
    }

    @NotNull
    public final int[] getWordHash2WordId() {
        return this.wordHash2WordId;
    }

    public final void setWordHash2WordId(@NotNull int[] nArray) {
        Intrinsics.checkParameterIsNotNull((Object)nArray, (String)"<set-?>");
        this.wordHash2WordId = nArray;
    }

    @NotNull
    public final ArrayList<Entry> getWordList() {
        return this.wordList;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public FastWordMap(@NotNull int[] wordHash2WordId, @NotNull ArrayList<Entry> wordList2, @NotNull String label) {
        Intrinsics.checkParameterIsNotNull((Object)wordHash2WordId, (String)"wordHash2WordId");
        Intrinsics.checkParameterIsNotNull(wordList2, (String)"wordList");
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        this.wordHash2WordId = wordHash2WordId;
        this.wordList = wordList2;
        this.label = label;
    }

    public /* synthetic */ FastWordMap(int[] nArray, ArrayList arrayList, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = "__label__";
        }
        this(nArray, arrayList, string);
    }

    public FastWordMap(@NotNull String label, int vocabSize, @Nullable Integer initWordListSize) {
        int[] nArray;
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        FastWordMap fastWordMap = this;
        int[] nArray2 = new int[vocabSize];
        int n = 0;
        while (n < vocabSize) {
            int n2;
            int n3 = n;
            int n4 = n++;
            nArray = nArray2;
            boolean bl = false;
            nArray[n4] = n2 = -1;
        }
        nArray = nArray2;
        Integer n5 = initWordListSize;
        fastWordMap(nArray, new ArrayList<Entry>(n5 != null ? n5 : Integer.max(1000, Integer.min(10000, vocabSize / 1000))), label);
    }
}

