/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fasttext.loss;

import com.mayabot.nlp.fasttext.Model;
import com.mayabot.nlp.fasttext.blas.DenseVector;
import com.mayabot.nlp.fasttext.blas.Matrix;
import com.mayabot.nlp.fasttext.loss.Loss;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/mayabot/nlp/fasttext/loss/BinaryLogisticLoss;", "Lcom/mayabot/nlp/fasttext/loss/Loss;", "wo", "Lcom/mayabot/nlp/fasttext/blas/Matrix;", "(Lcom/mayabot/nlp/fasttext/blas/Matrix;)V", "binaryLogistic", "", "target", "", "state", "Lcom/mayabot/nlp/fasttext/Model$State;", "labelIsPositive", "", "lr", "backprop", "computeOutput", "", "fastText4j"})
public abstract class BinaryLogisticLoss
extends Loss {
    public final float binaryLogistic(int target, @NotNull Model.State state, boolean labelIsPositive, float lr, boolean backprop) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        float score = Loss.Companion.sigmoid(this.getWo().dotRow(state.getHidden(), target));
        if (backprop) {
            float alpha = lr * ((labelIsPositive ? 1.0f : 0.0f) - score);
            state.getGrad().addRow(this.getWo(), target, alpha);
            this.getWo().addVectorToRow(state.getHidden(), target, alpha);
        }
        if (labelIsPositive) {
            return -Loss.Companion.log(score);
        }
        return -Loss.Companion.log(1.0f - score);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void computeOutput(@NotNull Model.State state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        DenseVector output = state.getOutput();
        output.mul(this.getWo(), state.getHidden());
        int osz = output.length();
        int n = 0;
        int n2 = osz;
        while (n < n2) {
            void i;
            output.set((int)i, Loss.Companion.sigmoid(output.get((int)i)));
            ++i;
        }
    }

    public BinaryLogisticLoss(@NotNull Matrix wo) {
        Intrinsics.checkParameterIsNotNull((Object)wo, (String)"wo");
        super(wo);
    }
}

