/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fasttext.loss;

import com.mayabot.nlp.fasttext.Model;
import com.mayabot.nlp.fasttext.ScoreIdPair;
import com.mayabot.nlp.fasttext.blas.DenseVector;
import com.mayabot.nlp.fasttext.blas.Matrix;
import com.mayabot.nlp.fasttext.loss.LossKt;
import com.mayabot.nlp.fasttext.utils.IntArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J.\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J0\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH&J2\u0010\u001c\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\u00120\u0011j\u0002`\u001d2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lcom/mayabot/nlp/fasttext/loss/Loss;", "", "wo", "Lcom/mayabot/nlp/fasttext/blas/Matrix;", "(Lcom/mayabot/nlp/fasttext/blas/Matrix;)V", "getWo", "()Lcom/mayabot/nlp/fasttext/blas/Matrix;", "computeOutput", "", "state", "Lcom/mayabot/nlp/fasttext/Model$State;", "findKBest", "k", "", "threshold", "", "heap", "", "Lcom/mayabot/nlp/fasttext/ScoreIdPair;", "output", "Lcom/mayabot/nlp/fasttext/blas/DenseVector;", "forward", "targets", "Lcom/mayabot/nlp/fasttext/utils/IntArrayList;", "targetIndex", "lr", "backprop", "", "predict", "Lcom/mayabot/nlp/fasttext/Predictions;", "Companion", "fastText4j"})
public abstract class Loss {
    @NotNull
    private final Matrix wo;
    private static final float[] tSigmoid;
    private static final float[] tLog;
    public static final Companion Companion;

    public void predict(int k, float threshold2, @NotNull List<ScoreIdPair> heap, @NotNull Model.State state) {
        Intrinsics.checkParameterIsNotNull(heap, (String)"heap");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        this.computeOutput(state);
        this.findKBest(k, threshold2, heap, state.getOutput());
        List<ScoreIdPair> $this$sortByDescending$iv = heap;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            List<ScoreIdPair> list = $this$sortByDescending$iv;
            boolean bl = false;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    ScoreIdPair it = (ScoreIdPair)b;
                    boolean bl2 = false;
                    Comparable comparable = Float.valueOf(it.getScore());
                    it = (ScoreIdPair)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Float f = Float.valueOf(it.getScore());
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)f);
                }
            };
            CollectionsKt.sortWith(list, (Comparator)comparator);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void findKBest(int k, float threshold2, List<ScoreIdPair> heap, DenseVector output) {
        int n = 0;
        int n2 = output.length();
        while (n < n2) {
            void i;
            if (!(output.get((int)i) < threshold2 || heap.size() == k && LossKt.stdLog(output.get((int)i)) < (double)((ScoreIdPair)CollectionsKt.first(heap)).getScore())) {
                Comparator comparator;
                boolean bl;
                Collection collection = heap;
                ScoreIdPair scoreIdPair = new ScoreIdPair((float)LossKt.stdLog(output.get((int)i)), (int)i);
                boolean bl2 = false;
                collection.add(scoreIdPair);
                List<ScoreIdPair> $this$sortByDescending$iv = heap;
                boolean $i$f$sortByDescending = false;
                if ($this$sortByDescending$iv.size() > 1) {
                    List<ScoreIdPair> list = $this$sortByDescending$iv;
                    bl = false;
                    comparator = new Comparator<T>(){

                        public final int compare(T a, T b) {
                            boolean bl = false;
                            ScoreIdPair it = (ScoreIdPair)b;
                            boolean bl2 = false;
                            Comparable comparable = Float.valueOf(it.getScore());
                            it = (ScoreIdPair)a;
                            Comparable comparable2 = comparable;
                            bl2 = false;
                            Float f = Float.valueOf(it.getScore());
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)f);
                        }
                    };
                    CollectionsKt.sortWith(list, (Comparator)comparator);
                }
                if (heap.size() > k) {
                    $this$sortByDescending$iv = heap;
                    $i$f$sortByDescending = false;
                    if ($this$sortByDescending$iv.size() > 1) {
                        List<ScoreIdPair> list = $this$sortByDescending$iv;
                        bl = false;
                        comparator = new Comparator<T>(){

                            public final int compare(T a, T b) {
                                boolean bl = false;
                                ScoreIdPair it = (ScoreIdPair)b;
                                boolean bl2 = false;
                                Comparable comparable = Float.valueOf(it.getScore());
                                it = (ScoreIdPair)a;
                                Comparable comparable2 = comparable;
                                bl2 = false;
                                Float f = Float.valueOf(it.getScore());
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)f);
                            }
                        };
                        CollectionsKt.sortWith(list, (Comparator)comparator);
                    }
                    heap.remove(heap.size() - 1);
                }
            }
            ++i;
        }
    }

    public abstract void computeOutput(@NotNull Model.State var1);

    public abstract float forward(@NotNull IntArrayList var1, int var2, @NotNull Model.State var3, float var4, boolean var5);

    @NotNull
    public final Matrix getWo() {
        return this.wo;
    }

    public Loss(@NotNull Matrix wo) {
        Intrinsics.checkParameterIsNotNull((Object)wo, (String)"wo");
        this.wo = wo;
    }

    static {
        float f;
        double d;
        float x;
        int i;
        float[] fArray;
        int n;
        Companion = new Companion(null);
        int n2 = 513;
        float[] fArray2 = new float[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3;
            n = n3++;
            fArray = fArray2;
            boolean bl = false;
            x = (float)(i * 2 * 8) / (float)512 - (float)8;
            d = -x;
            double d2 = 1.0f;
            double d3 = 1.0f;
            boolean bl2 = false;
            double d4 = Math.exp(d);
            fArray[n] = f = (float)(d3 / (d2 + d4));
        }
        tSigmoid = fArray2;
        n2 = 513;
        fArray2 = new float[n2];
        n3 = 0;
        while (n3 < n2) {
            i = n3;
            n = n3++;
            fArray = fArray2;
            boolean bl = false;
            x = ((float)i + 1.0E-5f) / (float)512;
            d = x;
            boolean bl3 = false;
            fArray[n] = f = (float)Math.log(d);
        }
        tLog = fArray2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/mayabot/nlp/fasttext/loss/Loss$Companion;", "", "()V", "tLog", "", "tSigmoid", "log", "", "x", "sigmoid", "fastText4j"})
    public static final class Companion {
        public final float log(float x) {
            if (x > 1.0f) {
                return 0.0f;
            }
            int i = (int)(x * (float)512);
            return tLog[i];
        }

        public final float sigmoid(float x) {
            float f;
            if (x < (float)-8) {
                f = 0.0f;
            } else if (x > (float)8) {
                f = 1.0f;
            } else {
                int i = (int)((x + (float)8) * (float)512 / (float)8 / 2.0f);
                f = tSigmoid[i];
            }
            return f;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

