/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fasttext.loss;

import com.mayabot.nlp.fasttext.args.Args;
import com.mayabot.nlp.fasttext.args.ModelName;
import com.mayabot.nlp.fasttext.blas.Matrix;
import com.mayabot.nlp.fasttext.dictionary.Dictionary;
import com.mayabot.nlp.fasttext.dictionary.EntryType;
import com.mayabot.nlp.fasttext.loss.HierarchicalSoftmaxLoss;
import com.mayabot.nlp.fasttext.loss.Loss;
import com.mayabot.nlp.fasttext.loss.LossKt$WhenMappings;
import com.mayabot.nlp.fasttext.loss.NegativeSamplingLoss;
import com.mayabot.nlp.fasttext.loss.OneVsAlLoss;
import com.mayabot.nlp.fasttext.loss.SoftmaxLoss;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\u001a&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"LOG_TABLE_SIZE", "", "MAX_SIGMOID", "SIGMOID_TABLE_SIZE", "createLoss", "Lcom/mayabot/nlp/fasttext/loss/Loss;", "args", "Lcom/mayabot/nlp/fasttext/args/Args;", "output", "Lcom/mayabot/nlp/fasttext/blas/Matrix;", "modelName", "Lcom/mayabot/nlp/fasttext/args/ModelName;", "dictionary", "Lcom/mayabot/nlp/fasttext/dictionary/Dictionary;", "stdLog", "", "d", "", "fastText4j"})
public final class LossKt {
    public static final int SIGMOID_TABLE_SIZE = 512;
    public static final int MAX_SIGMOID = 8;
    public static final int LOG_TABLE_SIZE = 512;

    public static final double stdLog(float d) {
        double d2 = (double)d + 1.0E-5;
        boolean bl = false;
        return Math.log(d2);
    }

    @NotNull
    public static final Loss createLoss(@NotNull Args args, @NotNull Matrix output, @NotNull ModelName modelName, @NotNull Dictionary dictionary) {
        Loss loss;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)((Object)modelName), (String)"modelName");
        Intrinsics.checkParameterIsNotNull((Object)dictionary, (String)"dictionary");
        Function0<long[]> $fun$getTargetCounts$1 = new Function0<long[]>(modelName, dictionary){
            final /* synthetic */ ModelName $modelName;
            final /* synthetic */ Dictionary $dictionary;

            @NotNull
            public final long[] invoke() {
                return this.$modelName == ModelName.sup ? this.$dictionary.getCounts(EntryType.label) : this.$dictionary.getCounts(EntryType.word);
            }
            {
                this.$modelName = modelName;
                this.$dictionary = dictionary;
                super(0);
            }
        };
        switch (LossKt$WhenMappings.$EnumSwitchMapping$0[args.getLoss().ordinal()]) {
            case 1: {
                loss = new HierarchicalSoftmaxLoss(output, $fun$getTargetCounts$1.invoke());
                break;
            }
            case 2: {
                loss = new NegativeSamplingLoss(output, args.getNeg(), $fun$getTargetCounts$1.invoke());
                break;
            }
            case 3: {
                loss = new SoftmaxLoss(output);
                break;
            }
            case 4: {
                loss = new OneVsAlLoss(output);
                break;
            }
            default: {
                String string = "unknow loss";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return loss;
    }
}

