/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fasttext.utils;

import com.mayabot.nlp.fasttext.utils.ArraySizingStrategy;
import com.mayabot.nlp.fasttext.utils.BoundedProportionalArraySizingStrategy;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 +2\u00020\u0001:\u0001+B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0000J\u0006\u0010\u0016\u001a\u00020\u0012J\u0011\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0003H\u0086\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003J,\u0010\u001b\u001a\u00020\u00122!\u0010\u001c\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u00120\u001dH\u0086\bJ\u0011\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010#\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010$\u001a\u00020\u0012J\u000e\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0003J\u0019\u0010'\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010(\u001a\u00020\u0003J\u0006\u0010)\u001a\u00020\bJ\u0006\u0010*\u001a\u00020\u0012R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/mayabot/nlp/fasttext/utils/IntArrayList;", "", "expectedElements", "", "resizer", "Lcom/mayabot/nlp/fasttext/utils/ArraySizingStrategy;", "(ILcom/mayabot/nlp/fasttext/utils/ArraySizingStrategy;)V", "buffer", "", "getBuffer", "()[I", "setBuffer", "([I)V", "elementsCount", "isEmpty", "", "()Z", "add", "", "e1", "addAll", "ngrams", "clear", "contains", "ensureBufferSpace", "expectedAdditions", "ensureCapacity", "forEach", "action", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "num", "get", "index", "indexOf", "release", "resize", "newSize", "set", "size", "toArray", "trimToSize", "Companion", "fastText4j"})
public final class IntArrayList {
    @NotNull
    private int[] buffer;
    private int elementsCount;
    private final ArraySizingStrategy resizer;
    @NotNull
    private static final int[] EMPTY_ARRAY;
    public static final Companion Companion;

    @NotNull
    public final int[] getBuffer() {
        return this.buffer;
    }

    public final void setBuffer(@NotNull int[] nArray) {
        Intrinsics.checkParameterIsNotNull((Object)nArray, (String)"<set-?>");
        this.buffer = nArray;
    }

    public final void forEach(@NotNull Function1<? super Integer, Unit> action) {
        int $i$f$forEach = 0;
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        int[] buffer = this.getBuffer();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            action.invoke((Object)buffer[i]);
        }
    }

    public final void add(int e1) {
        this.ensureBufferSpace(1);
        int n = this.elementsCount;
        this.elementsCount = n + 1;
        this.buffer[n] = e1;
    }

    public final void addAll(@NotNull IntArrayList ngrams) {
        Intrinsics.checkParameterIsNotNull((Object)ngrams, (String)"ngrams");
        this.ensureBufferSpace(ngrams.size());
        IntArrayList this_$iv = ngrams;
        boolean $i$f$forEach = false;
        int[] buffer$iv = this_$iv.getBuffer();
        int size$iv = this_$iv.size();
        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
            int x = buffer$iv[i$iv];
            boolean bl = false;
            int n = this.elementsCount;
            this.elementsCount = n + 1;
            this.buffer[n] = x;
        }
    }

    public final int get(int index) {
        boolean bl = index >= 0 && index < this.size();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return this.buffer[index];
    }

    public final int set(int index, int e1) {
        boolean bl = index >= 0 && index < this.size();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    public final boolean contains(int e1) {
        return this.indexOf(e1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public final int indexOf(int e1) {
        int n = 0;
        int n2 = this.elementsCount;
        while (n < n2) {
            void i;
            if (this.buffer[i] == e1) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    public final boolean isEmpty() {
        return this.elementsCount == 0;
    }

    public final void ensureCapacity(int expectedElements) {
        int bufferLen = this.buffer.length;
        if (expectedElements > bufferLen) {
            this.ensureBufferSpace(expectedElements - this.size());
        }
    }

    private final void ensureBufferSpace(int expectedAdditions) {
        int bufferLen = this.buffer.length;
        if (this.elementsCount + expectedAdditions > bufferLen) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            boolean bl = newSize >= this.elementsCount + expectedAdditions;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Resizer failed to return sensible new size: " + newSize + " <= " + (this.elementsCount + expectedAdditions);
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            int[] nArray = this.buffer;
            IntArrayList intArrayList = this;
            bl2 = false;
            int[] nArray2 = Arrays.copyOf(nArray, newSize);
            Intrinsics.checkExpressionValueIsNotNull((Object)nArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
            int[] nArray3 = nArray2;
            intArrayList.buffer = nArray3;
        }
    }

    public final void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize < this.elementsCount) {
                Arrays.fill(this.buffer, newSize, this.elementsCount, 0);
            } else {
                Arrays.fill(this.buffer, this.elementsCount, newSize, 0);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    public final int size() {
        return this.elementsCount;
    }

    public final void trimToSize() {
        int n = this.size();
        if (this.buffer == null) {
            Intrinsics.throwNpe();
        }
        if (n != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    public final void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, 0);
        this.elementsCount = 0;
    }

    public final void release() {
        this.buffer = EMPTY_ARRAY;
        this.elementsCount = 0;
    }

    @NotNull
    public final int[] toArray() {
        int[] nArray = this.buffer;
        int n = this.elementsCount;
        boolean bl = false;
        int[] nArray2 = Arrays.copyOf(nArray, n);
        Intrinsics.checkExpressionValueIsNotNull((Object)nArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
        return nArray2;
    }

    public IntArrayList(int expectedElements, @NotNull ArraySizingStrategy resizer) {
        Intrinsics.checkParameterIsNotNull((Object)resizer, (String)"resizer");
        this.resizer = resizer;
        this.buffer = EMPTY_ARRAY;
        this.ensureCapacity(expectedElements);
    }

    public /* synthetic */ IntArrayList(int n, ArraySizingStrategy arraySizingStrategy, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4;
        }
        if ((n2 & 2) != 0) {
            arraySizingStrategy = new BoundedProportionalArraySizingStrategy();
        }
        this(n, arraySizingStrategy);
    }

    public IntArrayList() {
        this(0, null, 3, null);
    }

    static {
        Companion = new Companion(null);
        EMPTY_ARRAY = new int[0];
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00020\u0004\"\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/mayabot/nlp/fasttext/utils/IntArrayList$Companion;", "", "()V", "EMPTY_ARRAY", "", "getEMPTY_ARRAY", "()[I", "from", "Lcom/mayabot/nlp/fasttext/utils/IntArrayList;", "elements", "", "fastText4j"})
    public static final class Companion {
        @NotNull
        public final int[] getEMPTY_ARRAY() {
            return EMPTY_ARRAY;
        }

        @NotNull
        public final IntArrayList from(int ... elements) {
            Intrinsics.checkParameterIsNotNull((Object)elements, (String)"elements");
            IntArrayList list = new IntArrayList(elements.length, null, 2, null);
            for (int x : elements) {
                list.add(x);
            }
            return list;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

