/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.perceptron;

import com.mayabot.nlp.MynlpEnv;
import com.mayabot.nlp.Mynlps;
import com.mayabot.nlp.algorithm.TopIntMinK;
import com.mayabot.nlp.collection.dat.DoubleArrayTrie;
import com.mayabot.nlp.hppc.IntArrayList;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.perceptron.Perceptron;
import com.mayabot.nlp.perceptron.PerceptronFormat;
import com.mayabot.nlp.perceptron.TrainSample;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 B2\u00020\u0001:\u0002BCB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005J\u0018\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eH\u0016J&\u0010\u001d\u001a\u00020\u00142\u0014\u0010\u001e\u001a\u0010\u0012\b\u0012\u00060 j\u0002`!0\u001fj\u0002`\"2\u0006\u0010#\u001a\u00020\u0018H\u0016J&\u0010$\u001a\u00020\u00142\u0014\u0010\u001e\u001a\u0010\u0012\b\u0012\u00060 j\u0002`!0\u001fj\u0002`\"2\u0006\u0010#\u001a\u00020\u0018H\u0002J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u000bH\u0016J\b\u0010\u0002\u001a\u00020\u0003H\u0016J \u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010#\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u0005H\u0002J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u0005H\u0016J\u0010\u0010.\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0005H\u0016J0\u00102\u001a\u00020\u00142\u0006\u00101\u001a\u00020\u00052\u0006\u00103\u001a\u0002002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0010\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u000206H\u0016J\u001c\u00107\u001a\u00020\u000e2\n\u00108\u001a\u00060 j\u0002`!2\u0006\u00109\u001a\u00020\u0005H\u0002J\u000e\u0010:\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*J&\u0010:\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005J\u0018\u0010;\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020*2\u0006\u0010<\u001a\u000200H\u0002J\u0018\u0010=\u001a\u00020\u00142\u0006\u0010>\u001a\u00020\u00182\u0006\u0010?\u001a\u00020\u0018H\u0002J \u0010@\u001a\u00020\u00142\u0006\u0010>\u001a\u00020\u00182\u0006\u0010?\u001a\u00020\u00182\u0006\u0010<\u001a\u000200H\u0002J0\u0010A\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u00182\u0006\u0010?\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006D"}, d2={"Lcom/mayabot/nlp/perceptron/PerceptronModel;", "Lcom/mayabot/nlp/perceptron/Perceptron;", "featureSet", "Lcom/mayabot/nlp/perceptron/FeatureSet;", "labelCount", "", "(Lcom/mayabot/nlp/perceptron/FeatureSet;I)V", "parameter", "", "(Lcom/mayabot/nlp/perceptron/FeatureSet;I[F)V", "decodeQuickModel", "", "labelLimitInParameter", "maxScore", "", "getParameter", "()[F", "setParameter", "([F)V", "average", "", "total", "", "timestamp", "", "current", "compress", "ratio", "threshold", "decode", "featureSequence", "", "Lcom/mayabot/nlp/hppc/IntArrayList;", "Lcom/mayabot/nlp/perceptron/FeatureVector;", "Lcom/mayabot/nlp/perceptron/FeatureVectorSequence;", "guessLabel", "decodeQuick", "decodeQuickMode", "quick", "featureToLabel", "Lcom/mayabot/nlp/perceptron/PerceptronModel$Labels;", "data", "Lcom/mayabot/nlp/perceptron/TrainSample;", "i", "makeSureParameter", "featureId", "onlineLearn", "parameterAt", "", "index", "record", "value", "save", "dir", "Ljava/io/File;", "scoreBase", "featureVector", "currentTag", "update", "updateForOnlineLearnInner", "step", "updateOnline", "goldIndex", "predictIndex", "updateOnline2", "updateParameter", "Companion", "Labels", "mynlp-perceptron"})
public final class PerceptronModel
implements Perceptron {
    private final double maxScore = -2.147483648E9;
    private boolean decodeQuickModel;
    private final int labelLimitInParameter;
    private final FeatureSet featureSet;
    private final int labelCount;
    @NotNull
    private float[] parameter;
    public static final Companion Companion = new Companion(null);

    @Override
    public float parameterAt(int index) {
        return this.parameter[index];
    }

    @Override
    public void decodeQuickMode(boolean quick) {
        this.decodeQuickModel = quick;
    }

    @Override
    @NotNull
    public FeatureSet featureSet() {
        return this.featureSet;
    }

    @Override
    public void makeSureParameter(int featureId) {
        int newSize = (featureId + 1) * this.labelCount;
        if (newSize > this.parameter.length) {
            float[] fArray = this.parameter;
            PerceptronModel perceptronModel = this;
            boolean bl = false;
            float[] fArray2 = Arrays.copyOf(fArray, newSize);
            Intrinsics.checkExpressionValueIsNotNull((Object)fArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
            float[] fArray3 = fArray2;
            perceptronModel.parameter = fArray3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void update(@NotNull TrainSample data, @NotNull double[] total, @NotNull int[] timestamp, int current) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)total, (String)"total");
        Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
        int length = data.getSize();
        int[] guessLabel = new int[length];
        this.decode(data.getFeatureSequence(), guessLabel);
        int n = 0;
        int n2 = length;
        while (n < n2) {
            void i;
            Labels labels = this.featureToLabel(data, guessLabel, (int)i);
            this.updateParameter(labels.getGoldFeature(), labels.getPredFeature(), total, timestamp, current);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void update(@NotNull TrainSample data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        int length = data.getSize();
        int[] guessLabel = new int[length];
        this.decode(data.getFeatureSequence(), guessLabel);
        int n = 0;
        int n2 = length;
        while (n < n2) {
            void i;
            Labels labels = this.featureToLabel(data, guessLabel, (int)i);
            this.updateOnline(labels.getGoldFeature(), labels.getPredFeature());
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onlineLearn(@NotNull TrainSample data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        int[] guessLabel = new int[data.getSize()];
        this.decode(data.getFeatureSequence(), guessLabel);
        if (Arrays.equals(guessLabel, data.getLabel())) {
            return;
        }
        int over = 0;
        int n = 0;
        int n2 = 10;
        while (n < n2) {
            void i;
            boolean eq = this.updateForOnlineLearnInner(data, 1.0f);
            if (eq && ++over > 1) {
                return;
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean updateForOnlineLearnInner(TrainSample data, float step) {
        int length = data.getSize();
        int[] guessLabel = new int[length];
        this.decode(data.getFeatureSequence(), guessLabel);
        int n = 0;
        int n2 = length;
        while (n < n2) {
            void i;
            Labels labels = this.featureToLabel(data, guessLabel, (int)i);
            this.updateOnline2(labels.getGoldFeature(), labels.getPredFeature(), step);
            ++i;
        }
        this.decode(data.getFeatureSequence(), guessLabel);
        return Arrays.equals(guessLabel, data.getLabel());
    }

    /*
     * WARNING - void declaration
     */
    private final void updateOnline2(int[] goldIndex, int[] predictIndex, float step) {
        int n = 0;
        int n2 = goldIndex.length;
        while (n < n2) {
            void i;
            int xii = predictIndex[i];
            if (goldIndex[i] != xii) {
                int toAdd = goldIndex[i];
                if (toAdd > this.labelLimitInParameter) {
                    int n3 = toAdd;
                    this.parameter[n3] = this.parameter[n3] + step;
                }
                if (xii >= 0 && xii < this.parameter.length && xii > this.labelLimitInParameter) {
                    int n4 = xii;
                    this.parameter[n4] = this.parameter[n4] - step;
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateOnline(int[] goldIndex, int[] predictIndex) {
        int n = 0;
        int n2 = goldIndex.length;
        while (n < n2) {
            void i;
            int xii = predictIndex[i];
            if (goldIndex[i] != xii) {
                int n3 = goldIndex[i];
                float f = this.parameter[n3];
                this.parameter[n3] = f + 1.0f;
                if (xii >= 0 && xii < this.parameter.length) {
                    int n4 = xii;
                    f = this.parameter[n4];
                    this.parameter[n4] = f + -1.0f;
                } else {
                    throw (Throwable)new IllegalArgumentException("\u66f4\u65b0\u53c2\u6570\u65f6\u4f20\u5165\u4e86\u975e\u6cd5\u7684\u4e0b\u6807");
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Labels featureToLabel(TrainSample data, int[] guessLabel, int i) {
        IntArrayList featureVector = data.getFeatureSequence().get(i);
        int[] goldFeature = new int[featureVector.size()];
        int[] predFeature = new int[featureVector.size()];
        int last = featureVector.size() - 1;
        int n = 0;
        int n2 = last;
        while (n < n2) {
            void j;
            goldFeature[j] = featureVector.get((int)j) * this.labelCount + data.getLabel()[i];
            predFeature[j] = featureVector.get((int)j) * this.labelCount + guessLabel[i];
            ++j;
        }
        goldFeature[last] = (i == 0 ? this.labelCount : data.getLabel()[i - 1]) * this.labelCount + data.getLabel()[i];
        predFeature[last] = (i == 0 ? this.labelCount : guessLabel[i - 1]) * this.labelCount + guessLabel[i];
        return new Labels(goldFeature, predFeature);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean updateParameter(int[] goldIndex, int[] predictIndex, double[] total, int[] timestamp, int current) {
        int[] nArray = goldIndex;
        int n = 0;
        if (Arrays.equals(nArray, predictIndex)) {
            return false;
        }
        int n2 = 0;
        n = goldIndex.length;
        while (n2 < n) {
            void i;
            if (goldIndex[i] != predictIndex[i]) {
                this.record(goldIndex[i], 1.0f, total, timestamp, current);
                if (predictIndex[i] >= 0 && predictIndex[i] < this.parameter.length) {
                    this.record(predictIndex[i], -1.0f, total, timestamp, current);
                } else {
                    throw (Throwable)new IllegalArgumentException("\u66f4\u65b0\u53c2\u6570\u65f6\u4f20\u5165\u4e86\u975e\u6cd5\u7684\u4e0b\u6807");
                }
            }
            ++i;
        }
        return true;
    }

    private final void record(int index, float value, double[] total, int[] timestamp, int current) {
        int passed = current - timestamp[index];
        int n = index;
        total[n] = total[n] + (double)passed * (double)this.parameter[index];
        int n2 = index;
        this.parameter[n2] = this.parameter[n2] + value;
        timestamp[index] = current;
    }

    /*
     * WARNING - void declaration
     */
    public final void average(@NotNull double[] total, @NotNull int[] timestamp, int current) {
        Intrinsics.checkParameterIsNotNull((Object)total, (String)"total");
        Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
        float cf = current;
        int n = 0;
        int n2 = this.parameter.length;
        while (n < n2) {
            void i;
            float pass = cf - (float)timestamp[i];
            float totali = (float)total[i];
            this.parameter[i] = (totali + pass * this.parameter[i]) / cf;
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Perceptron compress(double ratio, double threshold) {
        Object object;
        Object object2;
        boolean $i$f$map;
        Object heap;
        if (ratio < 0.0 || ratio >= 1.0) {
            throw (Throwable)new IllegalArgumentException("\u538b\u7f29\u6bd4\u5fc5\u987b\u4ecb\u4e8e 0 \u548c 1 \u4e4b\u95f4");
        }
        boolean bl = this.featureSet.getKeys() != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int k = ratio == 0.0 ? 0 : (int)(ratio * (double)this.featureSet.size());
        List<String> list = this.featureSet.getKeys();
        if (list == null) {
            Intrinsics.throwNpe();
        }
        List<String> featureList = list;
        Function1<Integer, Float> $fun$score$1 = new Function1<Integer, Float>(this){
            final /* synthetic */ PerceptronModel this$0;

            /*
             * WARNING - void declaration
             */
            public final float invoke(int id) {
                float s = 0.0f;
                int n = id * PerceptronModel.access$getLabelCount$p(this.this$0);
                int n2 = id * PerceptronModel.access$getLabelCount$p(this.this$0) + PerceptronModel.access$getLabelCount$p(this.this$0);
                while (n < n2) {
                    void i;
                    s += Math.abs(this.this$0.getParameter()[i]);
                    ++i;
                }
                return s;
            }
            {
                this.this$0 = perceptronModel;
                super(1);
            }
        };
        HashSet<Integer> filterSet = new HashSet<Integer>();
        int n = 0;
        int n2 = featureList.size();
        while (n < n2) {
            void id;
            float s = $fun$score$1.invoke((int)id);
            if ((double)s < threshold) {
                filterSet.add((int)id);
            }
            ++id;
        }
        String id = "threshold filterd " + filterSet.size();
        n2 = 0;
        System.out.println((Object)id);
        if (k > 0 && filterSet.size() < k) {
            void $this$mapTo$iv$iv;
            heap = new TopIntMinK(k - filterSet.size());
            String string = "let's filter top min " + (k - filterSet.size());
            int s = 0;
            System.out.println((Object)string);
            int n3 = 0;
            s = featureList.size();
            while (n3 < s) {
                void id2;
                float s2 = $fun$score$1.invoke((int)id2);
                if ((double)s2 >= threshold) {
                    heap.push((int)id2, s2);
                }
                ++id2;
            }
            Iterable $this$map$iv = heap.result();
            $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl5 = false;
                object = ((Number)it.getFirst()).intValue();
                object2.add(object);
            }
            Set topMinResultIdSet22 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            filterSet.addAll(topMinResultIdSet22);
        }
        heap = StringCompanionObject.INSTANCE;
        String topMinResultIdSet22 = "%.3f";
        Object[] $this$map$iv = new Object[]{Float.valueOf((float)filterSet.size() * 1.0f / (float)featureList.size())};
        object2 = new StringBuilder().append("remove ").append(filterSet.size()).append(" feature,real compress ");
        $i$f$map = false;
        String string = String.format(topMinResultIdSet22, Arrays.copyOf($this$map$iv, $this$map$iv.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
        object = string;
        heap = ((StringBuilder)object2).append((String)object).toString();
        boolean topMinResultIdSet22 = false;
        System.out.println(heap);
        int newSize = featureList.size() - filterSet.size();
        ArrayList newFeatureList = new ArrayList(newSize);
        float[] newParameter = new float[this.labelCount * newSize];
        int cc = 0;
        Iterable $this$forEachIndexed$iv = featureList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void s;
            int n4 = index$iv++;
            boolean bl6 = false;
            if (n4 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n5 = n4;
            String string2 = (String)item$iv;
            int index = n5;
            boolean bl7 = false;
            if (index > this.labelCount && filterSet.contains(index)) continue;
            Collection collection = newFeatureList;
            boolean bl8 = false;
            collection.add(s);
            System.arraycopy(this.parameter, index * this.labelCount, newParameter, cc * this.labelCount, this.labelCount);
            int n6 = cc;
            cc = n6 + 1;
        }
        return new PerceptronModel(new FeatureSet(new DoubleArrayTrie((List)newFeatureList), newFeatureList), this.labelCount, newParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        dir.mkdirs();
        Object object = new File(dir, "parameter.bin");
        int n = 0;
        object = new FileOutputStream((File)object);
        n = 8192;
        boolean bl = false;
        object = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n);
        n = 0;
        Throwable throwable = null;
        try {
            BufferedOutputStream it = (BufferedOutputStream)object;
            boolean bl2 = false;
            DataOutputStream out = new DataOutputStream(it);
            out.writeInt(this.labelCount);
            out.writeInt(this.parameter.length);
            float[] $this$forEach$iv = this.parameter;
            boolean $i$f$forEach = false;
            float[] fArray = $this$forEach$iv;
            int n2 = fArray.length;
            for (int i = 0; i < n2; ++i) {
                float element$iv;
                float w = element$iv = fArray[i];
                boolean bl3 = false;
                out.writeFloat(w);
            }
            out.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        this.featureSet.save(new File(dir, "feature.dat"), new File(dir, "feature.txt"));
    }

    /*
     * WARNING - void declaration
     */
    private final void decodeQuick(List<? extends IntArrayList> featureSequence, int[] guessLabel) {
        int index = 0;
        for (IntArrayList intArrayList : featureSequence) {
            int[] buffer = intArrayList.buffer;
            int sizeM1 = intArrayList.size() - 1;
            double maxScore = this.maxScore;
            int maxIndex = 0;
            int n = 0;
            int n2 = this.labelCount;
            while (n < n2) {
                void label;
                double score = 0.0;
                int n3 = 0;
                int n4 = sizeM1;
                while (n3 < n4) {
                    void i;
                    score += (double)this.parameter[buffer[i] * this.labelCount + label];
                    ++i;
                }
                if (score > maxScore) {
                    maxIndex = label;
                    maxScore = score;
                }
                ++label;
            }
            guessLabel[index++] = maxIndex;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void decode(@NotNull List<? extends IntArrayList> featureSequence, @NotNull int[] guessLabel) {
        int base;
        int j;
        Intrinsics.checkParameterIsNotNull(featureSequence, (String)"featureSequence");
        Intrinsics.checkParameterIsNotNull((Object)guessLabel, (String)"guessLabel");
        if (this.decodeQuickModel) {
            this.decodeQuick(featureSequence, guessLabel);
            return;
        }
        int sentenceLength = featureSequence.size();
        int[] preMatrix = new int[sentenceLength * this.labelCount];
        double[] scoreMLast = new double[this.labelCount];
        double[] scoreMNow = new double[this.labelCount];
        IntArrayList firstFeature = featureSequence.get(0);
        int bos = this.labelCount;
        int bosBase = bos * this.labelCount;
        int n = 0;
        int n2 = this.labelCount;
        while (n < n2) {
            double score;
            preMatrix[j] = j;
            scoreMLast[j] = score = this.scoreBase(firstFeature, j) + (double)this.parameter[bosBase + j];
            ++j;
        }
        j = 1;
        n2 = sentenceLength;
        while (j < n2) {
            void i;
            IntArrayList allFeature = featureSequence.get((int)i);
            base = i * this.labelCount;
            int n3 = 0;
            int n4 = this.labelCount;
            while (n3 < n4) {
                void curLabel;
                double maxScore = this.maxScore;
                double baseScore = this.scoreBase(allFeature, (int)curLabel);
                int n5 = 0;
                int n6 = this.labelCount;
                while (n5 < n6) {
                    void preLabel;
                    double curScore = scoreMLast[preLabel] + baseScore + (double)this.parameter[preLabel * this.labelCount + curLabel];
                    if (curScore > maxScore) {
                        maxScore = curScore;
                        preMatrix[base + curLabel] = preLabel;
                        scoreMNow[curLabel] = maxScore;
                    }
                    ++preLabel;
                }
                ++curLabel;
            }
            double[] temp = scoreMLast;
            scoreMLast = scoreMNow;
            scoreMNow = temp;
            ++i;
        }
        int maxIndex = 0;
        double maxScore = scoreMLast[0];
        base = 1;
        int temp = this.labelCount;
        while (base < temp) {
            void index;
            double x = scoreMLast[index];
            if (maxScore < x) {
                maxIndex = index;
                maxScore = x;
            }
            ++index;
        }
        int k = (sentenceLength - 1) * this.labelCount;
        temp = sentenceLength - 1;
        boolean bl = false;
        while (temp >= 0) {
            void i;
            guessLabel[i] = maxIndex;
            maxIndex = preMatrix[k + maxIndex];
            k -= this.labelCount;
            --i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final double scoreBase(IntArrayList featureVector, int currentTag) {
        double score = 0.0;
        int[] buffer = featureVector.buffer;
        int n = 0;
        int n2 = featureVector.size() - 1;
        while (n < n2) {
            void i;
            int index = buffer[i];
            score += (double)this.parameter[index * this.labelCount + currentTag];
            ++i;
        }
        return score;
    }

    @NotNull
    public final float[] getParameter() {
        return this.parameter;
    }

    public final void setParameter(@NotNull float[] fArray) {
        Intrinsics.checkParameterIsNotNull((Object)fArray, (String)"<set-?>");
        this.parameter = fArray;
    }

    public PerceptronModel(@NotNull FeatureSet featureSet2, int labelCount, @NotNull float[] parameter) {
        Intrinsics.checkParameterIsNotNull((Object)featureSet2, (String)"featureSet");
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        this.featureSet = featureSet2;
        this.labelCount = labelCount;
        this.parameter = parameter;
        this.maxScore = Integer.MIN_VALUE;
        this.labelLimitInParameter = (this.labelCount + 1) * this.labelCount;
    }

    public PerceptronModel(@NotNull FeatureSet featureSet2, int labelCount) {
        Intrinsics.checkParameterIsNotNull((Object)featureSet2, (String)"featureSet");
        this(featureSet2, labelCount, new float[featureSet2.size() * labelCount]);
    }

    @Override
    @NotNull
    public int[] decode(@NotNull List<? extends IntArrayList> featureSequence) {
        Intrinsics.checkParameterIsNotNull(featureSequence, (String)"featureSequence");
        return Perceptron.DefaultImpls.decode(this, featureSequence);
    }

    public static final /* synthetic */ int access$getLabelCount$p(PerceptronModel $this) {
        return $this.labelCount;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Perceptron loadFromClasspath(@NotNull String prefix, @NotNull ClassLoader loader) {
        return Companion.loadFromClasspath(prefix, loader);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Perceptron loadFromClasspath(@NotNull String prefix) {
        return com.mayabot.nlp.perceptron.PerceptronModel$Companion.loadFromClasspath$default(Companion, prefix, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Perceptron loadFromNlpResouce(@NotNull String prefix, @NotNull MynlpEnv env) {
        return Companion.loadFromNlpResouce(prefix, env);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Perceptron loadFromNlpResouce(@NotNull String prefix) {
        return com.mayabot.nlp.perceptron.PerceptronModel$Companion.loadFromNlpResouce$default(Companion, prefix, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final Perceptron loadWithFeatureBin(@NotNull InputStream parameterBin, @NotNull InputStream featureBin) {
        return Companion.loadWithFeatureBin(parameterBin, featureBin);
    }

    @JvmStatic
    @NotNull
    public static final Perceptron loadWithFeatureTxt(@NotNull InputStream parameterBin, @NotNull InputStream featureTxt) {
        return Companion.loadWithFeatureTxt(parameterBin, featureTxt);
    }

    @JvmStatic
    @NotNull
    public static final Perceptron load(@NotNull File dir) {
        return Companion.load(dir);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/mayabot/nlp/perceptron/PerceptronModel$Labels;", "", "goldFeature", "", "predFeature", "([I[I)V", "getGoldFeature", "()[I", "getPredFeature", "mynlp-perceptron"})
    public static final class Labels {
        @NotNull
        private final int[] goldFeature;
        @NotNull
        private final int[] predFeature;

        @NotNull
        public final int[] getGoldFeature() {
            return this.goldFeature;
        }

        @NotNull
        public final int[] getPredFeature() {
            return this.predFeature;
        }

        public Labels(@NotNull int[] goldFeature, @NotNull int[] predFeature) {
            Intrinsics.checkParameterIsNotNull((Object)goldFeature, (String)"goldFeature");
            Intrinsics.checkParameterIsNotNull((Object)predFeature, (String)"predFeature");
            this.goldFeature = goldFeature;
            this.predFeature = predFeature;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0007J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0007\u00a8\u0006\u0015"}, d2={"Lcom/mayabot/nlp/perceptron/PerceptronModel$Companion;", "", "()V", "load", "Lcom/mayabot/nlp/perceptron/Perceptron;", "dir", "Ljava/io/File;", "loadFromClasspath", "prefix", "", "loader", "Ljava/lang/ClassLoader;", "loadFromNlpResouce", "env", "Lcom/mayabot/nlp/MynlpEnv;", "loadWithFeatureBin", "parameterBin", "Ljava/io/InputStream;", "featureBin", "loadWithFeatureTxt", "featureTxt", "mynlp-perceptron"})
    public static final class Companion {
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Perceptron loadFromClasspath(@NotNull String prefix, @NotNull ClassLoader loader) {
            Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
            Intrinsics.checkParameterIsNotNull((Object)loader, (String)"loader");
            return PerceptronFormat.INSTANCE.loadFromClasspath(prefix, loader);
        }

        public static /* synthetic */ Perceptron loadFromClasspath$default(Companion companion, String string, ClassLoader classLoader, int n, Object object) {
            if ((n & 2) != 0) {
                Thread thread = Thread.currentThread();
                Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
                ClassLoader classLoader2 = thread.getContextClassLoader();
                Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"Thread.currentThread().contextClassLoader");
                classLoader = classLoader2;
            }
            return companion.loadFromClasspath(string, classLoader);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Perceptron loadFromClasspath(@NotNull String prefix) {
            return com.mayabot.nlp.perceptron.PerceptronModel$Companion.loadFromClasspath$default(this, prefix, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Perceptron loadFromNlpResouce(@NotNull String prefix, @NotNull MynlpEnv env) {
            Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
            Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
            return PerceptronFormat.INSTANCE.loadFromNlpResource(prefix, env);
        }

        public static /* synthetic */ Perceptron loadFromNlpResouce$default(Companion companion, String string, MynlpEnv mynlpEnv, int n, Object object) {
            if ((n & 2) != 0) {
                MynlpEnv mynlpEnv2 = Mynlps.get().getEnv();
                Intrinsics.checkExpressionValueIsNotNull((Object)mynlpEnv2, (String)"Mynlps.get().env");
                mynlpEnv = mynlpEnv2;
            }
            return companion.loadFromNlpResouce(string, mynlpEnv);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Perceptron loadFromNlpResouce(@NotNull String prefix) {
            return com.mayabot.nlp.perceptron.PerceptronModel$Companion.loadFromNlpResouce$default(this, prefix, null, 2, null);
        }

        @JvmStatic
        @NotNull
        public final Perceptron loadWithFeatureBin(@NotNull InputStream parameterBin, @NotNull InputStream featureBin) {
            Intrinsics.checkParameterIsNotNull((Object)parameterBin, (String)"parameterBin");
            Intrinsics.checkParameterIsNotNull((Object)featureBin, (String)"featureBin");
            return PerceptronFormat.INSTANCE.loadWithFeatureBin(parameterBin, featureBin);
        }

        @JvmStatic
        @NotNull
        public final Perceptron loadWithFeatureTxt(@NotNull InputStream parameterBin, @NotNull InputStream featureTxt) {
            Intrinsics.checkParameterIsNotNull((Object)parameterBin, (String)"parameterBin");
            Intrinsics.checkParameterIsNotNull((Object)featureTxt, (String)"featureTxt");
            return PerceptronFormat.INSTANCE.loadWithFeatureTxt(parameterBin, featureTxt);
        }

        @JvmStatic
        @NotNull
        public final Perceptron load(@NotNull File dir) {
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            return PerceptronFormat.INSTANCE.load(dir);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

