/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.lexer.core;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.mayabot.nlp.MynlpEnv;
import com.mayabot.nlp.logging.InternalLogger;
import com.mayabot.nlp.logging.InternalLoggerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

abstract class BaseNlpResourceExternalizable
implements Externalizable {
    private MynlpEnv env;

    public BaseNlpResourceExternalizable(MynlpEnv env) {
        this.env = env;
    }

    public abstract String sourceVersion();

    public abstract void loadFromSource() throws Exception;

    public void restore() throws Exception {
        InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
        boolean success = false;
        String sourceName = this.getClass().getSimpleName();
        File cache = new File(new File(this.env.getCacheDir(), sourceName), this.sourceVersion() + ".dat");
        File parent = cache.getCanonicalFile().getParentFile();
        parent.mkdirs();
        boolean loadFromBin = false;
        if (cache.exists() && cache.canRead()) {
            try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(cache), 65536));){
                long t1 = System.currentTimeMillis();
                this.readExternal(in);
                long t2 = System.currentTimeMillis();
                success = true;
                loadFromBin = true;
                logger.info(cache.getName() + " restore from cache file success, use time " + (t2 - t1) + " ms");
            }
            catch (Exception e) {
                logger.warn("restore from cache " + cache.getAbsolutePath(), (Throwable)e);
            }
        }
        if (!success) {
            long t1 = System.currentTimeMillis();
            this.loadFromSource();
            long t2 = System.currentTimeMillis();
            logger.info("restore from data source, use time " + (t2 - t1) + " ms");
            if (!loadFromBin) {
                long t3 = System.currentTimeMillis();
                try (ObjectOutputStream outputStream = new ObjectOutputStream(new BufferedOutputStream(Files.asByteSink((File)cache, (FileWriteMode[])new FileWriteMode[0]).openStream(), 65536));){
                    this.writeExternal(outputStream);
                    outputStream.flush();
                }
                long t4 = System.currentTimeMillis();
                logger.info("save cache file success, use time " + (t4 - t3) + " ms");
            }
        }
    }
}

