/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.pipeline;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mayabot.nlp.Mynlp;
import com.mayabot.nlp.Mynlps;
import com.mayabot.nlp.segment.CharNormalize;
import com.mayabot.nlp.segment.Lexer;
import com.mayabot.nlp.segment.LexerBuilder;
import com.mayabot.nlp.segment.SegmentComponent;
import com.mayabot.nlp.segment.WordSplitAlgorithm;
import com.mayabot.nlp.segment.WordpathProcessor;
import com.mayabot.nlp.segment.common.DefaultCharNormalize;
import com.mayabot.nlp.segment.lexer.core.CoreLexerPlugin;
import com.mayabot.nlp.segment.lexer.core.ViterbiBestPathAlgorithm;
import com.mayabot.nlp.segment.pipeline.PipelineLexer;
import com.mayabot.nlp.segment.pipeline.PipelineLexerPlugin;
import com.mayabot.nlp.segment.plugins.collector.SentenceCollector;
import com.mayabot.nlp.segment.plugins.collector.WordTermCollector;
import com.mayabot.nlp.segment.wordnet.BestPathAlgorithm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class PipelineLexerBuilder
implements LexerBuilder {
    @NotNull
    protected final Mynlp mynlp;
    private boolean keepOriCharOutput = false;
    @NotNull
    private BestPathAlgorithm bestPathAlgorithm;
    private List<CharNormalize> charNormalizes = Lists.newArrayList((Object[])new CharNormalize[]{DefaultCharNormalize.instance});
    private LinkedList<WordSplitAlgorithm> wordSplitAlgorithmList = Lists.newLinkedList();
    private LinkedList<WordpathProcessor> pipeLine = Lists.newLinkedList();
    private List<ConsumerPair> configListener = Lists.newArrayList();
    private WordTermCollector termCollector = new SentenceCollector();

    @NotNull
    public static PipelineLexerBuilder builder() {
        return new PipelineLexerBuilder();
    }

    public PipelineLexerBuilder() {
        this(Mynlps.get());
    }

    public PipelineLexerBuilder(Mynlp mynlp) {
        this.mynlp = mynlp;
        this.bestPathAlgorithm = (BestPathAlgorithm)mynlp.getInstance(ViterbiBestPathAlgorithm.class);
    }

    public final void install(@NotNull PipelineLexerPlugin module) {
        Preconditions.checkNotNull((Object)module);
        module.install(this);
    }

    @Override
    public Lexer build() {
        if (this.wordSplitAlgorithmList.isEmpty()) {
            this.install(new CoreLexerPlugin());
        }
        this.callListener();
        ArrayList splitAlgorithms = Lists.newArrayList(this.wordSplitAlgorithmList);
        ArrayList wordpathProcessors = Lists.newArrayList(this.pipeLine);
        Collections.sort(splitAlgorithms);
        Collections.sort(wordpathProcessors);
        return new PipelineLexer(Lists.newArrayList((Iterable)splitAlgorithms), wordpathProcessors.toArray(new WordpathProcessor[0]), this.bestPathAlgorithm, this.termCollector, Lists.newArrayList(this.charNormalizes), this.keepOriCharOutput);
    }

    private boolean instanceOf(Object subObj, Class parent) {
        Class<?> sub = subObj.getClass();
        return parent.equals(sub) || parent.isAssignableFrom(sub);
    }

    private void callListener() {
        for (ConsumerPair pair : this.configListener) {
            if (this.instanceOf(this.termCollector, pair.clazz)) {
                pair.consumer.accept(this.termCollector);
            }
            this.wordSplitAlgorithmList.forEach(it -> {
                if (this.instanceOf(it, pair.clazz)) {
                    pair.consumer.accept(it);
                }
            });
            this.pipeLine.forEach(it -> {
                if (this.instanceOf(it, pair.clazz)) {
                    pair.consumer.accept(it);
                }
            });
        }
    }

    public <T> PipelineLexerBuilder config(Class<T> clazz, Consumer<T> listener) {
        this.configListener.add(new ConsumerPair(clazz, listener));
        return this;
    }

    public PipelineLexerBuilder disabledComponent(Class<? extends SegmentComponent> clazz) {
        this.config(clazz, SegmentComponent::disable);
        return this;
    }

    public PipelineLexerBuilder enableComponent(Class<? extends SegmentComponent> clazz) {
        this.config(clazz, SegmentComponent::enable);
        return this;
    }

    public PipelineLexerBuilder addCharNormalize(Class<? extends CharNormalize> charNormalizeClass) {
        this.addCharNormalize((CharNormalize)this.mynlp.getInstance(charNormalizeClass));
        return this;
    }

    public PipelineLexerBuilder addCharNormalize(CharNormalize charNormalize) {
        if (this.charNormalizes.contains(charNormalize)) {
            return this;
        }
        this.charNormalizes.add(charNormalize);
        return this;
    }

    public PipelineLexerBuilder removeCharNormalize(Class<? extends CharNormalize> clazz) {
        this.charNormalizes.removeIf(obj -> clazz.isAssignableFrom(obj.getClass()) || obj.getClass().equals(clazz));
        return this;
    }

    public PipelineLexerBuilder setBestPathAlgorithm(BestPathAlgorithm bestPathAlgorithm) {
        this.bestPathAlgorithm = (BestPathAlgorithm)Preconditions.checkNotNull((Object)bestPathAlgorithm);
        return this;
    }

    public PipelineLexerBuilder setBestPathComputer(Class<? extends BestPathAlgorithm> clazz) {
        this.setBestPathAlgorithm((BestPathAlgorithm)this.mynlp.getInstance(clazz));
        return this;
    }

    public PipelineLexerBuilder addProcessor(WordpathProcessor processor) {
        if (this.pipeLine.contains(processor)) {
            return this;
        }
        this.pipeLine.add(processor);
        Collections.sort(this.pipeLine);
        return this;
    }

    public PipelineLexerBuilder addProcessor(Class<? extends WordpathProcessor> clazz) {
        this.addProcessor((WordpathProcessor)this.mynlp.getInstance(clazz));
        return this;
    }

    public boolean existWordPathProcessor(Class clazz) {
        return this.pipeLine.stream().anyMatch(x -> this.instanceOf(x.getClass(), clazz));
    }

    public PipelineLexerBuilder addWordSplitAlgorithm(WordSplitAlgorithm algorithm) {
        if (this.wordSplitAlgorithmList.contains(algorithm)) {
            return this;
        }
        this.wordSplitAlgorithmList.add(algorithm);
        Collections.sort(this.wordSplitAlgorithmList);
        return this;
    }

    public PipelineLexerBuilder addWordSplitAlgorithm(Class<? extends WordSplitAlgorithm> algorithm) {
        this.addWordSplitAlgorithm((WordSplitAlgorithm)this.mynlp.getInstance(algorithm));
        return this;
    }

    public PipelineLexerBuilder setTermCollector(@NotNull WordTermCollector termCollector) {
        if (termCollector == null) {
            throw new NullPointerException("WordTermCollector is null");
        }
        this.termCollector = termCollector;
        return this;
    }

    public PipelineLexerBuilder setTermCollector(Class<? extends WordTermCollector> termCollectorClass) {
        this.termCollector = (WordTermCollector)this.mynlp.getInstance(termCollectorClass);
        return this;
    }

    @NotNull
    public WordTermCollector getTermCollector() {
        return this.termCollector;
    }

    public boolean isKeepOriCharOutput() {
        return this.keepOriCharOutput;
    }

    public PipelineLexerBuilder setKeepOriCharOutput(boolean keepOriCharOutput) {
        this.keepOriCharOutput = keepOriCharOutput;
        return this;
    }

    private static class ConsumerPair {
        Class clazz;
        Consumer consumer;

        public ConsumerPair(Class clazz, Consumer consumer) {
            this.clazz = clazz;
            this.consumer = consumer;
        }
    }
}

