/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.collector;

import com.mayabot.nlp.segment.WordTerm;
import com.mayabot.nlp.segment.plugins.collector.WordTermCollector;
import com.mayabot.nlp.segment.wordnet.Vertex;
import com.mayabot.nlp.segment.wordnet.Wordnet;
import com.mayabot.nlp.segment.wordnet.Wordpath;
import com.mayabot.nlp.utils.StringUtils;
import java.util.Iterator;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/mayabot/nlp/segment/plugins/collector/SentenceCollector;", "Lcom/mayabot/nlp/segment/plugins/collector/WordTermCollector;", "()V", "fillSubword", "Lcom/mayabot/nlp/segment/plugins/collector/WordTermCollector$FillSubword;", "getFillSubword", "()Lcom/mayabot/nlp/segment/plugins/collector/WordTermCollector$FillSubword;", "setFillSubword", "(Lcom/mayabot/nlp/segment/plugins/collector/WordTermCollector$FillSubword;)V", "pickUpSubword", "Lcom/mayabot/nlp/segment/plugins/collector/WordTermCollector$PickUpSubword;", "getPickUpSubword", "()Lcom/mayabot/nlp/segment/plugins/collector/WordTermCollector$PickUpSubword;", "setPickUpSubword", "(Lcom/mayabot/nlp/segment/plugins/collector/WordTermCollector$PickUpSubword;)V", "collect", "", "txtChars", "", "wordnet", "Lcom/mayabot/nlp/segment/wordnet/Wordnet;", "wordPath", "Lcom/mayabot/nlp/segment/wordnet/Wordpath;", "consumer", "Ljava/util/function/Consumer;", "Lcom/mayabot/nlp/segment/WordTerm;", "mynlp-segment"})
public final class SentenceCollector
implements WordTermCollector {
    @Nullable
    private WordTermCollector.PickUpSubword pickUpSubword;
    @Nullable
    private WordTermCollector.FillSubword fillSubword;

    @Override
    @Nullable
    public WordTermCollector.PickUpSubword getPickUpSubword() {
        return this.pickUpSubword;
    }

    @Override
    public void setPickUpSubword(@Nullable WordTermCollector.PickUpSubword pickUpSubword) {
        this.pickUpSubword = pickUpSubword;
    }

    @Override
    @Nullable
    public WordTermCollector.FillSubword getFillSubword() {
        return this.fillSubword;
    }

    @Override
    public void setFillSubword(@Nullable WordTermCollector.FillSubword fillSubword) {
        this.fillSubword = fillSubword;
    }

    @Override
    public void collect(@Nullable char[] txtChars, @NotNull Wordnet wordnet, @NotNull Wordpath wordPath, @NotNull Consumer<WordTerm> consumer) {
        Intrinsics.checkParameterIsNotNull((Object)wordnet, (String)"wordnet");
        Intrinsics.checkParameterIsNotNull((Object)wordPath, (String)"wordPath");
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        Iterator<Vertex> vertexIterator = wordPath.iteratorVertex();
        WordTermCollector.FillSubword fillSubword = this.getFillSubword();
        if (fillSubword != null) {
            fillSubword.fill(wordnet, wordPath);
        }
        while (vertexIterator.hasNext()) {
            String string;
            Vertex vertex = vertexIterator.next();
            if (txtChars == null) {
                string = vertex.realWord();
            } else {
                int n = vertex.offset();
                int n2 = vertex.length;
                boolean bl = false;
                string = new String(txtChars, n, n2);
            }
            String word = string;
            WordTerm term = new WordTerm(word, vertex.nature, vertex.offset());
            if (StringUtils.isWhiteSpace((String)term.word)) continue;
            WordTermCollector.PickUpSubword pick = this.getPickUpSubword();
            if (pick != null && term.length() >= 3) {
                pick.pickup(term, wordnet, wordPath);
            }
            consumer.accept(term);
        }
    }
}

