/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.customwords;

import com.mayabot.nlp.MynlpEnv;
import com.mayabot.nlp.SettingItem;
import com.mayabot.nlp.collection.dat.DoubleArrayTrieStringIntMap;
import com.mayabot.nlp.injector.Singleton;
import com.mayabot.nlp.logging.InternalLogger;
import com.mayabot.nlp.logging.InternalLoggerFactory;
import com.mayabot.nlp.resources.NlpResource;
import com.mayabot.nlp.resources.UseLines;
import com.mayabot.nlp.segment.plugins.customwords.CustomDictionary;
import com.mayabot.nlp.utils.CharNormUtils;
import com.mayabot.nlp.utils.CharSourceLineReader;
import java.io.InputStream;
import java.util.List;
import java.util.TreeMap;

@Singleton
public class DefaultCustomDictionary
implements CustomDictionary {
    static InternalLogger logger = InternalLoggerFactory.getInstance(DefaultCustomDictionary.class);
    private DoubleArrayTrieStringIntMap dat;
    private List<String> resourceUrls;
    private boolean isNormalization = false;
    public static final SettingItem<String> dictPathSetting = SettingItem.string((String)"custom.dictionary.path", (String)"custom-dict/CustomDictionary.txt");

    public DefaultCustomDictionary(MynlpEnv mynlp) throws Exception {
        List resourceUrls = mynlp.getSettings().getAsList(dictPathSetting);
        if (resourceUrls == null || resourceUrls.isEmpty()) {
            return;
        }
        this.resourceUrls = resourceUrls;
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (String url : resourceUrls) {
            NlpResource resource = mynlp.tryLoadResource(url);
            if (resource == null) {
                logger.warn("miss resource " + url);
                continue;
            }
            CharSourceLineReader reader = UseLines.lineReader((InputStream)resource.inputStream());
            Throwable throwable = null;
            try {
                while (reader.hasNext()) {
                    String line = (String)reader.next();
                    String[] params = line.split("\\s");
                    if (this.isNormalization) {
                        params[0] = this.normalizationString(params[0]);
                    }
                    map.put(params[0], 1000);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
        if (map.isEmpty()) {
            return;
        }
        this.dat = new DoubleArrayTrieStringIntMap(map);
    }

    private String normalizationString(String text) {
        return CharNormUtils.convert((String)text);
    }

    @Override
    public DoubleArrayTrieStringIntMap getTrie() {
        return this.dat;
    }
}

