/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.personname;

import com.mayabot.nlp.injector.Singleton;
import com.mayabot.nlp.segment.Nature;
import com.mayabot.nlp.segment.WordSplitAlgorithm;
import com.mayabot.nlp.segment.common.BaseSegmentComponent;
import com.mayabot.nlp.segment.plugins.personname.PerceptronPersonNameService;
import com.mayabot.nlp.segment.plugins.personname.PersonName;
import com.mayabot.nlp.segment.wordnet.Vertex;
import com.mayabot.nlp.segment.wordnet.Wordnet;
import java.util.List;

@Singleton
public class PersonNameAlgorithm
extends BaseSegmentComponent
implements WordSplitAlgorithm {
    private final PerceptronPersonNameService service;

    public PersonNameAlgorithm(PerceptronPersonNameService service) {
        super(0);
        this.service = service;
    }

    @Override
    public void fill(Wordnet wordnet) {
        char[] charArray = wordnet.getCharArray();
        List<PersonName> names = this.service.findName(charArray);
        if (!names.isEmpty()) {
            for (PersonName name : names) {
                if (wordnet.row(name.getOffset()).contains(name.getName().length())) continue;
                Vertex v = new Vertex(name.getName().length());
                v.setAbsWordNatureAndFreq(Nature.nr);
                wordnet.put(name.getOffset(), v);
            }
        }
    }
}

