/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.reader;

import com.mayabot.nlp.common.ParagraphReader;
import com.mayabot.nlp.segment.Lexer;
import com.mayabot.nlp.segment.WordTerm;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.AbstractIterator;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/mayabot/nlp/segment/reader/LexerIterator;", "Lkotlin/collections/AbstractIterator;", "Lcom/mayabot/nlp/segment/WordTerm;", "lexer", "Lcom/mayabot/nlp/segment/Lexer;", "paragraphReader", "Lcom/mayabot/nlp/common/ParagraphReader;", "(Lcom/mayabot/nlp/segment/Lexer;Lcom/mayabot/nlp/common/ParagraphReader;)V", "baseOffset", "", "buffer", "Ljava/util/LinkedList;", "lastTextLength", "getLexer", "()Lcom/mayabot/nlp/segment/Lexer;", "getParagraphReader", "()Lcom/mayabot/nlp/common/ParagraphReader;", "computeNext", "", "mynlp-segment"})
public final class LexerIterator
extends AbstractIterator<WordTerm> {
    private int baseOffset;
    private int lastTextLength;
    private final LinkedList<WordTerm> buffer;
    @NotNull
    private final Lexer lexer;
    @NotNull
    private final ParagraphReader paragraphReader;

    protected void computeNext() {
        block11: {
            String paragraph;
            block13: {
                block12: {
                    if (!this.buffer.isEmpty()) break block11;
                    paragraph = this.paragraphReader.next();
                    if (paragraph == null) break block12;
                    CharSequence charSequence = paragraph;
                    boolean bl = false;
                    if (!(charSequence.length() == 0)) break block13;
                }
                this.done();
                return;
            }
            if (this.lastTextLength == -1) {
                this.baseOffset = 0;
                this.lastTextLength = 0;
            } else {
                this.baseOffset = this.lastTextLength;
            }
            this.lastTextLength += paragraph.length();
            String string = paragraph;
            boolean bl = false;
            char[] cArray = string.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            char[] text = cArray;
            this.lexer.scan(text, new Consumer<WordTerm>(this){
                final /* synthetic */ LexerIterator this$0;

                public final void accept(WordTerm term) {
                    LexerIterator.access$getBuffer$p(this.this$0).add(term);
                }
                {
                    this.this$0 = lexerIterator;
                }
            });
        }
        if (this.buffer.isEmpty()) {
            this.done();
            return;
        }
        WordTerm term = this.buffer.pop();
        if (term == null) {
            this.done();
        } else {
            if (this.baseOffset != 0) {
                term.setOffset(term.getOffset() + this.baseOffset);
                if (term.hasSubword()) {
                    List<WordTerm> list = term.getSubword();
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"term.subword");
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        WordTerm s = (WordTerm)element$iv;
                        boolean bl = false;
                        s.offset += this.baseOffset;
                    }
                }
            }
            this.setNext(term);
        }
    }

    @NotNull
    public final Lexer getLexer() {
        return this.lexer;
    }

    @NotNull
    public final ParagraphReader getParagraphReader() {
        return this.paragraphReader;
    }

    public LexerIterator(@NotNull Lexer lexer, @NotNull ParagraphReader paragraphReader) {
        Intrinsics.checkParameterIsNotNull((Object)lexer, (String)"lexer");
        Intrinsics.checkParameterIsNotNull((Object)paragraphReader, (String)"paragraphReader");
        this.lexer = lexer;
        this.paragraphReader = paragraphReader;
        this.lastTextLength = -1;
        this.buffer = new LinkedList();
    }

    public static final /* synthetic */ LinkedList access$getBuffer$p(LexerIterator $this) {
        return $this.buffer;
    }
}

