/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.robust.autopatch;

import com.meituan.robust.autopatch.Config;
import java.util.HashMap;

public class NameManger {
    private static NameManger nameManger;
    private HashMap<String, String> patchNameMap = new HashMap();

    private NameManger() {
    }

    public static void init() {
        nameManger = new NameManger();
    }

    public static NameManger getInstance() {
        if (nameManger == null) {
            nameManger = new NameManger();
        }
        return nameManger;
    }

    public HashMap<String, String> getPatchNameMap() {
        return this.patchNameMap;
    }

    public String getPatchName(String className) {
        String patchName = this.getPatchNamWithoutRecord(className);
        this.patchNameMap.put(patchName, className);
        return patchName;
    }

    public String getInlinePatchName(String className) {
        String patchName = this.getInlinePatchNameWithoutRecord(className);
        this.patchNameMap.put(patchName, className);
        return patchName;
    }

    public String getInlinePatchNameWithoutRecord(String className) {
        String patchName = Config.patchPackageName + "." + className.substring(className.lastIndexOf(".") + 1) + "InLinePatch";
        return patchName;
    }

    public String getPatchNamWithoutRecord(String className) {
        String patchName = Config.patchPackageName + "." + className.substring(className.lastIndexOf(".") + 1) + "Patch";
        return patchName;
    }

    public String getPatchControlName(String simpleClassName) {
        return Config.patchPackageName + "." + simpleClassName + "Patch" + "Control";
    }

    public String getAssistClassName(String s) {
        this.patchNameMap.put(s + "RobustAssist", s + "RobustAssist");
        return s + "RobustAssist";
    }
}

