/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.robust.autopatch;

import com.meituan.robust.autopatch.ClassMapping;
import com.meituan.robust.autopatch.Config;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class ReadMapping {
    private static ReadMapping instance;
    private Map<String, ClassMapping> usedInModifiedClassMappingInfo = new HashMap<String, ClassMapping>();

    public static ReadMapping getInstance() {
        if (instance == null) {
            instance = new ReadMapping();
        }
        return instance;
    }

    public static void init() {
        instance = new ReadMapping();
    }

    private ReadMapping() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initMappingInfo() {
        FileInputStream is = null;
        boolean needBacktrace = true;
        try {
            is = new FileInputStream(Config.mappingFilePath);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"), 1024);
            String line = reader.readLine().trim();
            while (line != null) {
                line = line.trim();
                if (!needBacktrace) {
                    line = reader.readLine();
                    if (line == null) {
                        break;
                    }
                    line = line.trim();
                }
                needBacktrace = false;
                if (line.indexOf("->") <= 0 || line.indexOf(":") != line.length() - 1) continue;
                ClassMapping classMapping = new ClassMapping();
                classMapping.setClassName(line.substring(0, line.indexOf("->") - 1).trim());
                classMapping.setValueName(line.split("->")[1].substring(0, line.split("->")[1].length() - 1).trim());
                for (line = reader.readLine(); line != null; line = line.trim()) {
                    if ((line = line.trim()).endsWith(":")) {
                        needBacktrace = true;
                        break;
                    }
                    String[] lineinfo = line.split(" ");
                    if (lineinfo.length != 4) {
                        throw new RuntimeException("mapping line info is error  " + line);
                    }
                    if (lineinfo[1].contains("(") && lineinfo[1].contains(")")) {
                        classMapping.getMemberMapping().put(this.getMethodSigureWithReturnTypeInMapping(lineinfo[0].trim(), lineinfo[1].trim()), lineinfo[3].trim());
                    } else {
                        classMapping.getMemberMapping().put(lineinfo[1].trim(), lineinfo[3].trim());
                    }
                    line = reader.readLine();
                    if (line == null) break;
                }
                this.usedInModifiedClassMappingInfo.put(classMapping.getClassName(), classMapping);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public ClassMapping getClassMapping(String classname) {
        return this.usedInModifiedClassMappingInfo.get(classname);
    }

    public void setClassMapping(String classname, ClassMapping classMapping) {
        this.usedInModifiedClassMappingInfo.put(classname, classMapping);
    }

    public ClassMapping getClassMappingOrDefault(String classname) {
        ClassMapping defaultClassMapping = new ClassMapping();
        if (!Config.supportProGuard) {
            defaultClassMapping.setValueName(classname);
        }
        return this.usedInModifiedClassMappingInfo.getOrDefault(classname, defaultClassMapping);
    }

    public String getMethodSigureWithReturnTypeInMapping(String returnTypeWithNumber, String methodSignure) {
        if (methodSignure.contains(":")) {
            return this.getMethodSignureWithReturnType(returnTypeWithNumber.substring(returnTypeWithNumber.lastIndexOf(":") + 1), methodSignure.substring(0, methodSignure.indexOf(":")));
        }
        return this.getMethodSignureWithReturnType(returnTypeWithNumber.substring(returnTypeWithNumber.lastIndexOf(":") + 1), methodSignure);
    }

    public String getMethodSignureWithReturnType(String returnType, String methodSignure) {
        return returnType + " " + methodSignure;
    }
}

