/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.robust.utils;

import com.meituan.robust.Constants;
import com.meituan.robust.autopatch.ClassMapping;
import com.meituan.robust.autopatch.Config;
import com.meituan.robust.autopatch.NameManger;
import com.meituan.robust.autopatch.ReadMapping;
import com.meituan.robust.utils.JavaUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtPrimitiveType;

public class SmaliTool {
    private static SmaliTool instance;
    private boolean isInStaticRobustMethod = false;

    public static SmaliTool getInstance() {
        if (instance == null) {
            instance = new SmaliTool();
        }
        return instance;
    }

    private SmaliTool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dealObscureInSmali() {
        File diretory = new File(Config.robustGenerateDirectory + "classout" + File.separator + Config.patchPackageName.replaceAll("\\.", Matcher.quoteReplacement(File.separator)));
        if (!diretory.isDirectory() || diretory == null) {
            throw new RuntimeException(Config.robustGenerateDirectory + Config.patchPackageName.replaceAll(".", Matcher.quoteReplacement(File.separator)) + " contains no smali file error!! ");
        }
        List<File> smaliFileList = this.covertPathToFile(Config.robustGenerateDirectory + "classout" + File.separator, Config.newlyAddedClassNameList);
        for (File file : diretory.listFiles()) {
            smaliFileList.add(file);
        }
        for (File file : smaliFileList) {
            BufferedWriter writer = null;
            BufferedReader reader = null;
            StringBuilder fileContent = new StringBuilder();
            try {
                String line;
                reader = new BufferedReader(new FileReader(file));
                int lineNo = 1;
                while ((line = reader.readLine()) != null) {
                    fileContent.append(this.dealWithSmaliLine(line, JavaUtils.getFullClassNameFromFile(file.getPath())) + "\n");
                    ++lineNo;
                }
                writer = new BufferedWriter(new FileWriter(file));
                writer.write(fileContent.toString());
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (writer == null) continue;
                try {
                    writer.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private List<File> covertPathToFile(String directory, List<String> packNameList) {
        if (packNameList == null) {
            return new ArrayList<File>();
        }
        ArrayList<File> fileList = new ArrayList<File>();
        for (String packname : packNameList) {
            fileList.add(new File(directory + packname.replaceAll("\\.", Matcher.quoteReplacement(File.separator)) + ".smali"));
        }
        return fileList;
    }

    private String dealWithSmaliLine(String line, String fullClassName) {
        int index;
        if (null == line || line.length() < 1 || line.startsWith("#")) {
            return line;
        }
        if (Config.newlyAddedClassNameList.contains(fullClassName)) {
            List<String> packNameFromSmaliLine;
            if (ReadMapping.getInstance().getClassMapping(fullClassName) == null) {
                ClassMapping classMapping = new ClassMapping();
                classMapping.setClassName(fullClassName);
                classMapping.setValueName(fullClassName);
                ReadMapping.getInstance().setClassMapping(fullClassName, classMapping);
            }
            if ((line.startsWith(".super") || line.startsWith(".implements")) && (packNameFromSmaliLine = this.getPackNameFromSmaliLine(line)).size() > 0) {
                String className = packNameFromSmaliLine.get(0).replaceAll("/", "\\.");
                ClassMapping superClassMapping = ReadMapping.getInstance().getClassMapping(className);
                ClassMapping newClassMapping = ReadMapping.getInstance().getClassMapping(fullClassName);
                if (superClassMapping != null) {
                    for (String key : superClassMapping.getMemberMapping().keySet()) {
                        if (newClassMapping.getMemberMapping().containsKey(key)) continue;
                        newClassMapping.getMemberMapping().put(key, superClassMapping.getMemberMapping().get(key));
                    }
                }
            }
        }
        String result = this.invokeSuperMethodInSmali(line, fullClassName);
        int previousPackageNameIndex = 0;
        List<String> packageNameList = this.getPackNameFromSmaliLine(result);
        Collections.sort(packageNameList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
        for (index = 0; packageNameList != null && index < packageNameList.size(); ++index) {
            int packageNameIndex;
            if (result.indexOf(packageNameList.get(index)) != result.lastIndexOf(packageNameList.get(index))) {
                packageNameIndex = result.indexOf(packageNameList.get(index), previousPackageNameIndex);
                previousPackageNameIndex = packageNameIndex + packageNameList.get(index).length();
            } else {
                packageNameIndex = result.indexOf(packageNameList.get(index));
            }
            if (result.contains("invoke") && packageNameIndex + packageNameList.get(index).length() + 3 < result.length() && result.substring(packageNameIndex + packageNameList.get(index).length() + 1, packageNameIndex + packageNameList.get(index).length() + 3).equals("->")) {
                result = result.replace(result.substring(packageNameIndex + packageNameList.get(index).length() + 3, result.indexOf(")") + 1), this.getObscuredMethodSignure(result.substring(packageNameIndex + packageNameList.get(index).length() + 3), packageNameList.get(index).replaceAll("/", "\\.")));
                continue;
            }
            if (!result.contains("->") || result.indexOf("(") != -1 || packageNameIndex + packageNameList.get(index).length() + 3 >= result.length()) continue;
            String fieldName = result.substring(packageNameIndex + packageNameList.get(index).length() + 3, result.lastIndexOf(":"));
            result = result.replaceFirst("->" + fieldName, "->" + this.getObscuredMemberName(packageNameList.get(index).replaceAll("/", "\\."), fieldName));
        }
        if (Config.newlyAddedClassNameList.contains(fullClassName) && result.startsWith(".method ") && !result.contains("constructor <init>") && !result.contains("constructor <clinit>")) {
            int start;
            System.out.println("new Add class: line = " + line);
            for (start = result.indexOf("("); start >= 0 && line.charAt(start) != ' '; --start) {
            }
            String methodSignature = result.substring(start + 1);
            result = result.replace(methodSignature.substring(0, methodSignature.indexOf(")") + 1), this.getObscuredMethodSignure(methodSignature, fullClassName));
        }
        for (index = 0; packageNameList != null && index < packageNameList.size(); ++index) {
            result = result.replace(packageNameList.get(index), this.getObscuredClassName(packageNameList.get(index)));
        }
        return result;
    }

    private String invokeSuperMethodInSmali(String line, String fullClassName) {
        if (line.startsWith(".method public static staticRobust")) {
            this.isInStaticRobustMethod = true;
        }
        String result = line;
        List<CtMethod> invokeSuperMethodList = Config.invokeSuperMethodMap.get(NameManger.getInstance().getPatchNameMap().get(fullClassName));
        if (this.isInStaticRobustMethod && line.contains("invoke-virtual")) {
            for (CtMethod ctMethod : invokeSuperMethodList) {
                if (!(ctMethod.getName().replaceAll("\\.", "/") + ctMethod.getSignature().subSequence(0, ctMethod.getSignature().indexOf(")") + 1)).equals(this.getMethodSignureInSmaliLine(line))) continue;
                result = line.replace("invoke-virtual", "invoke-super");
                try {
                    String returnType = !ctMethod.getReturnType().isPrimitive() ? "L" + ctMethod.getReturnType().getName().replaceAll("\\.", "/") : String.valueOf(((CtPrimitiveType)ctMethod.getReturnType()).getDescriptor());
                    if (NameManger.getInstance().getPatchNameMap().get(fullClassName).equals(fullClassName)) {
                        result = result.replace("p0", "p1");
                    }
                    String fullClassNameInSmali = ctMethod.getDeclaringClass().getClassPool().get(fullClassName).getSuperclass().getName().replaceAll("\\.", "/");
                    result = result.replace(result.substring(result.indexOf(Constants.PACKNAME_START) + 1, result.indexOf(";")), fullClassNameInSmali);
                    result = result.substring(0, result.indexOf(")") + 1) + returnType;
                    if (ctMethod.getReturnType().isPrimitive()) continue;
                    result = result + ";";
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.isInStaticRobustMethod && line.startsWith(".end method")) {
            this.isInStaticRobustMethod = false;
        }
        return result;
    }

    private String getMethodSignureInSmaliLine(String s) {
        return s.substring(s.indexOf("->") + 2, s.indexOf(")") + 1);
    }

    private List<String> getPackNameFromSmaliLine(String line) {
        ArrayList<String> packageNameList = new ArrayList<String>();
        if (null == line) {
            return packageNameList;
        }
        while (line != null && line.length() > 0) {
            int startIndex = 0;
            while ((startIndex = line.indexOf(Constants.PACKNAME_START, startIndex + 1)) >= 0 && Character.isLetter(line.charAt(startIndex - 1)) && line.lastIndexOf(Constants.PACKNAME_START) != startIndex) {
            }
            int endIndex = line.indexOf(";", startIndex);
            if (startIndex < 0 || endIndex < 0) break;
            packageNameList.add(line.substring(startIndex + 1, endIndex));
            line = line.substring(endIndex);
        }
        return packageNameList;
    }

    public static void main(String[] args) {
        SmaliTool smaliUitils = new SmaliTool();
        smaliUitils.getObscuredMethodSignure("invokeReflectConstruct(Ljava/lang/String;[Ljava/lang/Object;[Ljava/lang/Class;)Ljava/lang/Object;", "com.meituan.second");
    }

    private String getObscuredMethodSignure(String line, String className) {
        if (className.endsWith("Patch") && Config.modifiedClassNameList.contains(className.substring(0, className.indexOf("Patch")))) {
            className = className.substring(0, className.indexOf("Patch"));
        }
        StringBuilder methodSignureBuilder = new StringBuilder();
        methodSignureBuilder.append(line.substring(0, line.indexOf("(") + 1));
        String parameter = line.substring(line.indexOf("("), line.indexOf(")") + 1);
        int endIndex = line.indexOf(")");
        String methodSigure = line.substring(0, endIndex + 1);
        boolean isArray = false;
        for (int index = line.indexOf("(") + 1; index < endIndex; ++index) {
            if (Constants.PACKNAME_START.equals(String.valueOf(methodSigure.charAt(index))) && methodSigure.contains(";")) {
                methodSignureBuilder.append(methodSigure.substring(index + 1, methodSigure.indexOf(";", index)).replaceAll("/", "\\."));
                if (isArray) {
                    methodSignureBuilder.append("[]");
                    isArray = false;
                }
                index = methodSigure.indexOf(";", index);
                methodSignureBuilder.append(",");
            }
            if ("ZCBSIJFDV".contains(String.valueOf(methodSigure.charAt(index)))) {
                switch (methodSigure.charAt(index)) {
                    case 'Z': {
                        methodSignureBuilder.append("boolean");
                        break;
                    }
                    case 'C': {
                        methodSignureBuilder.append("char");
                        break;
                    }
                    case 'B': {
                        methodSignureBuilder.append("byte");
                        break;
                    }
                    case 'S': {
                        methodSignureBuilder.append("short");
                        break;
                    }
                    case 'I': {
                        methodSignureBuilder.append("int");
                        break;
                    }
                    case 'J': {
                        methodSignureBuilder.append("long");
                        break;
                    }
                    case 'F': {
                        methodSignureBuilder.append("float");
                        break;
                    }
                    case 'D': {
                        methodSignureBuilder.append("double");
                        break;
                    }
                    case 'V': {
                        methodSignureBuilder.append("void");
                        break;
                    }
                }
                if (isArray) {
                    methodSignureBuilder.append("[]");
                    isArray = false;
                }
                methodSignureBuilder.append(",");
            }
            if (!"[".equals(String.valueOf(methodSigure.charAt(index)))) continue;
            isArray = true;
        }
        List<String> returnTypeList = this.gePackageNameFromSmaliLine(line.substring(endIndex + 1));
        if (String.valueOf(methodSignureBuilder.charAt(methodSignureBuilder.toString().length() - 1)).equals(",")) {
            methodSignureBuilder.deleteCharAt(methodSignureBuilder.toString().length() - 1);
        }
        methodSignureBuilder.append(")");
        String obscuredMethodSignure = methodSignureBuilder.toString();
        String obscuredMethodName = this.getObscuredMemberName(className, ReadMapping.getInstance().getMethodSignureWithReturnType(returnTypeList.get(0), obscuredMethodSignure));
        obscuredMethodSignure = obscuredMethodName + parameter;
        return obscuredMethodSignure.substring(0, obscuredMethodSignure.indexOf("(")) + parameter;
    }

    private List<String> gePackageNameFromSmaliLine(String smaliLine) {
        ArrayList<String> packageNameList = new ArrayList<String>();
        block11: for (int index = 0; index < smaliLine.length(); ++index) {
            if (Constants.PACKNAME_START.equals(String.valueOf(smaliLine.charAt(index))) && smaliLine.indexOf(";") != -1) {
                packageNameList.add(smaliLine.substring(index + 1, smaliLine.indexOf(";", index)).replaceAll("/", "\\."));
                index = smaliLine.indexOf(";", index);
            }
            if (!"ZCBSIJFDV".contains(String.valueOf(smaliLine.charAt(index)))) continue;
            switch (smaliLine.charAt(index)) {
                case 'Z': {
                    packageNameList.add("boolean");
                    continue block11;
                }
                case 'C': {
                    packageNameList.add("char");
                    continue block11;
                }
                case 'B': {
                    packageNameList.add("byte");
                    continue block11;
                }
                case 'S': {
                    packageNameList.add("short");
                    continue block11;
                }
                case 'I': {
                    packageNameList.add("int");
                    continue block11;
                }
                case 'J': {
                    packageNameList.add("long");
                    continue block11;
                }
                case 'F': {
                    packageNameList.add("float");
                    continue block11;
                }
                case 'D': {
                    packageNameList.add("double");
                    continue block11;
                }
                case 'V': {
                    packageNameList.add("void");
                    continue block11;
                }
            }
        }
        return packageNameList;
    }

    private String getObscuredMemberName(String className, String memberName) {
        ClassMapping classMapping = ReadMapping.getInstance().getClassMapping(className);
        if (classMapping == null) {
            System.out.println("Warning: getObscuredMemberName  class  name " + className + "   member name is  " + memberName + "  robust can not find in mapping!!! ");
            return JavaUtils.eradicatReturnType(memberName);
        }
        while (classMapping != null && !"java.lang.Object".equals(classMapping.getClassName())) {
            if (classMapping.getMemberMapping().get(memberName) != null) {
                return classMapping.getMemberMapping().get(memberName);
            }
            try {
                CtClass superClass = Config.classPool.get(classMapping.getClassName()).getSuperclass();
                while (ReadMapping.getInstance().getClassMapping(superClass.getName()) == null && !"java.lang.Object".equals(superClass.getName())) {
                    superClass = superClass.getSuperclass();
                }
                classMapping = ReadMapping.getInstance().getClassMapping(superClass.getName());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return JavaUtils.eradicatReturnType(memberName);
    }

    private String getObscuredClassName(String className) {
        ClassMapping classMapping = ReadMapping.getInstance().getClassMapping(className.replaceAll("/", "\\."));
        if (null == classMapping || classMapping.getValueName() == null) {
            return className;
        }
        return classMapping.getValueName().replaceAll("\\.", "/");
    }
}

