/*
 * Decompiled with CFR 0.152.
 */
package robust.gradle.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.NotFoundException;

public abstract class InsertcodeStrategy {
    protected List<String> hotfixPackageList = new ArrayList<String>();
    protected List<String> hotfixMethodList = new ArrayList<String>();
    protected List<String> exceptPackageList = new ArrayList<String>();
    protected List<String> exceptMethodList = new ArrayList<String>();
    protected boolean isHotfixMethodLevel = false;
    protected boolean isExceptMethodLevel = false;
    protected boolean isForceInsertLambda = false;
    protected AtomicInteger insertMethodCount = new AtomicInteger(0);
    public HashMap<String, Integer> methodMap = new LinkedHashMap<String, Integer>();

    public InsertcodeStrategy(List<String> hotfixPackageList, List<String> hotfixMethodList, List<String> exceptPackageList, List<String> exceptMethodList, boolean isHotfixMethodLevel, boolean isExceptMethodLevel, boolean isForceInsertLambda) {
        this.hotfixPackageList = hotfixPackageList;
        this.hotfixMethodList = hotfixMethodList;
        this.exceptPackageList = exceptPackageList;
        this.exceptMethodList = exceptMethodList;
        this.isHotfixMethodLevel = isHotfixMethodLevel;
        this.isExceptMethodLevel = isExceptMethodLevel;
        this.isForceInsertLambda = isForceInsertLambda;
        this.insertMethodCount.set(0);
    }

    protected abstract void insertCode(List<CtClass> var1, File var2) throws CannotCompileException, IOException, NotFoundException;

    protected boolean isNeedInsertClass(String className) {
        for (String exceptName : this.exceptPackageList) {
            if (!className.startsWith(exceptName)) continue;
            return false;
        }
        for (String name : this.hotfixPackageList) {
            if (!className.startsWith(name)) continue;
            return true;
        }
        return false;
    }

    protected void zipFile(byte[] classBytesArray, ZipOutputStream zos, String entryName) {
        try {
            ZipEntry entry = new ZipEntry(entryName);
            zos.putNextEntry(entry);
            zos.write(classBytesArray, 0, classBytesArray.length);
            zos.closeEntry();
            zos.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

