/*
 * Decompiled with CFR 0.152.
 */
package robust.gradle.plugin.asm;

import com.meituan.robust.ChangeQuickRedirect;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarOutputStream;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.bytecode.AccessFlag;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import robust.gradle.plugin.InsertcodeStrategy;
import robust.gradle.plugin.asm.RobustAsmUtils;

public class AsmInsertImpl
extends InsertcodeStrategy {
    public AsmInsertImpl(List<String> hotfixPackageList, List<String> hotfixMethodList, List<String> exceptPackageList, List<String> exceptMethodList, boolean isHotfixMethodLevel, boolean isExceptMethodLevel, boolean isForceInsertLambda) {
        super(hotfixPackageList, hotfixMethodList, exceptPackageList, exceptMethodList, isHotfixMethodLevel, isExceptMethodLevel, isForceInsertLambda);
    }

    @Override
    protected void insertCode(List<CtClass> box, File jarFile) throws IOException, CannotCompileException {
        JarOutputStream outStream = new JarOutputStream(new FileOutputStream(jarFile));
        for (CtClass ctClass : box) {
            ctClass.setModifiers(AccessFlag.setPublic((int)ctClass.getModifiers()));
            if (this.isNeedInsertClass(ctClass.getName()) && !ctClass.isInterface() && ctClass.getDeclaredMethods().length >= 1) {
                this.zipFile(this.transformCode(ctClass.toBytecode(), ctClass.getName().replaceAll("\\.", "/")), outStream, ctClass.getName().replaceAll("\\.", "/") + ".class");
            } else {
                this.zipFile(ctClass.toBytecode(), outStream, ctClass.getName().replaceAll("\\.", "/") + ".class");
            }
            ctClass.defrost();
        }
        outStream.close();
    }

    public byte[] transformCode(byte[] b1, String className) throws IOException {
        ClassWriter cw = new ClassWriter(1);
        ClassReader cr = new ClassReader(b1);
        ClassNode classNode = new ClassNode();
        HashMap<String, Boolean> methodInstructionTypeMap = new HashMap<String, Boolean>();
        cr.accept((ClassVisitor)classNode, 0);
        List methods = classNode.methods;
        for (MethodNode m : methods) {
            InsnList inList = m.instructions;
            boolean isMethodInvoke = false;
            for (int i = 0; i < inList.size(); ++i) {
                if (inList.get(i).getType() != 5) continue;
                isMethodInvoke = true;
            }
            methodInstructionTypeMap.put(m.name + m.desc, isMethodInvoke);
        }
        InsertMethodBodyAdapter insertMethodBodyAdapter = new InsertMethodBodyAdapter(cw, className, methodInstructionTypeMap);
        cr.accept((ClassVisitor)insertMethodBodyAdapter, 8);
        return cw.toByteArray();
    }

    private class InsertMethodBodyAdapter
    extends ClassVisitor
    implements Opcodes {
        ClassWriter classWriter;
        private String className;
        private Map<String, Boolean> methodInstructionTypeMap;

        public InsertMethodBodyAdapter() {
            super(327680);
        }

        public InsertMethodBodyAdapter(ClassWriter cw, String className, Map<String, Boolean> methodInstructionTypeMap) {
            super(327680, (ClassVisitor)cw);
            this.classWriter = cw;
            this.className = className;
            this.methodInstructionTypeMap = methodInstructionTypeMap;
            this.classWriter.visitField(9, "changeQuickRedirect", Type.getDescriptor(ChangeQuickRedirect.class), null, null);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            Type[] types;
            if (this.isProtect(access)) {
                access = this.setPublic(access);
            }
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if (!this.isQualifiedMethod(access, name, desc, this.methodInstructionTypeMap)) {
                return mv;
            }
            StringBuilder parameters = new StringBuilder();
            for (Type type : types = Type.getArgumentTypes((String)desc)) {
                parameters.append(type.getClassName()).append(",");
            }
            if (parameters.length() > 0 && parameters.charAt(parameters.length() - 1) == ',') {
                parameters.deleteCharAt(parameters.length() - 1);
            }
            AsmInsertImpl.this.methodMap.put(this.className.replace('/', '.') + "." + name + "(" + parameters.toString() + ")", AsmInsertImpl.this.insertMethodCount.incrementAndGet());
            return new MethodBodyInsertor(mv, this.className, desc, this.isStatic(access), String.valueOf(AsmInsertImpl.this.insertMethodCount.get()), name, access);
        }

        private boolean isProtect(int access) {
            return (access & 4) != 0;
        }

        private int setPublic(int access) {
            return access & 0xFFFFFFF9 | 1;
        }

        private boolean isQualifiedMethod(int access, String name, String desc, Map<String, Boolean> c) {
            boolean isMethodInvoke;
            if ("<clinit>".equals(name) || "<init>".equals(name)) {
                return false;
            }
            if (!AsmInsertImpl.this.isForceInsertLambda && (access & 0x1000) != 0 && (access & 2) == 0) {
                return false;
            }
            if ((access & 0x400) != 0) {
                return false;
            }
            if ((access & 0x100) != 0) {
                return false;
            }
            if ((access & 0x200) != 0) {
                return false;
            }
            if ((access & 0x20000) != 0) {
                return false;
            }
            if (AsmInsertImpl.this.isExceptMethodLevel && AsmInsertImpl.this.exceptMethodList != null) {
                for (String item : AsmInsertImpl.this.exceptMethodList) {
                    if (!name.matches(item)) continue;
                    return false;
                }
            }
            if (AsmInsertImpl.this.isHotfixMethodLevel && AsmInsertImpl.this.hotfixMethodList != null) {
                for (String item : AsmInsertImpl.this.hotfixMethodList) {
                    if (!name.matches(item)) continue;
                    return true;
                }
            }
            if (!(isMethodInvoke = this.methodInstructionTypeMap.getOrDefault(name + desc, false).booleanValue())) {
                return false;
            }
            return !AsmInsertImpl.this.isHotfixMethodLevel;
        }

        private boolean isStatic(int access) {
            return (access & 8) != 0;
        }

        class MethodBodyInsertor
        extends GeneratorAdapter
        implements Opcodes {
            private String className;
            private Type[] argsType;
            private Type returnType;
            List<Type> paramsTypeClass;
            boolean isStatic;
            String methodId;

            public MethodBodyInsertor(MethodVisitor mv, String className, String desc, boolean isStatic, String methodId, String name, int access) {
                Type[] argsType;
                super(327680, mv, access, name, desc);
                this.paramsTypeClass = new ArrayList<Type>();
                this.className = className;
                this.returnType = Type.getReturnType((String)desc);
                for (Type type : argsType = Type.getArgumentTypes((String)desc)) {
                    this.paramsTypeClass.add(type);
                }
                this.isStatic = isStatic;
                this.methodId = methodId;
            }

            public void visitCode() {
                RobustAsmUtils.createInsertCode(this, this.className, this.paramsTypeClass, this.returnType, this.isStatic, Integer.valueOf(this.methodId));
            }
        }
    }
}

