/*
 * Decompiled with CFR 0.152.
 */
package robust.gradle.plugin.asm;

import com.meituan.robust.ChangeQuickRedirect;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

public final class RobustAsmUtils {
    public static final String REDIRECTFIELD_NAME = "changeQuickRedirect";
    public static final String REDIRECTCLASSNAME = Type.getDescriptor(ChangeQuickRedirect.class);
    public static final String PROXYCLASSNAME = "com.meituan.robust.PatchProxy".replace(".", "/");

    public static void createInsertCode(GeneratorAdapter mv, String className, List<Type> args, Type returnType, boolean isStatic, int methodId) {
        RobustAsmUtils.prepareMethodParameters(mv, className, args, returnType, isStatic, methodId);
        mv.visitMethodInsn(184, PROXYCLASSNAME, "proxy", "([Ljava/lang/Object;Ljava/lang/Object;" + REDIRECTCLASSNAME + "ZI[Ljava/lang/Class;Ljava/lang/Class;)Lcom/meituan/robust/PatchProxyResult;", false);
        int local = mv.newLocal(Type.getType((String)"Lcom/meituan/robust/PatchProxyResult;"));
        mv.storeLocal(local);
        mv.loadLocal(local);
        mv.visitFieldInsn(180, "com/meituan/robust/PatchProxyResult", "isSupported", "Z");
        Label l1 = new Label();
        mv.visitJumpInsn(153, l1);
        if ("V".equals(returnType.getDescriptor())) {
            mv.visitInsn(177);
        } else {
            mv.loadLocal(local);
            mv.visitFieldInsn(180, "com/meituan/robust/PatchProxyResult", "result", "Ljava/lang/Object;");
            if (!RobustAsmUtils.castPrimateToObj((MethodVisitor)mv, returnType.getDescriptor())) {
                String newTypeStr = null;
                int len = returnType.getDescriptor().length();
                newTypeStr = returnType.getDescriptor().startsWith("[") ? returnType.getDescriptor().substring(0, len) : returnType.getDescriptor().substring(1, len - 1);
                mv.visitTypeInsn(192, newTypeStr);
            }
            mv.visitInsn(RobustAsmUtils.getReturnTypeCode(returnType.getDescriptor()));
        }
        mv.visitLabel(l1);
    }

    private static void prepareMethodParameters(GeneratorAdapter mv, String className, List<Type> args, Type returnType, boolean isStatic, int methodId) {
        if (args.size() == 0) {
            mv.visitInsn(3);
            mv.visitTypeInsn(189, "java/lang/Object");
        } else {
            RobustAsmUtils.createObjectArray((MethodVisitor)mv, args, isStatic);
        }
        if (isStatic) {
            mv.visitInsn(1);
        } else {
            mv.visitVarInsn(25, 0);
        }
        mv.visitFieldInsn(178, className, REDIRECTFIELD_NAME, REDIRECTCLASSNAME);
        mv.visitInsn(isStatic ? 4 : 3);
        mv.push(methodId);
        RobustAsmUtils.createClassArray(mv, args);
        RobustAsmUtils.createReturnClass(mv, returnType);
    }

    private static void createReturnClass(GeneratorAdapter mv, Type returnType) {
        RobustAsmUtils.redirectLocal(mv, returnType);
    }

    private static void createClassArray(GeneratorAdapter mv, List<Type> args) {
        RobustAsmUtils.createLocals(mv, args);
        boolean stackIndex = false;
        for (int arrayIndex = 0; arrayIndex < args.size(); ++arrayIndex) {
            Type arg = args.get(arrayIndex);
            mv.dup();
            mv.push(arrayIndex);
            RobustAsmUtils.redirectLocal(mv, arg);
            mv.arrayStore(Type.getType(Class.class));
        }
    }

    protected static void createLocals(GeneratorAdapter mv, List<Type> args) {
        mv.push(args.size());
        mv.newArray(Type.getType(Class.class));
    }

    protected static void redirectLocal(GeneratorAdapter mv, Type arg) {
        switch (arg.getDescriptor()) {
            case "Z": {
                mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case "B": {
                mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case "C": {
                mv.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case "S": {
                mv.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case "I": {
                mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case "F": {
                mv.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case "D": {
                mv.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case "J": {
                mv.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case "V": {
                mv.visitFieldInsn(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                break;
            }
            default: {
                mv.visitLdcInsn((Object)Type.getType((String)arg.getDescriptor()));
            }
        }
    }

    private static void createObjectArray(MethodVisitor mv, List<Type> paramsTypeClass, boolean isStatic) {
        int argsCount = paramsTypeClass.size();
        if (argsCount >= 6) {
            mv.visitIntInsn(16, argsCount);
        } else {
            mv.visitInsn(3 + argsCount);
        }
        mv.visitTypeInsn(189, "java/lang/Object");
        int loadIndex = isStatic ? 0 : 1;
        for (int i = 0; i < argsCount; ++i) {
            mv.visitInsn(89);
            if (i <= 5) {
                mv.visitInsn(3 + i);
            } else {
                mv.visitIntInsn(16, i);
            }
            if (i >= 1 && ("J".equals(paramsTypeClass.get(i - 1).getDescriptor()) || "D".equals(paramsTypeClass.get(i - 1).getDescriptor()))) {
                ++loadIndex;
            }
            if (!RobustAsmUtils.createPrimateTypeObj(mv, loadIndex, paramsTypeClass.get(i).getDescriptor())) {
                mv.visitVarInsn(25, loadIndex);
                mv.visitInsn(83);
            }
            ++loadIndex;
        }
    }

    private static void createBooleanObj(MethodVisitor mv, int argsPostion) {
        mv.visitTypeInsn(187, "java/lang/Byte");
        mv.visitInsn(89);
        mv.visitVarInsn(21, argsPostion);
        mv.visitMethodInsn(183, "java/lang/Byte", "<init>", "(B)V");
        mv.visitInsn(83);
    }

    private static void createShortObj(MethodVisitor mv, int argsPostion) {
        mv.visitTypeInsn(187, "java/lang/Short");
        mv.visitInsn(89);
        mv.visitVarInsn(21, argsPostion);
        mv.visitMethodInsn(183, "java/lang/Short", "<init>", "(S)V");
        mv.visitInsn(83);
    }

    private static void createCharObj(MethodVisitor mv, int argsPostion) {
        mv.visitTypeInsn(187, "java/lang/Character");
        mv.visitInsn(89);
        mv.visitVarInsn(21, argsPostion);
        mv.visitMethodInsn(183, "java/lang/Character", "<init>", "(C)V");
        mv.visitInsn(83);
    }

    private static void createIntegerObj(MethodVisitor mv, int argsPostion) {
        mv.visitTypeInsn(187, "java/lang/Integer");
        mv.visitInsn(89);
        mv.visitVarInsn(21, argsPostion);
        mv.visitMethodInsn(183, "java/lang/Integer", "<init>", "(I)V");
        mv.visitInsn(83);
    }

    private static void createFloatObj(MethodVisitor mv, int argsPostion) {
        mv.visitTypeInsn(187, "java/lang/Float");
        mv.visitInsn(89);
        mv.visitVarInsn(23, argsPostion);
        mv.visitMethodInsn(183, "java/lang/Float", "<init>", "(F)V");
        mv.visitInsn(83);
    }

    private static void createDoubleObj(MethodVisitor mv, int argsPostion) {
        mv.visitTypeInsn(187, "java/lang/Double");
        mv.visitInsn(89);
        mv.visitVarInsn(24, argsPostion);
        mv.visitMethodInsn(183, "java/lang/Double", "<init>", "(D)V");
        mv.visitInsn(83);
    }

    private static void createLongObj(MethodVisitor mv, int argsPostion) {
        mv.visitTypeInsn(187, "java/lang/Long");
        mv.visitInsn(89);
        mv.visitVarInsn(22, argsPostion);
        mv.visitMethodInsn(183, "java/lang/Long", "<init>", "(J)V");
        mv.visitInsn(83);
    }

    private static boolean createPrimateTypeObj(MethodVisitor mv, int argsPostion, String typeS) {
        if ("Z".equals(typeS)) {
            RobustAsmUtils.createBooleanObj(mv, argsPostion);
            return true;
        }
        if ("B".equals(typeS)) {
            RobustAsmUtils.createBooleanObj(mv, argsPostion);
            return true;
        }
        if ("C".equals(typeS)) {
            RobustAsmUtils.createCharObj(mv, argsPostion);
            return true;
        }
        if ("S".equals(typeS)) {
            RobustAsmUtils.createShortObj(mv, argsPostion);
            return true;
        }
        if ("I".equals(typeS)) {
            RobustAsmUtils.createIntegerObj(mv, argsPostion);
            return true;
        }
        if ("F".equals(typeS)) {
            RobustAsmUtils.createFloatObj(mv, argsPostion);
            return true;
        }
        if ("D".equals(typeS)) {
            RobustAsmUtils.createDoubleObj(mv, argsPostion);
            return true;
        }
        if ("J".equals(typeS)) {
            RobustAsmUtils.createLongObj(mv, argsPostion);
            return true;
        }
        return false;
    }

    private static boolean castPrimateToObj(MethodVisitor mv, String typeS) {
        if ("Z".equals(typeS)) {
            mv.visitTypeInsn(192, "java/lang/Boolean");
            mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
            return true;
        }
        if ("B".equals(typeS)) {
            mv.visitTypeInsn(192, "java/lang/Byte");
            mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
            return true;
        }
        if ("C".equals(typeS)) {
            mv.visitTypeInsn(192, "java/lang/Character");
            mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
            return true;
        }
        if ("S".equals(typeS)) {
            mv.visitTypeInsn(192, "java/lang/Short");
            mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
            return true;
        }
        if ("I".equals(typeS)) {
            mv.visitTypeInsn(192, "java/lang/Integer");
            mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
            return true;
        }
        if ("F".equals(typeS)) {
            mv.visitTypeInsn(192, "java/lang/Float");
            mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
            return true;
        }
        if ("D".equals(typeS)) {
            mv.visitTypeInsn(192, "java/lang/Double");
            mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
            return true;
        }
        if ("J".equals(typeS)) {
            mv.visitTypeInsn(192, "java/lang/Long");
            mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
            return true;
        }
        return false;
    }

    private static int getReturnTypeCode(String typeS) {
        if ("Z".equals(typeS)) {
            return 172;
        }
        if ("B".equals(typeS)) {
            return 172;
        }
        if ("C".equals(typeS)) {
            return 172;
        }
        if ("S".equals(typeS)) {
            return 172;
        }
        if ("I".equals(typeS)) {
            return 172;
        }
        if ("F".equals(typeS)) {
            return 174;
        }
        if ("D".equals(typeS)) {
            return 175;
        }
        if ("J".equals(typeS)) {
            return 173;
        }
        return 176;
    }
}

